/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.config.IConfigManager;
import com.nxp.swtools.utils.scripting.api.IScriptFileProvider;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConfigManager
implements IConfigManager,
IScriptFileProvider {
    private static final Logger LOGGER = LogManager.getLogger(ConfigManager.class);
    public static final String OPTIMIZATION_DIR_PROPERTY = "QCVS_OPTIMIZATION_DIR";
    public static final String OPTIMIZATION_DIR_ENV_VARIABLE = "QCVS_OPTIMIZATION_DIR";
    public static final String LOCAL_LOG_DIR = "mem_validation";
    public static final String LOCAL_SCRIPTS_DIR = "scripts";
    public static final String TEMPLATES_DIR = "templates";
    public static final String BINARIES_DIR = "binaries";
    public static final String CONNECTIONS_DIR = "connections";
    public static final String MAIN_SCRIPT = "s.py";
    public static final String DEBUG_OPTIMIZATION_DIR_ARG_PREFIX = "--optimization_dir=";
    public static final String DEBUG_SOC_FAMILY_ARG_PREFIX = "--soc_family=";
    public static final String DEBUG_SHOW_VALIDATION_OPTIONS = "--show-validation-options";
    public static final String DEBUG_MARGINS_SHOW_ADVANCED_LOGS = "--show-margins-advanced-logs";
    private static final String SUPPORT_DIR = "support";
    public static final String VALIDATION_TOOL_ID = "ValidationTool";
    public static final String EXT_POINT_CONFIG_PROVIDER = "com.nxp.swtools.mem.validation.configProvider";
    public static final String EXT_POINT_DIAGS_PROVIDER = "com.nxp.swtools.mem.validation.diagsProvider";
    public static final String TAG_CLASS = "class";
    private String mainDir;
    private String connectionsDir;
    private String componentConfigDir;
    private String socFamily;
    @Nullable
    private String logdir;

    private static String findSocFamily() {
        return "iMx";
    }

    public ConfigManager(String path) {
        this.mainDir = path;
        this.socFamily = ConfigManager.findSocFamily();
        this.componentConfigDir = String.valueOf(this.mainDir) + File.separator + "configs";
        this.connectionsDir = String.valueOf(this.mainDir) + File.separator + CONNECTIONS_DIR;
    }

    public boolean createValidationSpecificFolders() {
        File tmpDir = UtilsFile.createTempSubDirectory((String)LOCAL_LOG_DIR);
        if (tmpDir.exists()) {
            this.logdir = tmpDir.getAbsolutePath();
            return true;
        }
        return false;
    }

    public boolean cleanValidationFilesByExtension(String extension) {
        boolean filesDeleted = true;
        if (this.logdir != null) {
            List fileNames = UtilsFile.findFilesByExtension((String)this.logdir, (String)extension);
            for (String fileName : fileNames) {
                filesDeleted &= UtilsFile.deleteDirectory((File)UtilsFile.newFile((String)File.separator, (String[])new String[]{fileName}));
            }
        }
        return filesDeleted;
    }

    public @Nullable File findScriptFile(@NonNull String file) {
        Path path;
        @NonNull String @NonNull [] scriptFolders = new String[]{UtilsText.safeString((String)(String.valueOf(this.mainDir) + File.separator + BINARIES_DIR)), UtilsText.safeString((String)(String.valueOf(this.mainDir) + File.separator + TEMPLATES_DIR)), UtilsText.safeString((String)(String.valueOf(this.mainDir) + File.separator + LOCAL_SCRIPTS_DIR)), UtilsText.safeString((String)(String.valueOf(this.mainDir) + File.separator + SUPPORT_DIR))};
        try {
            path = Paths.get(file, new String[0]);
        }
        catch (InvalidPathException e) {
            LOGGER.info(e.getMessage());
            return null;
        }
        if (path.isAbsolute()) {
            File jsFile = path.toFile();
            return jsFile.exists() ? jsFile : null;
        }
        String[] stringArray = scriptFolders;
        int n = scriptFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String scriptFolder = stringArray[n2];
            File jsFile = new File(String.valueOf(scriptFolder) + File.separator + file);
            if (jsFile.exists()) {
                return jsFile;
            }
            ++n2;
        }
        return null;
    }

    public String getCgenConfigXmlPath() {
        return String.valueOf(this.componentConfigDir) + File.separator + "codegen.xml";
    }

    public String getConditionsConfigFile() {
        return String.valueOf(this.componentConfigDir) + File.separator + "conditions.xml";
    }

    @Override
    public String getConfigDir() {
        return this.componentConfigDir;
    }

    @Override
    public String getLocalDir() {
        return ".";
    }

    @Override
    public String getConnectionsDir() {
        return this.connectionsDir;
    }

    public @Nullable String getLogsFolder() {
        return this.logdir;
    }

    public String getMainDir() {
        return this.mainDir;
    }

    public String getScenariosConfigFile() {
        return String.valueOf(this.componentConfigDir) + File.separator + "scenarios.xml";
    }

    public String getScriptsConfigFile() {
        return String.valueOf(this.componentConfigDir) + File.separator + "scripts.xml";
    }

    public String getCustomConfigFile() {
        return String.valueOf(this.componentConfigDir) + File.separator + "custom_config.xml";
    }

    public String getConnectionsFile() {
        return String.valueOf(this.connectionsDir) + File.separator + "target_connections.xml";
    }

    public String getScriptsFolder() {
        return String.valueOf(this.mainDir) + File.separator + LOCAL_SCRIPTS_DIR;
    }

    public String getSocFamily() {
        return this.socFamily;
    }

    public String getSupportDir() {
        return String.valueOf(this.mainDir) + File.separator + SUPPORT_DIR;
    }

    public String getTablesConfigFile() {
        return String.valueOf(this.componentConfigDir) + File.separator + "tables.xml";
    }

    @Override
    public String getTemplateDir(Map<String, String> variables, String relativePath) {
        if (relativePath.startsWith("$")) {
            String varName = relativePath.substring(relativePath.indexOf("$") + 1, relativePath.indexOf("/"));
            String templateName = relativePath.substring(relativePath.indexOf("/"), relativePath.length());
            if (!varName.isEmpty() && variables.get(varName) != null) {
                return String.valueOf(this.mainDir) + File.separator + variables.get(varName) + templateName;
            }
            return "";
        }
        return String.valueOf(this.mainDir) + File.separator + relativePath;
    }

    public String getTestExecutablesDir() {
        return String.valueOf(this.mainDir) + File.separator + BINARIES_DIR;
    }

    public String getTemplatesDir() {
        return String.valueOf(this.mainDir) + File.separator + TEMPLATES_DIR;
    }
}

