/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections;

import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.ui.Messages;

public class JTAGConnection
extends Connection {
    private boolean useUsbConnection = true;
    private boolean validMACAddress = true;
    private String usbSerialNumber = "";
    private String hostname = "";

    JTAGConnection(Connection.SUPPORTED_CONNECTIONS connection) {
        super(connection);
        Connection currentValidationConnection = ValidationContext.getInstance().getCurrentConnection();
        if (currentValidationConnection instanceof JTAGConnection) {
            JTAGConnection currentJtagConnection = (JTAGConnection)currentValidationConnection;
            this.setUsbConnection(currentJtagConnection.isUsbConnection());
            this.setUsbSerialNumber(currentJtagConnection.getUsbSerialNumber());
            this.setHostname(currentJtagConnection.getHostname());
        }
    }

    JTAGConnection() {
        this(Connection.SUPPORTED_CONNECTIONS.JTAG_CONNECTION);
    }

    public boolean isUsbConnection() {
        return this.useUsbConnection;
    }

    public void setUsbConnection(boolean usbState) {
        this.useUsbConnection = usbState;
    }

    public String getUsbSerialNumber() {
        return this.usbSerialNumber;
    }

    public void setUsbSerialNumber(String usbNumber) {
        this.usbSerialNumber = usbNumber;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setValidMACAddress(boolean valid) {
        this.validMACAddress = valid;
    }

    @Override
    public boolean hasErrors() {
        return this.isUsbConnection() ? !this.validMACAddress : false;
    }

    @Override
    public String getErrorMessage() {
        return this.validMACAddress ? "" : Messages.InvalidMACAddress;
    }
}

