/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections;

import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.ui.Messages;
import com.nxp.swtools.mem.validation.utils.ConnectionUtils;

public class SerialConnection
extends Connection {
    private String comPort;
    private boolean isSerialApplicationChecked = false;
    private String securedAppPath;
    private String nonSecuredAppDir;

    public SerialConnection(Connection.SUPPORTED_CONNECTIONS connectionType) {
        super(connectionType);
        this.clockSource = 0;
        this.securedAppPath = "";
        this.nonSecuredAppDir = "";
        String currentValidationPort = "";
        Connection currentValidationConnection = ValidationContext.getInstance().getCurrentConnection();
        if (currentValidationConnection instanceof SerialConnection) {
            currentValidationPort = ((SerialConnection)currentValidationConnection).getComPort();
        }
        this.comPort = !currentValidationPort.isEmpty() ? currentValidationPort : ConnectionUtils.getCOMPorts()[0];
    }

    SerialConnection(String comPortArg, int clockSourceArg) {
        super(Connection.SUPPORTED_CONNECTIONS.SERIAL_CONNECTION);
        this.comPort = comPortArg;
        this.clockSource = clockSourceArg;
        this.securedAppPath = "";
        this.nonSecuredAppDir = "";
    }

    public String getComPort() {
        return this.comPort;
    }

    public String getSecuredAppPath() {
        return this.securedAppPath;
    }

    public String getNonSecuredAppDir() {
        return this.nonSecuredAppDir;
    }

    public boolean getSecuredAppOptionState() {
        return this.isSerialApplicationChecked;
    }

    public void setSecuredAppPath(String securedApplicationPath) {
        this.securedAppPath = securedApplicationPath;
    }

    public void setNonSecuredAppDir(String nonSecuredApplicationDir) {
        this.nonSecuredAppDir = nonSecuredApplicationDir;
    }

    public void setSecuredOptionCheckState(boolean isSerialAppOptionChecked) {
        this.isSerialApplicationChecked = isSerialAppOptionChecked;
    }

    public void setComPort(String comPortArg) {
        this.comPort = comPortArg;
    }

    @Override
    public int getClockSource() {
        return this.clockSource;
    }

    @Override
    public void setClockSource(int clockSourceArg) {
        this.clockSource = clockSourceArg;
    }

    @Override
    public boolean hasErrors() {
        boolean comPortError;
        boolean securedOptionErrors = this.isSerialApplicationChecked && this.securedAppPath.isEmpty();
        boolean bl = comPortError = this.comPort.isEmpty() || Messages.UNDEFINED_PORT_NAME.equals(this.comPort);
        return securedOptionErrors || comPortError;
    }

    @Override
    public String getErrorMessage() {
        if (this.comPort.isEmpty() || Messages.UNDEFINED_PORT_NAME.equals(this.comPort)) {
            return Messages.ERR_USB_PORT_NOT_SPECIFIED;
        }
        if (this.isSerialApplicationChecked && this.securedAppPath.isEmpty()) {
            return Messages.SECURED_PATH_NOT_SPECIFIED;
        }
        return "";
    }
}

