/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.jobs;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.RunScriptRequest;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.actions.RunAction;
import com.nxp.swtools.mem.validation.connections.actions.RunActionFactory;
import com.nxp.swtools.mem.validation.connections.actions.TestResult;
import com.nxp.swtools.mem.validation.jobs.JobName;
import com.nxp.swtools.mem.validation.jobs.ResourceNotFoundException;
import com.nxp.swtools.mem.validation.jobs.StopCondition;
import com.nxp.swtools.mem.validation.jobs.ValidationJobUpdater;
import com.nxp.swtools.mem.validation.listeners.CGenVEventListener;
import com.nxp.swtools.mem.validation.listeners.ConfigurationUpdater;
import com.nxp.swtools.mem.validation.listeners.CustomModelUpdaterListener;
import com.nxp.swtools.mem.validation.listeners.IValidationSessionEventListener;
import com.nxp.swtools.mem.validation.listeners.InitializeRegistersListener;
import com.nxp.swtools.mem.validation.listeners.PresentationModelUpdaterListener;
import com.nxp.swtools.mem.validation.listeners.ValidationStatisticsUpdaterListener;
import com.nxp.swtools.mem.validation.model.ARunResultsUpdaterListener;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.presenter.updaters.TimeoutReachedUiUpdater;
import com.nxp.swtools.mem.validation.ui.CellLogsView;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ValidationJob
extends Job {
    private static final Logger LOGGER = LogManager.getLogger(ValidationJob.class);
    public static final String JOB_NAME = Messages.JobName_DDRv;
    public static final int MAX_LANES = 9;
    public static final String BYTE_LANE_PARAM = "BYTE_LANE";
    public static final String NIBBLE_PARAM = "NIBBLE";
    private static long SCRIPT_STATUS_UPDATE_REQUEST_INTERVAL = 100L;
    private static long PERIODIC_UPDATE_INTERVAL = 100L;
    private int elapsedTime = 0;
    private VPresentationModel data;
    private CGenVEventListener cgenEventListener;
    @Nullable
    private ARunResultsUpdaterListener runResultUpdaterListener;
    private ValidationStatisticsUpdaterListener statsUpdaterListener;
    private List<IValidationSessionEventListener> eventListeners = new ArrayList<IValidationSessionEventListener>();
    @Nullable
    private VSessionModel session;
    @Nullable
    private VSessionModel.VEvent lastEvent;
    @Nullable
    private IValidationSessionEventListener.VEventListenerResult lastEventListenerResult;
    private AtomicBoolean reuseSession = new AtomicBoolean(false);
    @Nullable
    private StopCondition stopCondition;

    static void trace(String message) {
        LOGGER.info(message);
    }

    public ValidationJob(VPresentationModel data) {
        super(JOB_NAME);
        this.data = data;
        this.cgenEventListener = new CGenVEventListener(data);
        this.statsUpdaterListener = new ValidationStatisticsUpdaterListener();
        this.eventListeners.add(new PresentationModelUpdaterListener(data));
        this.eventListeners.add(new CustomModelUpdaterListener());
        this.eventListeners.add(new ConfigurationUpdater());
        this.eventListeners.add(new InitializeRegistersListener());
        this.eventListeners.add(this.cgenEventListener);
        this.eventListeners.add(this.statsUpdaterListener);
    }

    private boolean canContinue(@Nullable IProgressMonitor monitor) {
        if (monitor == null || monitor.isCanceled()) {
            this.stopCondition = StopCondition.JOB_CANCELLED;
            ValidationJob.trace(Messages.ValidationJob_6);
            return false;
        }
        return true;
    }

    private void generateReports(@Nullable VSessionModel.VEvent event, boolean force) {
        boolean forceGenerate = force;
        if (!forceGenerate && event != null) {
            VSessionModel.VEventPhase[] vEventPhaseArray = event.getEndPhases();
            int n = vEventPhaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                VSessionModel.VEventPhase phase = vEventPhaseArray[n2];
                if (phase == VSessionModel.VEventPhase.VTABLE_END || phase == VSessionModel.VEventPhase.VALIDATION_END) {
                    forceGenerate = true;
                }
                ++n2;
            }
        }
        if (this.data.generateAutoReport(this.statsUpdaterListener.getNumExecutedTests(), this.statsUpdaterListener.getStartTimeMs(), this.statsUpdaterListener.getEndTimeMs(), forceGenerate)) {
            this.statsUpdaterListener.reset();
        }
    }

    public @Nullable VSessionModel.VEvent getLastEvent() {
        return this.lastEvent;
    }

    private void onValidationStop(boolean targetUnlockSuccess) {
        if (this.stopCondition == null) {
            this.runUpdater(ValidationJobUpdater.UpdaterType.ON_VALIDATION_FINISH, targetUnlockSuccess);
            return;
        }
        assert (this.stopCondition != null);
        switch (this.stopCondition) {
            case CODEGEN_ERROR: {
                this.runUpdater(ValidationJobUpdater.UpdaterType.ON_CODEGEN_ERROR, targetUnlockSuccess);
                break;
            }
            case CONFIG_ERROR: {
                this.runUpdater(ValidationJobUpdater.UpdaterType.ON_CONFIG_ERROR, targetUnlockSuccess);
                break;
            }
            case JOB_CANCELLED: {
                this.runUpdater(ValidationJobUpdater.UpdaterType.ON_CANCEL, targetUnlockSuccess);
                break;
            }
            case SERVER_TIMEOUT: {
                this.runUpdater(ValidationJobUpdater.UpdaterType.ON_SERVER_TIMEOUT, targetUnlockSuccess);
                break;
            }
            case TARGET_ERROR: {
                this.runUpdater(ValidationJobUpdater.UpdaterType.ON_TARGET_ERROR, targetUnlockSuccess);
            }
        }
    }

    protected IStatus run(@Nullable IProgressMonitor monitor) {
        block17: {
            block16: {
                this.session = this.data.getSession();
                VSessionModel _session = Objects.requireNonNull(this.session);
                if (!this.reuseSession.getAndSet(false)) {
                    _session.generateEvents();
                }
                this.stopCondition = null;
                Connection connection = this.checkConnection();
                if (monitor != null) {
                    int totalWork = _session.size();
                    if (totalWork < 1) {
                        totalWork = -1;
                    }
                    monitor.beginTask(Messages.ValidationJob_8, totalWork);
                }
                this.statsUpdaterListener.reset();
                try {
                    try {
                        for (VSessionModel.VEvent event : _session) {
                            IValidationSessionEventListener.VEventListenerResult _lastEventListenerResult;
                            VSessionModel.VEventPhase phase;
                            int n;
                            int n2;
                            VSessionModel.VEventPhase[] vEventPhaseArray;
                            if (event.getSkipMode() == VSessionModel.VEventSkipMode.SKIP_FULL) continue;
                            this.lastEvent = event;
                            if (event.getSkipMode() != VSessionModel.VEventSkipMode.SKIP_START_AND_EXEC) {
                                VSessionModel.VEventPhase[] startPhases;
                                vEventPhaseArray = startPhases = event.getStartPhases();
                                n2 = startPhases.length;
                                n = 0;
                                while (n < n2) {
                                    phase = vEventPhaseArray[n];
                                    for (IValidationSessionEventListener listener : this.eventListeners) {
                                        this.lastEventListenerResult = listener.onEvent(_session, event, phase);
                                        _lastEventListenerResult = Objects.requireNonNull(this.lastEventListenerResult);
                                        if (_lastEventListenerResult.passed) {
                                            continue;
                                        }
                                        break block16;
                                    }
                                    ++n;
                                }
                            }
                            if (!this.canContinue(monitor) || event.getSkipMode() != VSessionModel.VEventSkipMode.SKIP_START_AND_EXEC && !this.runScript(monitor, connection)) break;
                            VSessionModel.VEventPhase[] endPhases = event.getEndPhases();
                            vEventPhaseArray = endPhases;
                            n2 = endPhases.length;
                            n = 0;
                            while (n < n2) {
                                phase = vEventPhaseArray[n];
                                for (IValidationSessionEventListener listener : this.eventListeners) {
                                    this.lastEventListenerResult = listener.onEvent(_session, event, phase);
                                    _lastEventListenerResult = Objects.requireNonNull(this.lastEventListenerResult);
                                    if (_lastEventListenerResult.passed && !_lastEventListenerResult.skip) {
                                        continue;
                                    }
                                    break block16;
                                }
                                ++n;
                            }
                            if (this.canContinue(monitor)) {
                                this.generateReports(event, false);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warning(e.getLocalizedMessage());
                        this.onValidationStop(true);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    this.onValidationStop(true);
                    throw throwable;
                }
            }
            this.onValidationStop(true);
        }
        this.generateReports(null, true);
        return Objects.requireNonNull(Status.OK_STATUS);
    }

    private Connection checkConnection() {
        ExecutionPresentationModel executionLoc = this.data.getExecution();
        if (executionLoc == null) {
            throw new IllegalArgumentException(Messages.NoConnectionData);
        }
        Connection connection = executionLoc.getConnection();
        if (connection == null) {
            throw new IllegalArgumentException(Messages.NoConnectionData);
        }
        return connection;
    }

    public void runOnCancelUpdater() {
        this.runUpdater(ValidationJobUpdater.UpdaterType.ON_CANCEL, true);
    }

    private boolean runScript(@Nullable IProgressMonitor monitor, Connection connection) throws IOException {
        RunAction action;
        RunScriptRequest request = this.cgenEventListener.getRunRequest();
        if (request == null) {
            return false;
        }
        int numResults = 0;
        VSessionModel.VEvent lastEventLoc = Objects.requireNonNull(this.lastEvent);
        try {
            action = RunActionFactory.getRunAction(connection, this.lastEvent.getScenario());
        }
        catch (ResourceNotFoundException e) {
            LOGGER.severe(e.getMessage());
            this.stopCondition = StopCondition.TARGET_ERROR;
            return false;
        }
        action.setModel(this.data);
        Map<Integer, VRunResult[]> runResults = lastEventLoc.getResults();
        if (runResults == null) {
            return false;
        }
        Map.Entry<Integer, VRunResult[]> entry = runResults.entrySet().iterator().next();
        VRunResult runResult = entry.getValue()[0];
        String logFilePathStr = TestResultsLogger.getLogFilePath(runResult);
        Path logFilePath = Paths.get(logFilePathStr, new String[0]);
        CellLogsView cellLogsView = this.data.getView().getCellLogsView();
        String logLevel = CellLogsView.LEVELS[3];
        if (cellLogsView != null) {
            logLevel = cellLogsView.getLogLevelText();
        }
        try {
            if (!action.runRequest(request, logLevel)) {
                return false;
            }
        }
        catch (ResourceNotFoundException e) {
            LOGGER.severe(e.getMessage());
            this.stopCondition = StopCondition.TARGET_ERROR;
            return false;
        }
        VScriptConfig scriptConfig = lastEventLoc.getScriptConfig();
        ExecutionPresentationModel executionLoc = this.data.getExecution();
        if (scriptConfig != null) {
            String option;
            String resultsHeader = TestResultsLogger.buildHeaderLine(scriptConfig.getScript().getId(), lastEventLoc.getIteration() + 1);
            this.data.onLogUpdate(resultsHeader, false);
            if (!logFilePath.toFile().exists()) {
                Files.createFile(logFilePath, new FileAttribute[0]);
            }
            Files.write(logFilePath, Collections.singletonList(resultsHeader), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
            VModel vModel = this.data.getModel();
            if (vModel != null && (option = vModel.getCustomOption("filterPhyLog")) != null && Boolean.parseBoolean(option)) {
                String phyLogFilePathStr = TestResultsLogger.getPhyTrainingLogFilePath(runResult.getParamVariation());
                Path phyLogFilePath = Paths.get(phyLogFilePathStr, new String[0]);
                if (!phyLogFilePath.toFile().exists()) {
                    Files.createFile(phyLogFilePath, new FileAttribute[0]);
                }
                Files.write(phyLogFilePath, Collections.singletonList(resultsHeader), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
            }
        }
        boolean askIgnoreTimeout = true;
        while (action.isConnected() && !action.actionFinished()) {
            boolean sendCancelToServer;
            block27: {
                sendCancelToServer = false;
                Thread.sleep(SCRIPT_STATUS_UPDATE_REQUEST_INTERVAL);
                this.periodicUIUpdate();
                if (askIgnoreTimeout && executionLoc != null && action.getLastResponseElapsedTime() > executionLoc.getTestTimeout()) {
                    this.data.updateUI(new TimeoutReachedUiUpdater(this.data, Messages.ddrv_presentation_model_ignore_time_out), JobName.REFRESH_UI_ON_VSERVER_TIMEOUT.name);
                    askIgnoreTimeout = false;
                }
                if (executionLoc == null || executionLoc.ignoreTimeout()) break block27;
                LOGGER.log(Level.WARNING, Messages.ValidationJob_9, Long.toString(action.getLastResponseElapsedTime()));
                this.stopCondition = StopCondition.SERVER_TIMEOUT;
                action.cancel();
                executionLoc.setIgnoreTimeout(true);
                this.runOnCancelUpdater();
                return false;
            }
            try {
                TestResult[] results;
                String scriptOutput = action.getOutput();
                if (!"".equals(scriptOutput)) {
                    this.data.onLogUpdate(scriptOutput, true);
                    if (!logFilePath.toFile().exists()) {
                        Files.createFile(logFilePath, new FileAttribute[0]);
                    }
                    Files.writeString(logFilePath, (CharSequence)scriptOutput, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
                }
                TestResult[] testResultArray = results = action.getResults();
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    TestResult result = testResultArray[n2];
                    ARunResultsUpdaterListener runResultUpdaterListenerLoc = Objects.requireNonNull(this.runResultUpdaterListener);
                    lastEventLoc = Objects.requireNonNull(this.lastEvent);
                    runResultUpdaterListenerLoc.setRawOutput(result.getRawOutput());
                    runResultUpdaterListenerLoc.setFailureType(result.getFailureType());
                    runResultUpdaterListenerLoc.onEvent(Objects.requireNonNull(this.session), lastEventLoc, VSessionModel.VEventPhase.SCRIPT_END);
                    lastEventLoc.setIteration(lastEventLoc.getIteration() + 1);
                    if (result.isLast() || lastEventLoc.getNumRuns() == ++numResults) {
                        action.setFinished(true);
                        break;
                    }
                    ++n2;
                }
                if (!this.canContinue(monitor)) {
                    sendCancelToServer = true;
                }
                if (executionLoc != null) {
                    executionLoc.setIgnoreTimeout(true);
                }
            }
            catch (InterruptedException e) {
                ValidationJob.trace(Messages.ValidationJob_0);
                LOGGER.info(e.getMessage());
                action.cancel();
                if (executionLoc != null) {
                    executionLoc.setIgnoreTimeout(true);
                }
                Thread.currentThread().interrupt();
            }
            if (!sendCancelToServer) continue;
            ValidationJob.trace(Messages.ValidationJob_1);
            action.cancel();
            if (action.getCompletionReason() == RunAction.CompletionReason.TimedOut) {
                ValidationJob.trace(Messages.ValidationJob_2);
            } else {
                ValidationJob.trace(Messages.ValidationJob_3);
            }
            return false;
        }
        if (executionLoc != null) {
            executionLoc.setIgnoreTimeout(true);
        }
        action.terminate();
        return true;
    }

    private void runUpdater(final ValidationJobUpdater.UpdaterType type, boolean targetUnlockSuccess) {
        VSessionModel sessionLoc = Objects.requireNonNull(this.session);
        VSessionModel.VEvent lastEventLoc = this.lastEvent;
        final ValidationJobUpdater updater = new ValidationJobUpdater(this.data, type);
        updater.setStage(Objects.requireNonNull(sessionLoc.getStage()));
        if (this.lastEvent == null && type == ValidationJobUpdater.UpdaterType.ON_TARGET_ERROR) {
            this.lastEvent = sessionLoc.getNextEvent();
        }
        if (lastEventLoc != null) {
            updater.setScenario(lastEventLoc.getScenario());
            if (Objects.requireNonNull(lastEventLoc.getTables()).length > 0) {
                updater.setTables(lastEventLoc.getTables(), Objects.requireNonNull(lastEventLoc.getTables())[0]);
            }
            if (Objects.requireNonNull(lastEventLoc.getCells()).length > 0) {
                updater.setCell(Objects.requireNonNull(Objects.requireNonNull(lastEventLoc.getCells())[0]));
            }
            updater.setTargetUnlockSuccess(targetUnlockSuccess);
        }
        Job job = new Job(Messages.ValidationJob_5){

            protected IStatus run(@Nullable IProgressMonitor monitor) {
                ValidationJob.trace(String.valueOf(Messages.ValidationJob_4) + (Object)((Object)type));
                updater.run();
                return Objects.requireNonNull(Status.OK_STATUS);
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void setReuseSession(boolean reuse) {
        this.reuseSession.set(reuse);
    }

    public void setRunResultsUpdaterListener(ARunResultsUpdaterListener listener) {
        this.eventListeners.remove(this.runResultUpdaterListener);
        this.runResultUpdaterListener = listener;
        this.eventListeners.add(listener);
    }

    private void periodicUIUpdate() {
        if ((long)this.elapsedTime >= PERIODIC_UPDATE_INTERVAL) {
            this.elapsedTime = 0;
            this.data.onPeriodicUpdate();
        } else {
            this.elapsedTime = (int)((long)this.elapsedTime + SCRIPT_STATUS_UPDATE_REQUEST_INTERVAL);
        }
    }
}

