/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class DecIntegerParamKeyListener
implements KeyListener,
ModifyListener {
    protected static final Logger LOGGER = LogManager.getLogger(DecIntegerParamKeyListener.class);
    private VPresentationModel data;

    private static void checkKeyPressed(KeyEvent event, String strValue, int strValueSize, int cursorPosition, @Nullable String selectionText, int selectionStart, int selectionCount) {
        switch (event.keyCode) {
            case 8: 
            case 127: 
            case 262144: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000007: 
            case 0x1000008: {
                event.doit = true;
                break;
            }
            default: {
                if (event.character >= 'A' && event.character <= 'F' || event.character >= 'a' && event.character <= 'f' || event.character >= '0' && event.character <= '9') {
                    event.doit = true;
                    if (selectionText != null || selectionCount <= 0) {
                        DecIntegerParamKeyListener.checkValue(event, String.valueOf(strValue.substring(0, selectionStart)) + event.character + strValue.substring(selectionStart + selectionCount, strValueSize));
                        break;
                    }
                    DecIntegerParamKeyListener.checkValue(event, String.valueOf(strValue.substring(0, cursorPosition)) + event.character + strValue.substring(cursorPosition, strValueSize));
                    break;
                }
                event.doit = false;
            }
        }
    }

    private static void checkKeyReleased(KeyEvent event, String strValue) {
        switch (event.keyCode) {
            case 8: 
            case 127: 
            case 262144: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000007: 
            case 0x1000008: {
                DecIntegerParamKeyListener.checkValue(event, strValue);
                break;
            }
            default: {
                event.doit = false;
            }
        }
    }

    private static void checkValue(KeyEvent event, String strDecValue) {
        long value = DecIntegerParamKeyListener.getLongValue(strDecValue);
        Text text = (Text)event.widget;
        VScriptParamValue model = (VScriptParamValue)text.getData("qcs.validation.ddr.model");
        if (model != null) {
            model.setValue("" + value);
        }
    }

    private static long getLongValue(@Nullable String strDecValue) {
        if (strDecValue == null || strDecValue.equals("")) {
            return -1L;
        }
        long value = 0L;
        try {
            value = Long.decode(strDecValue);
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
            return -1L;
        }
        if (value > 0xFFFFFFFFL || value < 0L) {
            return -1L;
        }
        return value;
    }

    public DecIntegerParamKeyListener(VPresentationModel data) {
        this.data = data;
    }

    public VPresentationModel getData() {
        return this.data;
    }

    public void keyPressed(@Nullable KeyEvent event) {
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        String strValue = text.getText();
        int strValueSize = strValue.length();
        int cursorPosition = text.getSelection().x;
        String selectionText = text.getSelectionText();
        int selectionStart = text.getSelection().x;
        int selectionCount = text.getSelectionCount();
        DecIntegerParamKeyListener.checkKeyPressed(event, strValue, strValueSize, cursorPosition, selectionText, selectionStart, selectionCount);
        this.data.validateSelectedScriptConfig();
    }

    public void keyReleased(@Nullable KeyEvent event) {
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        String startValue = text.getText();
        DecIntegerParamKeyListener.checkKeyReleased(event, Objects.requireNonNull(startValue));
        this.data.validateSelectedScriptConfig();
    }

    public void modifyText(@Nullable ModifyEvent event) {
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        long value = DecIntegerParamKeyListener.getLongValue(text.getText());
        VScriptParamValue model = (VScriptParamValue)text.getData("qcs.validation.ddr.model");
        if (model != null) {
            model.setValue(value);
        }
        this.data.validateSelectedScriptConfig();
        if (value == -1L) {
            text.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
        } else {
            text.setBackground(null);
        }
    }
}

