/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptFileParamValue;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParam;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.ui.CustomText;
import com.nxp.swtools.mem.validation.ui.FileParamView;
import com.nxp.swtools.mem.validation.ui.VScriptParamsView;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FileBoolParamListener
implements SelectionListener {
    VPresentationModel data;

    public FileBoolParamListener(VPresentationModel data) {
        this.data = data;
    }

    static void reloadDefaultAccessType(Control accessType) {
        Object accessTypeData = accessType.getData("qcs.validation.ddr.model");
        if (accessType instanceof Combo && accessTypeData instanceof VScriptParamValue) {
            Combo memAccessType = (Combo)accessType;
            VScriptParamValue scriptParamValue = (VScriptParamValue)accessTypeData;
            String defalutValue = scriptParamValue.getParam().getDefaultValue().toString();
            VScriptParam.Options options = scriptParamValue.getParam().getOptions();
            if (options != null) {
                String defalutOptionName = options.getName(defalutValue);
                memAccessType.setText(defalutOptionName);
                scriptParamValue.setValue(defalutValue);
            }
        }
    }

    static void reloadDefaultSize(Control sizeBox) {
        CustomText customText;
        Object customTextData;
        if (sizeBox instanceof CustomText && (customTextData = (customText = (CustomText)sizeBox).getData("qcs.validation.ddr.model")) instanceof VScriptParamValue) {
            VScriptParamValue model = (VScriptParamValue)customTextData;
            customText.switchState(Messages.UnitKB);
            long defaultSize = Long.parseLong(model.getParam().getDefaultValue().toString()) / 1024L;
            customText.setText(String.valueOf(defaultSize));
        }
    }

    public void widgetSelected(SelectionEvent event) {
        VScriptParamsView paramView;
        Button button = (Button)event.widget;
        boolean selected = button.getSelection();
        VScriptConfig sc = this.data.getSelectedScriptConfig();
        if (sc != null && (paramView = this.data.getParamView()) != null) {
            Control randomPatternControl = paramView.getControlByParamId("USE_RANDOM_PATTERN");
            Control patternControl = paramView.getControlByParamId("app.test_params.params");
            Control fullMemoryCheck = paramView.getControlByParamId("app.test_params.check_full_memory");
            Control fileControl = paramView.getControlByParamId("app.test_params.input_file");
            Control sizeBox = paramView.getControlByParamId("app.test_params.size");
            Control memoryAccessType = paramView.getControlByParamId("app.test_params.access_type");
            if (randomPatternControl != null) {
                randomPatternControl.setEnabled(!selected);
            }
            if (patternControl != null) {
                patternControl.setEnabled(!selected);
            }
            if (fullMemoryCheck != null) {
                fullMemoryCheck.setEnabled(!selected);
            }
            if (sizeBox != null) {
                sizeBox.setEnabled(!selected);
                if (!selected) {
                    FileBoolParamListener.reloadDefaultSize(sizeBox);
                }
            }
            if (memoryAccessType != null) {
                memoryAccessType.setEnabled(!selected);
                if (selected) {
                    FileBoolParamListener.reloadDefaultAccessType(memoryAccessType);
                }
            }
            if (fileControl != null) {
                Object fileControlData = fileControl.getData("qcs.validation.ddr.model");
                Composite buttonParent = button.getParent();
                if (fileControlData instanceof VScriptParamValue && buttonParent instanceof FileParamView) {
                    VScriptParamValue newData = (VScriptParamValue)fileControlData;
                    FileParamView fileView = (FileParamView)buttonParent;
                    Object fileViewData = fileView.getData("qcs.validation.ddr.model");
                    if (fileViewData instanceof VScriptFileParamValue) {
                        newData.setValue(selected);
                        fileView.setEnabled(selected);
                        VScriptFileParamValue model = (VScriptFileParamValue)fileViewData;
                        fileView.getFilePath().setText(model.getPath());
                    }
                }
            }
            this.data.validatePattern();
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }
}

