/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.listeners.DecIntegerParamKeyListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class HexIntegerParamKeyListener
implements KeyListener,
ModifyListener,
VerifyListener {
    protected static final Logger LOGGER = LogManager.getLogger(DecIntegerParamKeyListener.class);
    private VPresentationModel data;

    private static void checkKeyPressed(KeyEvent event, String strValue, int strValueSize, int cursorPosition, @Nullable String selectionText, int selectionStart, int selectionCount) {
        switch (event.keyCode) {
            case 8: 
            case 127: 
            case 262144: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000007: 
            case 0x1000008: {
                event.doit = true;
                break;
            }
            default: {
                if (event.character >= 'A' && event.character <= 'F' || event.character >= 'a' && event.character <= 'f' || event.character >= '0' && event.character <= '9' || event.character == 'x' || event.character == 'X') {
                    event.doit = true;
                    if (selectionText != null || selectionCount <= 0) {
                        HexIntegerParamKeyListener.checkValue(event, String.valueOf(strValue.substring(0, selectionStart)) + event.character + strValue.substring(selectionStart + selectionCount, strValueSize));
                        break;
                    }
                    HexIntegerParamKeyListener.checkValue(event, String.valueOf(strValue.substring(0, cursorPosition)) + event.character + strValue.substring(cursorPosition, strValueSize));
                    break;
                }
                event.doit = false;
            }
        }
    }

    private static void checkKeyReleased(KeyEvent event, @Nullable String strValue) {
        switch (event.keyCode) {
            case 8: 
            case 127: 
            case 262144: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000007: 
            case 0x1000008: {
                HexIntegerParamKeyListener.checkValue(event, strValue);
                break;
            }
            default: {
                event.doit = false;
            }
        }
    }

    private static void checkValue(KeyEvent event, @Nullable String strHexValue) {
        try {
            long value = HexIntegerParamKeyListener.getLongValue(strHexValue);
            Text text = (Text)event.widget;
            VScriptParamValue model = (VScriptParamValue)text.getData("qcs.validation.ddr.model");
            if (model != null) {
                model.setValue(value);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.info(ex.getMessage());
        }
    }

    private static long getLongValue(@Nullable String strHexValue) {
        if (strHexValue == null || strHexValue.equals("")) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.HexIntegerParamKeyListener_InvalidNumber, strHexValue));
        }
        long value = 0L;
        try {
            if (!strHexValue.startsWith("0x") && !strHexValue.startsWith("0X")) {
                strHexValue = "0x" + strHexValue;
            }
            value = Long.decode(strHexValue);
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
            throw new IllegalArgumentException(MessageFormat.format(Messages.HexIntegerParamKeyListener_InvalidNumber, strHexValue));
        }
        if (value < 0L) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.HexIntegerParamKeyListener_InvalidNumber, strHexValue));
        }
        return value;
    }

    public HexIntegerParamKeyListener(VPresentationModel data) {
        this.data = data;
    }

    public VPresentationModel getData() {
        return this.data;
    }

    public void keyPressed(@Nullable KeyEvent event) {
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        String strValue = text.getText();
        int strValueSize = strValue.length();
        int cursorPosition = text.getSelection().x;
        String selectionText = text.getSelectionText();
        int selectionStart = text.getSelection().x;
        int selectionCount = text.getSelectionCount();
        HexIntegerParamKeyListener.checkKeyPressed(event, strValue, strValueSize, cursorPosition, selectionText, selectionStart, selectionCount);
        this.data.validateSelectedScriptConfig();
    }

    public void keyReleased(@Nullable KeyEvent event) {
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        String startValue = text.getText();
        HexIntegerParamKeyListener.checkKeyReleased(event, startValue);
        this.data.validateSelectedScriptConfig();
    }

    public void modifyText(@Nullable ModifyEvent event) {
        VScriptConfig scriptConfig;
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        String strHexValue = text.getText().trim();
        VScriptParamValue model = (VScriptParamValue)text.getData("qcs.validation.ddr.model");
        VScenarioPresentation selectedScenario = this.data.getSelectedScenario();
        ValidationPresentationModel validation = this.data.getValidationModel();
        if (selectedScenario != null && validation != null && model != null && (scriptConfig = selectedScenario.getSelectedScriptConfig()) != null) {
            VStagePresentation selectedStage;
            try {
                long longVal = HexIntegerParamKeyListener.getLongValue(strHexValue);
                model.setValue(longVal);
                text.setBackground(null);
            }
            catch (IllegalArgumentException ex) {
                text.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
                LOGGER.log(Level.INFO, Messages.HexIntegerParamKeyListener_InvalidUserInput, ex);
            }
            this.data.validateScript(scriptConfig);
            if (!this.getData().getSkipSync() && (selectedStage = validation.getSelectedStage()) != null && selectedStage.getSyncScriptConfig()) {
                selectedStage.syncModifiedParam(model, this.data);
            }
            this.data.validateSelectedScriptConfig();
        }
    }

    public void verifyText(@Nullable VerifyEvent event) {
        if (event == null) {
            return;
        }
        Text text = (Text)event.widget;
        String strHexValue = String.valueOf(text.getText().trim()) + event.text;
        Pattern p = Pattern.compile("([0-9A-Fa-f]+h)|(0[xX][0-9A-Fa-f]+)|([0-9]+)");
        Matcher m = p.matcher(strHexValue);
        if (m.matches()) {
            try {
                HexIntegerParamKeyListener.getLongValue(strHexValue);
            }
            catch (IllegalArgumentException ex) {
                text.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
                LOGGER.log(Level.INFO, Messages.HexIntegerParamKeyListener_InvalidUserInput, ex);
            }
        }
    }
}

