/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.jobs.JobName;
import com.nxp.swtools.mem.validation.listeners.IValidationSessionEventListener;
import com.nxp.swtools.mem.validation.model.ARunResultsUpdaterListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.presenter.updaters.RefreshUIRunnable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.swt.graphics.Point;

public class DiagsEyeResultHandler
extends ARunResultsUpdaterListener {
    private static final String[] EYE_STAGE_NAMES = new String[]{"vTSA", "Diags"};
    private VPresentationModel model;
    @Nullable
    private String output;
    private ArrayList<EyeTable> dqTables;
    @Nullable
    private VStage stage;
    @Nullable
    private VScenario scenario;
    private VLoggingUtils.ScriptResultType resultType = VLoggingUtils.ScriptResultType.PASSED;
    public static final int CENTER_MARK_VALUE = -1;

    public DiagsEyeResultHandler(VPresentationModel presentationModel) {
        this.model = presentationModel;
        ValidationPresentationModel validationModel = this.model.getValidationModel();
        if (validationModel != null) {
            String[] stringArray = EYE_STAGE_NAMES;
            int n = EYE_STAGE_NAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String eyeStage = stringArray[n2];
                VStagePresentation stagePresentation = validationModel.getStage(Objects.requireNonNull(eyeStage));
                if (stagePresentation != null) {
                    this.stage = stagePresentation.getModel();
                    break;
                }
                ++n2;
            }
        }
        this.dqTables = new ArrayList();
    }

    @Override
    public IValidationSessionEventListener.VEventListenerResult onEvent(VSessionModel session, VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        if (phase == VSessionModel.VEventPhase.VSCENARIO_END) {
            return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
        }
        if (phase == VSessionModel.VEventPhase.SCRIPT_END) {
            this.scenario = event.scenario;
            if (this.resultType == VLoggingUtils.ScriptResultType.PASSED) {
                this.parseResult();
            }
            this.updateModel();
            this.model.updateUI(new RefreshUIRunnable(this.model, RefreshUIRunnable.RefreshMode.SELECT_SCENARIO, true), JobName.REFRESH_UI_ON_NEW_TEST_RESULTS.name);
        } else if (phase == VSessionModel.VEventPhase.SCRIPT_START) {
            this.dqTables = new ArrayList();
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    private void updateModel() {
        VRunResult[] results;
        VTableGroup tableGrp;
        VTable[] allTables;
        VTable crtTable;
        VParamVariation crtCell;
        VTableGroup[] tableGroup;
        if (this.stage != null && this.scenario != null && (tableGroup = this.scenario.getTableGroups()) != null && (crtCell = (crtTable = (allTables = (tableGrp = tableGroup[0]).getTables())[0]).getParamVariation(new Point(0, 0))) != null && (results = crtCell.getResults()) != null) {
            int testIteration = 0;
            VRunResult runResult = results[testIteration];
            runResult.setType(this.resultType.equals((Object)VLoggingUtils.ScriptResultType.PASSED) ? VRunResult.ResultType.PASSED : VRunResult.ResultType.FAILED);
            runResult.setFailureType(this.resultType);
            runResult.setErrorMessage(this.resultType.equals((Object)VLoggingUtils.ScriptResultType.PASSED) ? "" : VLoggingUtils.extractErrorMessage(UtilsText.safeString((String)this.output)));
            VParamVariation cell = runResult.getParamVariation();
            cell.setDiagsData(this.dqTables);
            this.model.onValidationRunResults(Objects.requireNonNull(this.stage), Objects.requireNonNull(this.scenario), runResult);
        }
    }

    private void parseResult() {
        String[] lines = Objects.requireNonNull(this.output).split("\\r?\\n");
        EyeTable currentTable = null;
        int xCenter = 0;
        int yCenter = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            int delay;
            String line = stringArray[n2];
            if ((line = line.replace("|", "").trim().replaceAll(" +", " ")).startsWith("CS:")) {
                if (currentTable != null) {
                    currentTable.data[yCenter - 1][xCenter] = -1;
                    currentTable.data[yCenter][xCenter] = -1;
                    currentTable.data[yCenter + 1][xCenter] = -1;
                    this.dqTables.add(currentTable);
                }
                currentTable = new EyeTable();
                String[] csLine = line.split(" ");
                currentTable.cs = Integer.parseInt(csLine[1]);
                currentTable.goldenVref = Double.parseDouble(csLine[3]);
                currentTable.tapDelay = Integer.parseInt(csLine[6]);
            } else if (line.startsWith("DQ:") && currentTable != null) {
                String[] dqLine = line.replaceAll("\\(|\\)", "").split(" ");
                currentTable.dq = Integer.parseInt(dqLine[1]);
                currentTable.byteLane = Integer.parseInt(dqLine[3]);
                currentTable.bitLane = Integer.parseInt(dqLine[5]);
            } else if (line.startsWith("H:") && currentTable != null) {
                String[] _line = line.split(" ");
                currentTable.height = Double.parseDouble(_line[1]);
                currentTable.width = Double.parseDouble(_line[4]);
            } else if (line.startsWith("VREF(V)") && currentTable != null) {
                String[] delayLine = line.split(" ");
                delay = 5;
                while (delay < delayLine.length) {
                    currentTable.xAxis.add(Integer.parseInt(delayLine[delay]));
                    ++delay;
                }
                currentTable.data = new int[600][currentTable.xAxis.size()];
            } else if ((line.startsWith("0") || line.startsWith("1")) && line.matches("^[0-9\\s\\|.X]+$") && currentTable != null) {
                String[] dataLine = line.split(" ");
                currentTable.yAxis.add(Double.parseDouble(dataLine[0]));
                delay = 1;
                while (delay < dataLine.length) {
                    if (dataLine[delay].equals("XXXXX")) {
                        xCenter = delay - 1;
                        yCenter = currentTable.yAxis.size() - 1;
                    } else {
                        currentTable.data[currentTable.yAxis.size() - 1][delay - 1] = Integer.parseInt(dataLine[delay]);
                    }
                    ++delay;
                }
            }
            ++n2;
        }
        if (currentTable != null) {
            currentTable.data[yCenter][xCenter] = -1;
            currentTable.data[yCenter - 1][xCenter] = -1;
            currentTable.data[yCenter + 1][xCenter] = -1;
            this.dqTables.add(currentTable);
        }
    }

    @Override
    public double getProgress() {
        return 0.0;
    }

    @Override
    public @Nullable VStage getStage() {
        return this.stage;
    }

    @Override
    public @Nullable VScenario getScenario() {
        return this.scenario;
    }

    @Override
    public VTable[] getTables() {
        VScenario currentScenario = Objects.requireNonNull(this.scenario);
        VTableGroup[] tableGroups = currentScenario.getTableGroups();
        if (tableGroups != null) {
            return tableGroups[0].getTables();
        }
        return new VTable[0];
    }

    @Override
    public @Nullable VTable getTable() {
        return this.getTables()[0];
    }

    @Override
    public void setRawOutput(String line) {
        this.output = line;
    }

    @Override
    public @Nullable VSessionModel.VEvent getNextEvent() {
        return null;
    }

    @Override
    public void setFailureType(VLoggingUtils.ScriptResultType resultType) {
        this.resultType = resultType;
    }

    @Override
    public void setResultText(String resultText) {
    }

    public static class EyeTable {
        public static final int MAX_LINES = 600;
        int cs = 0;
        double goldenVref = 0.0;
        int tapDelay = 0;
        int dq = 0;
        int byteLane = 0;
        int bitLane = 0;
        double height = 0.0;
        double width = 0.0;
        ArrayList<Double> yAxis;
        ArrayList<Integer> xAxis = new ArrayList();
        int[][] data;

        public EyeTable() {
            this.yAxis = new ArrayList();
            this.data = new int[0][0];
        }

        public @Nullable ArrayList<Integer> xAxis() {
            return this.xAxis;
        }

        public @Nullable ArrayList<Double> yAxis() {
            return this.yAxis;
        }

        public int @Nullable [][] data() {
            return this.data;
        }

        public double width() {
            return this.width;
        }

        public double height() {
            return this.height;
        }

        public int dq() {
            return this.dq;
        }

        public double goldenVref() {
            return this.goldenVref;
        }

        public int tapDelay() {
            return this.tapDelay;
        }

        public int byteLane() {
            return this.byteLane;
        }

        public int bitLane() {
            return this.bitLane;
        }
    }
}

