/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.VTableFigure;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class VTableScenarioPresentation
extends VScenarioPresentation {
    private static final Logger LOGGER = LogManager.getLogger(VTableScenarioPresentation.class);

    public VTableScenarioPresentation(VScenario _model, VStagePresentation _parent) {
        super(_model, _parent);
        VTableGroup[] tableGroups = this.model.getTableGroups();
        if (tableGroups != null) {
            this.tableFigures = new VTableFigure[tableGroups.length][];
            int i = 0;
            while (i < Objects.requireNonNull(this.tableFigures).length) {
                VTableGroup tableGrp = tableGroups[i];
                if (tableGrp != null) {
                    VTable[] tables = tableGrp.getTables();
                    Objects.requireNonNull(this.tableFigures)[i] = new VTableFigure[tables.length];
                    int j = 0;
                    while (j < tables.length) {
                        VTable table = tables[j];
                        if (table != null) {
                            String firstTableStr;
                            Object obj;
                            boolean hLabelsVisible = true;
                            if (tables.length > 1 && j > 0 || table.getHParams().length == 0) {
                                hLabelsVisible = false;
                            }
                            if ((obj = table.getOptions().getParam("FIRST_TABLE")) != null && Boolean.valueOf(firstTableStr = (String)obj).booleanValue()) {
                                hLabelsVisible = true;
                            }
                            boolean headerIsVisible = j == 0;
                            VTableFigure tableFigure = new VTableFigure(Objects.requireNonNull(tables[j]), hLabelsVisible, headerIsVisible, this.parent.getParent().isCellErrorColoringEnabled());
                            Objects.requireNonNull(this.tableFigures)[i][j] = tableFigure;
                            this.tableFiguresMap.put(table.getId(), tableFigure);
                            this.tableFiguresPosMap.put(table.getId(), new Point(i, j));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        try {
            this.makeDefaultSelections();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
        }
        this.computed = false;
    }

    @Override
    protected void precompute(GC gc) {
        Point offset = new Point(10, 10);
        int maxY = 10;
        if (this.tableFigures != null) {
            IDisplayFigure table;
            int n;
            int n2;
            IDisplayFigure[] iDisplayFigureArray;
            IDisplayFigure[] tablesRow;
            IDisplayFigure[][] iDisplayFigureArray2 = this.tableFigures;
            int n3 = this.tableFigures.length;
            int n4 = 0;
            while (n4 < n3) {
                iDisplayFigureArray = tablesRow = iDisplayFigureArray2[n4];
                n2 = tablesRow.length;
                n = 0;
                while (n < n2) {
                    table = iDisplayFigureArray[n];
                    if (table.getModel().isVisible()) {
                        table.precompute(gc, offset);
                        offset.x = table.getOffset().x + table.getSize().x;
                        if (maxY < table.getOffset().y + table.getSize().y + 10) {
                            maxY = table.getOffset().y + table.getSize().y + 10;
                        }
                    }
                    ++n;
                }
                offset.x = 10;
                offset.y = maxY;
                ++n4;
            }
            this.figSize.x = 0;
            this.figSize.y = 0;
            iDisplayFigureArray2 = Objects.requireNonNull(this.tableFigures);
            n3 = iDisplayFigureArray2.length;
            n4 = 0;
            while (n4 < n3) {
                iDisplayFigureArray = tablesRow = iDisplayFigureArray2[n4];
                n2 = tablesRow.length;
                n = 0;
                while (n < n2) {
                    table = iDisplayFigureArray[n];
                    if (table.getModel().isVisible()) {
                        if (this.figSize.x < table.getOffset().x + table.getSize().x) {
                            this.figSize.x = table.getOffset().x + table.getSize().x;
                        }
                        if (this.figSize.y < table.getOffset().y + table.getSize().y) {
                            this.figSize.y = table.getOffset().y + table.getSize().y;
                        }
                    }
                    ++n;
                }
                ++n4;
            }
            this.figSize.x += 10;
            this.figSize.y += 10;
            try {
                this.makeDefaultSelections();
            }
            catch (Exception e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    @Override
    public void refreshTableFigure(VTable table) {
        String tableId = table.getId();
        VTableFigure oldTableFigure = (VTableFigure)this.tableFiguresMap.get(tableId);
        Point pos = (Point)this.tableFiguresPosMap.get(tableId);
        ValidationPresentationModel validation = this.parent.getParent();
        if (oldTableFigure != null && pos != null) {
            VTableFigure newTableFigure = new VTableFigure(table, oldTableFigure.getHLabelsVisible(), oldTableFigure.isHeaderVisible(), validation.isCellErrorColoringEnabled());
            newTableFigure.updateAllCellContents();
            if (this.tableFigures != null) {
                this.tableFigures[pos.x][pos.y] = newTableFigure;
                this.tableFiguresMap.put(tableId, newTableFigure);
            }
        }
    }

    @Override
    public boolean setSelection(Point clickPoint) {
        IDisplayFigure clickedTable = this.getTableAt(clickPoint);
        Point clickedCell = this.getCellAt(clickPoint);
        if (clickedTable != null && clickedCell != null && clickedCell.x != -1 && clickedCell.y != -1) {
            this.selectedTable = clickedTable;
            return this.setSelectedCell(clickedCell);
        }
        return false;
    }
}

