/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scripts;

public class AddressRange {
    public static final long MAX_32BIT = 0xFFFFFFFFL;
    protected long minStartAddress;
    protected long extendedMinStartAddr;

    public AddressRange(String minStartAddress) {
        String[] startAddresses = minStartAddress.split(",");
        if (startAddresses.length == 2) {
            this.minStartAddress = Long.decode(startAddresses[0]);
            this.extendedMinStartAddr = Long.decode(startAddresses[1]);
        } else {
            this.minStartAddress = Long.decode(startAddresses[0]);
            this.extendedMinStartAddr = 0L;
        }
    }

    public long getMin() {
        return this.minStartAddress;
    }

    public long getMax(long availableMemory) {
        long maxRange = 0xFFFFFFFFL;
        long memoryRange = this.minStartAddress + availableMemory;
        if (memoryRange < 0xFFFFFFFFL) {
            maxRange = memoryRange;
        }
        return maxRange;
    }

    public long getExtendedMin() {
        return this.extendedMinStartAddr;
    }

    public long getExtendedMax(long availableMemory) {
        return this.extendedMinStartAddr + availableMemory;
    }
}

