/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scripts;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.Template;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.scripts.DefaultVScript;
import com.nxp.swtools.mem.validation.model.scripts.IScriptConfigValidator;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfigBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class Scripts {
    private static final Logger LOGGER = LogManager.getLogger(Scripts.class);
    private List<VScript> scriptList = new ArrayList<VScript>();
    private Map<String, VScript> scriptMap = new HashMap<String, VScript>();
    private Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();
    private List<DefaultVScript> defaultScriptList = new ArrayList<DefaultVScript>();
    private Map<String, IScriptConfigValidator> validators = new HashMap<String, IScriptConfigValidator>();

    public Scripts(List<VScript> scripts, List<DefaultVScript> defaultScripts) {
        this.scriptList.addAll(scripts);
        for (VScript script : this.scriptList) {
            this.scriptMap.put(script.getId(), script);
        }
        this.defaultScriptList.addAll(defaultScripts);
    }

    public Scripts(Scripts proto) {
        this.scriptList = proto.scriptList;
        this.scriptMap = proto.scriptMap;
        this.defaultScriptList = proto.defaultScriptList;
        this.validators = proto.validators;
        for (VScript script : this.scriptList) {
            this.visibilityMap.put(script.getId(), new Boolean(true));
        }
    }

    public void addScript(VScript userScript) {
        this.scriptList.add(userScript);
        this.scriptMap.put(userScript.getId(), userScript);
        this.visibilityMap.put(userScript.getId(), new Boolean(true));
    }

    public void addValidator(String scriptId, IScriptConfigValidator validator) {
        this.validators.put(scriptId, validator);
    }

    public List<VScriptConfig> getDefaultScriptConfigs(ValidationContext vContext) {
        ArrayList<VScriptConfig> scriptConfigs = new ArrayList<VScriptConfig>();
        for (DefaultVScript defaultScript : this.defaultScriptList) {
            VScriptConfig scriptConfig = VScriptConfigBuilder.assembleScriptConfig(Objects.requireNonNull(defaultScript.getScript()), defaultScript.getCount(), new HashMap<String, String>());
            scriptConfigs.add(scriptConfig);
        }
        return scriptConfigs;
    }

    public @Nullable VScript getScript(String scriptId) {
        return this.scriptMap.get(scriptId);
    }

    public List<VScript> getScripts() {
        return this.scriptList;
    }

    public Map<String, Template.TemplateFile[]> getScriptTemplateMap() {
        HashMap<String, Template.TemplateFile[]> templateMap = new HashMap<String, Template.TemplateFile[]>();
        for (VScript script : this.scriptList) {
            VScript.VScriptTemplate[] templates = script.getTemplates();
            Template.TemplateFile[] templFiles = new Template.TemplateFile[templates.length];
            int i = 0;
            VScript.VScriptTemplate[] vScriptTemplateArray = templates;
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                VScript.VScriptTemplate template = vScriptTemplateArray[n2];
                templFiles[i] = new Template.TemplateFile(script.getId(), template.getFilePath());
                ++i;
                ++n2;
            }
            templateMap.put(script.getId(), templFiles);
        }
        return templateMap;
    }

    public @Nullable IScriptConfigValidator getValidator(String scriptId) {
        return this.validators.get(scriptId);
    }

    public boolean isScriptVisible(VScript script) {
        Boolean visibility = this.visibilityMap.get(script.getId());
        if (visibility != null) {
            return visibility;
        }
        LOGGER.severe(Messages.VisibilityForScriptNotFound);
        return false;
    }

    public void removeScript(VScript userScript) {
        this.scriptList.remove(userScript);
        this.scriptMap.remove(userScript.getId());
        this.visibilityMap.remove(userScript.getId());
    }

    public void update(ValidationContext vContext) {
        for (VScript script : this.scriptList) {
            this.visibilityMap.put(script.getId(), Boolean.TRUE);
        }
    }

    public void updateScript(String oldId, VScript userScript) {
        this.scriptMap.remove(oldId);
        this.scriptMap.put(userScript.getId(), userScript);
        this.visibilityMap.remove(oldId);
        this.visibilityMap.put(userScript.getId(), new Boolean(true));
    }
}

