/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.presenter.updaters;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionView;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.presenter.updaters.AUIRunnable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.CellResultsMainView;
import com.nxp.swtools.mem.validation.ui.ExecutionView;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import com.nxp.swtools.mem.validation.ui.VScenarioView;
import com.nxp.swtools.mem.validation.views.VStagesView;
import java.util.Objects;
import java.util.logging.Logger;

public class ValidationStartUiUpdater
extends AUIRunnable {
    private static final Logger LOGGER = LogManager.getLogger(ValidationStartUiUpdater.class);
    private VPresentationModel data;
    @Nullable
    private VStagesView stagesView;
    @Nullable
    private VScenarioView scenarioView;
    @Nullable
    private VScenarioOptionsView scenarioOptionsView;
    @Nullable
    private ExecutionView execView;
    @Nullable
    private ConnectionView connView;
    @Nullable
    private CellResultsMainView cellsView;

    private static void trace(String message) {
        LOGGER.info(message);
    }

    public ValidationStartUiUpdater(VPresentationModel _data) {
        this.data = _data;
        if (!this.data.isViewDisposed()) {
            this.stagesView = this.data.getView().getStagesView();
            this.scenarioView = this.data.getView().getScenarioView();
            this.scenarioOptionsView = this.data.getView().getScenarioOptionsView();
            this.execView = this.data.getView().getExecutionView();
            this.connView = this.data.getView().getConnView();
            this.cellsView = this.data.getView().getCellResultsMainView();
        } else {
            ValidationStartUiUpdater.trace(UtilsText.safeString((String)Messages.ValidationStartUiUpdater_0));
        }
    }

    @Override
    public void run() {
        if (this.data.isViewDisposed()) {
            ValidationStartUiUpdater.trace(UtilsText.safeString((String)Messages.ValidationStartUiUpdater_1));
            return;
        }
        VScenarioOptionsView scenarioOptionsViewLoc = this.scenarioOptionsView;
        VScenarioPresentation scenarioPresentationLoc = this.data.getSelectedScenario();
        if (scenarioOptionsViewLoc != null && scenarioPresentationLoc != null) {
            scenarioOptionsViewLoc.setInput(scenarioPresentationLoc);
            scenarioOptionsViewLoc.enable(false);
        }
        if (this.stagesView != null) {
            this.stagesView.setInput(Objects.requireNonNull(this.data.getValidationModel()));
        }
        VScenarioView scenarioViewLoc = this.scenarioView;
        VStagePresentation stagePresentationLoc = this.data.getSelectedStage();
        if (scenarioViewLoc != null && stagePresentationLoc != null) {
            scenarioViewLoc.setInput(stagePresentationLoc, true);
            scenarioViewLoc.setRestorePropertiesEnabled(false);
            scenarioViewLoc.setReportToolsEnabled(false);
            scenarioViewLoc.setSelectionToolsEnabled(false);
        }
        VParamVariation paramVariationLoc = this.data.getSelectedCell();
        if (this.cellsView != null && paramVariationLoc != null) {
            this.cellsView.setInput(paramVariationLoc, null, true);
        }
        ExecutionPresentationModel executionLoc = this.data.getExecution();
        if (this.execView != null && executionLoc != null) {
            this.execView.setInput(executionLoc);
        }
        if (this.connView != null && executionLoc != null) {
            this.connView.setInput(executionLoc);
        }
        Objects.requireNonNull(this.data.getValidationModel()).setActiveToolType(ValidationPresentationModel.SelectionToolType.SELECT_CELL);
    }
}

