/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.reports;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.reports.IReportGenerator;
import com.nxp.swtools.mem.validation.table.params.VParam;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Point;

public class CsvReportGenerator
implements IReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger(CsvReportGenerator.class);
    private static final char SPLIT_CHAR = ",".charAt(0);
    public static final String CORNER_TEXT = UtilsText.safeString((String)Messages.CsvReportGenerator_0);
    public static final String NQUEUED_CELL_TEXT = UtilsText.safeString((String)Messages.CsvReportGenerator_1);
    public static final String SKIPPED_CELL_TEXT = UtilsText.safeString((String)Messages.CsvReportGenerator_2);
    public static final String ERROR_CELL_TEXT = UtilsText.safeString((String)Messages.CsvReportGenerator_3);
    public static final String TODO_CELL_TEXT = UtilsText.safeString((String)Messages.CsvReportGenerator_4);
    public static final String GOLD_CELL_PREFIX = UtilsText.safeString((String)Messages.CsvReportGenerator_5);
    public static final String USER_CELL_PREFIX = UtilsText.safeString((String)Messages.CsvReportGenerator_6);
    public static final String CELL_POSTFIX = UtilsText.safeString((String)Messages.CsvReportGenerator_7);
    public static final String DOC_TITLE = UtilsText.safeString((String)Messages.CsvReportGenerator_8);
    public static final String MAIN_HEADER_PREFIX = UtilsText.safeString((String)Messages.CsvReportGenerator_9);
    private static final String CELL_TESTS_SUMMARY_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_10);
    private static final String SCRIPT_NAME_SUMMARY_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_11);
    private static final String ITERATION_SUMMARY_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_12);
    private static final String RESULT_SUMMARY_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_13);
    public static final String SELECTED_SCRIPTS_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_14);
    public static final String SCRIPT_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_15);
    public static final String ITERATION_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_16);
    private static final String PARAM_VARIATION_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_17);
    private static final String REGISTER_VARIATION_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_18);
    private static final String DETAILED_CELL_RESULTS_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_19);
    private static final String INITIAL_DDR_CONFIG_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_20);
    private static final String REGISTER_NAME_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_21);
    private static final String REGISTER_VALUE_HEADER = UtilsText.safeString((String)Messages.CsvReportGenerator_22);
    private IReportGenerator.ReportType type = IReportGenerator.ReportType.CSV;
    private int elemsPerLine = 0;
    @Nullable
    private String emptyLine = null;

    private static @Nullable String cellText(@Nullable VParamVariation cell, boolean isGoldenCell, boolean isUserCell) {
        if (cell != null) {
            int totalTests = cell.getNumPasses() + cell.getNumFails() + cell.getNumSkips();
            int passedTests = cell.getNumPasses();
            if (!cell.isSelected()) {
                return NQUEUED_CELL_TEXT;
            }
            String strPassedTests = passedTests + " out of " + totalTests;
            switch (cell.getState()) {
                case ERR_CONFIG: {
                    return ERROR_CELL_TEXT;
                }
                case ERR_CODEGEN: {
                    return ERROR_CELL_TEXT;
                }
                case FAILED: {
                    return strPassedTests;
                }
                case PARTIALY_PASSED: {
                    return strPassedTests;
                }
                case PAUSED: {
                    return strPassedTests;
                }
                case PASSED: {
                    if (isGoldenCell) {
                        return String.valueOf(GOLD_CELL_PREFIX) + strPassedTests + CELL_POSTFIX;
                    }
                    if (isUserCell) {
                        return String.valueOf(USER_CELL_PREFIX) + strPassedTests + CELL_POSTFIX;
                    }
                    return strPassedTests;
                }
                case DEFAULT: {
                    if (totalTests > 0) {
                        return strPassedTests;
                    }
                    return TODO_CELL_TEXT;
                }
                case SKIPPED: {
                    return SKIPPED_CELL_TEXT;
                }
            }
        }
        return null;
    }

    private static String getSplitChars(int num) {
        if (num <= 0) {
            return "";
        }
        char[] splitChars = new char[num];
        Arrays.fill(splitChars, SPLIT_CHAR);
        return new String(splitChars);
    }

    private void computeElemsPerLine(VTable[] tables) {
        char[] emptyLineChars = new char[this.elemsPerLine];
        Arrays.fill(emptyLineChars, SPLIT_CHAR);
        this.emptyLine = new String(emptyLineChars);
    }

    private void generateComplexTestExecSummary(PrintWriter out, VTable paramTable, VParamVariation cell) {
        VRunResult[] trrs = cell.getResults();
        if (trrs == null || trrs.length == 0) {
            return;
        }
        int lineSplits = 0;
        out.println(this.emptyLine);
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        out.print(CELL_TESTS_SUMMARY_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(SCRIPT_NAME_SUMMARY_HEADER);
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(ITERATION_SUMMARY_HEADER);
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(RESULT_SUMMARY_HEADER);
        out.print(SPLIT_CHAR);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        VRunResult[] vRunResultArray = trrs;
        int n = trrs.length;
        int n2 = 0;
        while (n2 < n) {
            VRunResult trr = vRunResultArray[n2];
            lineSplits = 0;
            out.print(SPLIT_CHAR);
            ++lineSplits;
            out.print(trr.getScriptConfig().getScript().getName());
            out.print(SPLIT_CHAR);
            ++lineSplits;
            int iteration = trr.getNumRun() + 1;
            out.print("" + iteration);
            out.print(SPLIT_CHAR);
            ++lineSplits;
            out.print(trr.getType().uiName());
            out.print(SPLIT_CHAR);
            out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
            ++n2;
        }
    }

    private void generateDetailedResults(PrintWriter out, VTable paramTable, boolean addUpdatedRegs, boolean addErrCaptRegs) {
        VParamVariation[][] cells;
        int lineSplits = 0;
        out.println(this.emptyLine);
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        out.print(DETAILED_CELL_RESULTS_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        VParamVariation[][] vParamVariationArray = cells = paramTable.getParamVariations();
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] cellRow;
            VParamVariation[] vParamVariationArray2 = cellRow = vParamVariationArray[n2];
            int n3 = cellRow.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell = vParamVariationArray2[n4];
                VParamVariation.VState state = cell.getState();
                if (cell.isSelected() && (state != VParamVariation.VState.SKIPPED && state != VParamVariation.VState.DEFAULT || cell.getNumFails() + cell.getNumPasses() != 0)) {
                    out.println(this.emptyLine);
                    lineSplits = 0;
                    out.print(SPLIT_CHAR);
                    out.print("Cell (" + cell.getPos().x + " - " + cell.getPos().y + ")");
                    out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
                    if (addUpdatedRegs && !paramTable.hasScriptParam()) {
                        this.generateParamVariationTable(out, paramTable, cell);
                    }
                    if (addErrCaptRegs) {
                        this.generateComplexTestExecSummary(out, paramTable, cell);
                    } else {
                        this.generateSimpleTestExecSummary(out, paramTable, cell);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void generateInitialConfiguration(PrintWriter out, VTable paramTable) {
        int lineSplits = 0;
        out.println(this.emptyLine);
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        out.print(INITIAL_DDR_CONFIG_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(REGISTER_NAME_HEADER);
        out.print(SPLIT_CHAR);
        out.print(REGISTER_VALUE_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
    }

    private void generateParamTableReport(PrintWriter out, VTable paramTable, IReportGenerator.ReportData data) {
        int numH = paramTable.getHParams().length;
        int numV = paramTable.getVParams().length;
        if (numH == 0 && numV == 1) {
            this.generateParamTableReport_H0_V1(out, paramTable);
        }
        if (numH == 0 && numV > 1) {
            this.generateParamTableReport_H0_Vn(out, paramTable);
        }
        if (numH == 1 && numV == 0) {
            this.generateParamTableReport_H1_V0(out, paramTable);
        }
        if (numH == 1 && numV == 1) {
            this.generateParamTableReport_H1_V1(out, paramTable);
        }
        if (numH == 1 && numV > 1) {
            this.generateParamTableReport_H1_Vn(out, paramTable);
        }
        if (numH > 1 && numV == 0) {
            this.generateParamTableReport_Hn_V0(out, paramTable);
        }
        if (numH > 1 && numV == 1) {
            this.generateParamTableReport_Hn_V1(out, paramTable);
        }
        if (numH > 1 && numV > 1) {
            this.generateParamTableReport_Hn_Vn(out, paramTable);
        }
        if (data.addInitConfigs) {
            this.generateInitialConfiguration(out, paramTable);
        }
        this.generateSelectedTestScripts(out, paramTable);
        if (data.addDetailedCellResults) {
            this.generateDetailedResults(out, paramTable, data.addUpdatedRegs, data.addErrCaptRegs);
        }
    }

    private void generateParamTableReport_H0_V1(PrintWriter out, VTable paramTable) {
        VParam vparam = paramTable.getVParams()[0];
        int numCols = vparam.getNumOptions();
        String hLabel = paramTable.getOptions().gethLabel();
        int lineSplits = 0;
        out.println(this.emptyLine);
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(CORNER_TEXT);
        out.print(SPLIT_CHAR);
        out.print(vparam.getName());
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        String[] optNamesLoc = vparam.getOptNames();
        if (optNamesLoc != null) {
            int i = 0;
            while (i < vparam.getNumOptions()) {
                out.print(optNamesLoc[i]);
                out.print(SPLIT_CHAR);
                ++lineSplits;
                ++i;
            }
        }
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - lineSplits));
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        if (hLabel != null) {
            out.print(hLabel);
        }
        out.print(SPLIT_CHAR);
        ++lineSplits;
        VParamVariation goldCell = paramTable.getGoldenVariation();
        Point goldCellPos = goldCell == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        int j = 0;
        while (j < numCols) {
            boolean isGoldCell = goldCellPos.x == 0 && goldCellPos.y == j;
            boolean isUserCell = userCellPos.x == 0 && userCellPos.y == j;
            out.print(CsvReportGenerator.cellText(paramTable.getParamVariation(new Point(0, j)), isGoldCell, isUserCell));
            out.print(SPLIT_CHAR);
            ++lineSplits;
            ++j;
        }
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - lineSplits));
    }

    private void generateParamTableReport_H0_Vn(PrintWriter out, VTable paramTable) {
    }

    private void generateParamTableReport_H1_V0(PrintWriter out, VTable paramTable) {
        VParam hparam = paramTable.getHParams()[0];
        int numRows = hparam.getNumOptions();
        String vLabel = paramTable.getOptions().getvLabel();
        int lineSplits = 0;
        out.println(this.emptyLine);
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(CORNER_TEXT);
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        if (vLabel != null) {
            out.print(vLabel);
        }
        out.print(SPLIT_CHAR);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        VParamVariation goldCell = paramTable.getGoldenVariation();
        Point goldCellPos = goldCell == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        int i = 0;
        while (i < numRows) {
            lineSplits = 0;
            out.print(SPLIT_CHAR);
            ++lineSplits;
            if (i == 0) {
                out.print(hparam.getName());
            }
            out.print(SPLIT_CHAR);
            ++lineSplits;
            String[] optNamesLoc = hparam.getOptNames();
            if (optNamesLoc != null) {
                out.print(optNamesLoc[i]);
            }
            out.print(SPLIT_CHAR);
            boolean isGoldCell = goldCellPos.x == i && goldCellPos.y == 0;
            boolean isUserCell = userCellPos.x == i && userCellPos.y == 0;
            out.print(CsvReportGenerator.cellText(paramTable.getParamVariation(new Point(i, 0)), isGoldCell, isUserCell));
            out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
            ++i;
        }
    }

    private void generateParamTableReport_H1_V1(PrintWriter out, VTable paramTable) {
        VParam hparam = paramTable.getHParams()[0];
        VParam vparam = paramTable.getVParams()[0];
        int numRows = hparam.getNumOptions();
        int numCols = vparam.getNumOptions();
        int lineSplits = 0;
        out.println(this.emptyLine);
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(CORNER_TEXT);
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(SPLIT_CHAR);
        out.print(vparam.getName());
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        String[] optNamesLoc = vparam.getOptNames();
        if (optNamesLoc != null) {
            int i = 0;
            while (i < vparam.getNumOptions()) {
                out.print(optNamesLoc[i]);
                out.print(SPLIT_CHAR);
                ++lineSplits;
                ++i;
            }
        }
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - lineSplits));
        VParamVariation goldCell = paramTable.getGoldenVariation();
        Point goldCellPos = goldCell == null ? new Point(-1, -1) : goldCell.getPos();
        VParamVariation userCell = paramTable.getUserVariation();
        Point userCellPos = userCell == null ? new Point(-1, -1) : userCell.getPos();
        int i = 0;
        while (i < numRows) {
            lineSplits = 0;
            out.print(SPLIT_CHAR);
            ++lineSplits;
            if (i == 0) {
                out.print(hparam.getName());
            }
            out.print(SPLIT_CHAR);
            ++lineSplits;
            optNamesLoc = hparam.getOptNames();
            if (optNamesLoc != null) {
                out.print(optNamesLoc[i]);
            }
            out.print(SPLIT_CHAR);
            ++lineSplits;
            int j = 0;
            while (j < numCols) {
                boolean isGoldCell = goldCellPos.x == i && goldCellPos.y == j;
                boolean isUserCell = userCellPos.x == i && userCellPos.y == j;
                out.print(CsvReportGenerator.cellText(paramTable.getParamVariation(new Point(i, j)), isGoldCell, isUserCell));
                out.print(SPLIT_CHAR);
                ++lineSplits;
                ++j;
            }
            out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - lineSplits));
            ++i;
        }
    }

    private void generateParamTableReport_H1_Vn(PrintWriter out, VTable paramTable) {
    }

    private void generateParamTableReport_Hn_V0(PrintWriter out, VTable paramTable) {
    }

    private void generateParamTableReport_Hn_V1(PrintWriter out, VTable paramTable) {
    }

    private void generateParamTableReport_Hn_Vn(PrintWriter out, VTable paramTable) {
    }

    private void generateParamVariationTable(PrintWriter out, VTable paramTable, VParamVariation cell) {
        String[][] paramNameValuePairs = cell.getParamNameValuePairs();
        int lineSplits = 0;
        out.println(this.emptyLine);
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        out.print(PARAM_VARIATION_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        int i = 0;
        while (i < paramNameValuePairs.length) {
            lineSplits = 0;
            out.print(SPLIT_CHAR);
            ++lineSplits;
            out.print(paramNameValuePairs[i][0]);
            out.print(SPLIT_CHAR);
            out.print(paramNameValuePairs[i][1]);
            out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
            ++i;
        }
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        out.print(REGISTER_VARIATION_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
    }

    @Override
    public boolean generateReport(VTable[] tables, IReportGenerator.ReportData data) {
        if (tables.length == 0) {
            return false;
        }
        this.computeElemsPerLine(tables);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (PrintWriter pwLoc = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(data.getConcreteFilePath()), StandardCharsets.UTF_8));){
                pwLoc.println(this.emptyLine);
                pwLoc.println(String.valueOf(SPLIT_CHAR) + DOC_TITLE + CsvReportGenerator.getSplitChars(this.elemsPerLine - 1));
                pwLoc.println(this.emptyLine);
                String dateString = DateFormat.getDateInstance(0, Locale.getDefault()).format(new Date());
                String subtitle = String.valueOf(MAIN_HEADER_PREFIX) + dateString;
                subtitle = subtitle.replace(SPLIT_CHAR, ' ');
                pwLoc.println(String.valueOf(SPLIT_CHAR) + subtitle + CsvReportGenerator.getSplitChars(this.elemsPerLine - 1));
                pwLoc.println(this.emptyLine);
                VTable[] vTableArray = tables;
                int n = tables.length;
                int n2 = 0;
                while (n2 < n) {
                    VTable table = vTableArray[n2];
                    if (table.getState() != VTable.TableState.CLEAN) {
                        this.generateTableReport(pwLoc, table, data);
                        pwLoc.println(this.emptyLine);
                    }
                    ++n2;
                }
                pwLoc.flush();
                pwLoc.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SecurityException noWriteAccess) {
            throw noWriteAccess;
        }
        catch (Exception e) {
            LOGGER.severe(String.valueOf(UtilsText.safeString((String)Messages.ReportGeneratorcannotGenerate)) + e.getMessage());
            return false;
        }
        return true;
    }

    private void generateSelectedTestScripts(PrintWriter out, VTable paramTable) {
        VScriptConfig[] tsus;
        int lineSplits = 0;
        out.println(this.emptyLine);
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        out.print(SELECTED_SCRIPTS_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(SCRIPT_HEADER);
        out.print(SPLIT_CHAR);
        out.print(ITERATION_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        VScriptConfig[] vScriptConfigArray = tsus = paramTable.getSelectedScriptConfigs();
        int n = tsus.length;
        int n2 = 0;
        while (n2 < n) {
            VScriptConfig tsu = vScriptConfigArray[n2];
            lineSplits = 0;
            out.print(SPLIT_CHAR);
            ++lineSplits;
            out.print(tsu.getScript().getName());
            out.print(SPLIT_CHAR);
            out.print(tsu.getNumRuns());
            out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
            ++n2;
        }
    }

    private void generateSimpleTestExecSummary(PrintWriter out, VTable paramTable, VParamVariation cell) {
        VRunResult[] trrs = cell.getResults();
        int lineSplits = 0;
        out.println(this.emptyLine);
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        out.print(CELL_TESTS_SUMMARY_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        lineSplits = 0;
        out.print(SCRIPT_NAME_SUMMARY_HEADER);
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(ITERATION_SUMMARY_HEADER);
        out.print(SPLIT_CHAR);
        out.print(RESULT_SUMMARY_HEADER);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        if (trrs != null) {
            VRunResult[] vRunResultArray = trrs;
            int n = trrs.length;
            int n2 = 0;
            while (n2 < n) {
                VRunResult trr = vRunResultArray[n2];
                lineSplits = 0;
                out.print(trr.getScriptConfig().getScript().getName());
                out.print(SPLIT_CHAR);
                ++lineSplits;
                int iteration = trr.getNumRun() + 1;
                out.print(String.format("%d", new Integer(iteration)));
                out.print(SPLIT_CHAR);
                out.print(trr.getType().uiName());
                out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
                ++n2;
            }
        }
    }

    private void generateSmokeTableReport(PrintWriter out, VTable smokeTable, IReportGenerator.ReportData data) {
        List<VScriptConfig> tsus = smokeTable.getScriptsConfig();
        ArrayList<VScriptConfig> availableTsus = new ArrayList<VScriptConfig>();
        for (VScriptConfig tsu : tsus) {
            if (tsu == null || tsu.getScript().isSpecific()) continue;
            availableTsus.add(tsu);
        }
        int numRows = availableTsus.size();
        int lineSplits = 0;
        out.println(this.emptyLine);
        lineSplits = 0;
        out.print(SPLIT_CHAR);
        ++lineSplits;
        out.print(CORNER_TEXT);
        out.print(SPLIT_CHAR);
        ++lineSplits;
        String vLabel = smokeTable.getOptions().getvLabel();
        if (vLabel != null) {
            out.print(vLabel);
        }
        out.print(SPLIT_CHAR);
        out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
        int i = 0;
        while (i < numRows) {
            lineSplits = 0;
            out.print(SPLIT_CHAR);
            ++lineSplits;
            out.print(((VScriptConfig)availableTsus.get(i)).getScript().getName());
            out.print(SPLIT_CHAR);
            out.print(CsvReportGenerator.cellText(smokeTable.getParamVariation(new Point(i, 0)), false, false));
            out.println(CsvReportGenerator.getSplitChars(this.elemsPerLine - ++lineSplits));
            ++i;
        }
        if (data.addInitConfigs) {
            this.generateInitialConfiguration(out, smokeTable);
        }
        this.generateSelectedTestScripts(out, smokeTable);
        if (data.addDetailedCellResults) {
            this.generateDetailedResults(out, smokeTable, data.addUpdatedRegs, data.addErrCaptRegs);
        }
    }

    private void generateTableReport(PrintWriter out, VTable table, IReportGenerator.ReportData data) {
        String tableQName = table.getQualifiedName();
        out.println(this.emptyLine);
        out.println(String.valueOf(SPLIT_CHAR) + tableQName + CsvReportGenerator.getSplitChars(this.elemsPerLine - 1));
        out.println(this.emptyLine);
        if (table.hasScriptParam()) {
            this.generateSmokeTableReport(out, table, data);
        } else {
            this.generateParamTableReport(out, table, data);
        }
    }

    @Override
    public IReportGenerator.ReportType getReportType() {
        return this.type;
    }
}

