/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.reports;

import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import java.util.Calendar;

public interface IReportGenerator {
    public boolean generateReport(VTable[] var1, ReportData var2);

    public ReportType getReportType();

    public static class AutoReportData
    extends ReportData {
        public static final boolean DEFAULT_USE_TIMESTAMP_SUFFIX = true;
        public AutoReportMode autoReportMode = DEFAULT_AUTO_REPORT_MODE;
        public int autoReportRepetition = 10;
        public boolean timestampSuffix = true;

        @Override
        public String getConcreteFilePath() {
            if (!this.timestampSuffix) {
                return this.filePath;
            }
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            int day = cal.get(5);
            int hour = cal.get(11);
            int min = cal.get(12);
            int sec = cal.get(13);
            int ms = cal.get(14);
            String newFilePath = this.filePath.substring(0, this.filePath.lastIndexOf(46));
            newFilePath = String.valueOf(newFilePath) + "_" + year;
            newFilePath = String.valueOf(newFilePath) + "_" + (month < 10 ? "0" + month : new Integer(month));
            newFilePath = String.valueOf(newFilePath) + "_" + (day < 10 ? "0" + day : new Integer(day));
            newFilePath = String.valueOf(newFilePath) + "_" + (hour < 10 ? "0" + hour : new Integer(hour));
            newFilePath = String.valueOf(newFilePath) + "_" + (min < 10 ? "0" + min : new Integer(min));
            newFilePath = String.valueOf(newFilePath) + "_" + (sec < 10 ? "0" + sec : new Integer(sec));
            newFilePath = String.valueOf(newFilePath) + "_" + (ms < 100 ? (ms < 10 ? "00" + ms : "0" + ms) : new Integer(ms));
            newFilePath = String.valueOf(newFilePath) + this.filePath.substring(this.filePath.lastIndexOf(46), this.filePath.length());
            return newFilePath;
        }
    }

    public static enum AutoReportMode {
        SCRIPT(UtilsText.safeString((String)Messages.IReportGenerator_0), 10, 1000),
        SECOND(UtilsText.safeString((String)Messages.IReportGenerator_1), 60, 1000),
        MINUTE(UtilsText.safeString((String)Messages.IReportGenerator_2), 1, 1000),
        HOUR(UtilsText.safeString((String)Messages.IReportGenerator_3), 1, 24);

        private String uiName;
        private int min;
        private int max;

        public static String[] getUiNames() {
            String[] uiNames = new String[AutoReportMode.values().length];
            int i = 0;
            AutoReportMode[] autoReportModeArray = AutoReportMode.values();
            int n = autoReportModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AutoReportMode value = autoReportModeArray[n2];
                uiNames[i++] = value.uiName();
                ++n2;
            }
            return uiNames;
        }

        private AutoReportMode(String _uiName, int _min, int _max) {
            this.uiName = _uiName;
            this.min = _min;
            this.max = _max;
        }

        public int max() {
            return this.max;
        }

        public int min() {
            return this.min;
        }

        public String uiName() {
            return this.uiName;
        }
    }

    public static class ReportData {
        public static final boolean DEFAULT_ENABLED = false;
        public static final String DEFAULT_PATH = "";
        public static final int DEFAULT_AUTO_REPORT_REPETITION = 10;
        public static final AutoReportMode DEFAULT_AUTO_REPORT_MODE = AutoReportMode.MINUTE;
        public static final ReportType DEFAULT_REPORT_TYPE = ReportType.JPG;
        public static final boolean DEFAULT_ADD_INIT_CONFIGS = true;
        public static final boolean DEFAULT_ADD_DETAILED_CELL_RESULTS = true;
        public static final boolean DEFAULT_ADD_UPDATED_REGS = true;
        public static final boolean DEFAULT_ADD_ERR_CAPT_REGS = true;
        public boolean enabled = false;
        private ReportType reportType = DEFAULT_REPORT_TYPE;
        protected String filePath = "";
        public boolean addInitConfigs = true;
        public boolean addDetailedCellResults = true;
        public boolean addUpdatedRegs = true;
        public boolean addErrCaptRegs = true;

        public void setReportType(ReportType reportType) {
            this.reportType = reportType;
        }

        public ReportType getReportType() {
            return this.reportType;
        }

        public void setConcreteFilePath(String filePath) {
            this.filePath = filePath;
        }

        public String getConcreteFilePath() {
            return this.filePath;
        }
    }

    public static enum ReportType {
        HTML("*.html;*.htm", ".html", "HTML web page"),
        CSV("*.csv", ".csv", "CSV file"),
        EXCEL("*.xlsx", ".xlsx", "Excel spreadsheet"),
        JPG("*.jpg", ".jpg", "JPEG image"),
        PNG("*.png", ".png", "PNG image"),
        LOG("*.log", ".log", "LOG file");

        public final String filterExt;
        public final String defaultExt;
        public final String filterName;

        public static String[] getExtensionNames() {
            String[] extensionNames = new String[ReportType.values().length];
            int i = 0;
            ReportType[] reportTypeArray = ReportType.values();
            int n = reportTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReportType value = reportTypeArray[n2];
                extensionNames[i++] = value.filterName;
                ++n2;
            }
            return extensionNames;
        }

        public static String[] getExtensions() {
            String[] extensions = new String[ReportType.values().length];
            int i = 0;
            ReportType[] reportTypeArray = ReportType.values();
            int n = reportTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReportType value = reportTypeArray[n2];
                extensions[i++] = value.filterExt;
                ++n2;
            }
            return extensions;
        }

        private ReportType(String _filterExt, String _defaultExt, String _filterName) {
            this.filterExt = _filterExt;
            this.defaultExt = _defaultExt;
            this.filterName = _filterName;
        }
    }
}

