/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.table.params;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.table.params.VParam;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BeanPropertyParam
extends VParam {
    protected BeanSymbol @Nullable [] symbols;
    @Nullable
    protected String pattern;
    @Nullable
    protected String prefix;
    @Nullable
    protected String postfix;
    @Nullable
    protected String unit;
    protected String @Nullable [] optValues;
    protected String @Nullable [] excludedOptValues;
    protected String @Nullable [] optNames;

    public BeanPropertyParam(BeanPropertyParam proto) {
        super(proto.id, proto.name, proto.horizontal);
        BeanSymbol[] protoSymbolsLoc = proto.symbols;
        if (protoSymbolsLoc != null) {
            BeanSymbol[] symbolsLoc = this.symbols = new BeanSymbol[protoSymbolsLoc.length];
            int symbolsLen = symbolsLoc.length;
            int i = 0;
            while (i < symbolsLen) {
                symbolsLoc[i] = new BeanSymbol(Objects.requireNonNull(protoSymbolsLoc[i]));
                ++i;
            }
        }
        this.pattern = proto.pattern;
        this.prefix = proto.prefix;
        this.postfix = proto.postfix;
        this.unit = proto.unit;
        if (proto.optValues != null) {
            this.optValues = (String[])proto.optValues.clone();
        }
        if (proto.excludedOptValues != null) {
            this.excludedOptValues = (String[])proto.excludedOptValues.clone();
        }
        if (proto.optNames != null) {
            this.optNames = (String[])proto.optNames.clone();
        }
    }

    public BeanPropertyParam(String _id, String _name, boolean _horizontal) {
        super(_id, _name, _horizontal);
    }

    @Override
    public void applyConfiguration(Object value, boolean handleChanges, boolean genCode) {
        IConfigProvider configController;
        BeanSymbol[] symbolsLoc = this.symbols;
        if (symbolsLoc != null && symbolsLoc.length > 0 && (configController = ValidationContext.getInstance().getConfigController()) != null) {
            configController.updatePropertyValue(symbolsLoc[0].getSymbol(), value.toString(), handleChanges, genCode);
        }
    }

    @Override
    public VParam createCopy() {
        return new BeanPropertyParam(this);
    }

    @Override
    public String @Nullable [] getOptNames() {
        return this.optNames != null ? (String[])this.optNames.clone() : null;
    }

    @Override
    public Object @Nullable [] getOptValues() {
        return this.optValues != null ? (Object[])this.optValues.clone() : null;
    }

    public BeanSymbol @Nullable [] getSymbols() {
        return this.symbols != null ? (BeanSymbol[])this.symbols.clone() : null;
    }

    @Override
    public void populate(ValidationContext vContext) {
        BeanSymbol[] symbolsLoc = this.symbols;
        if (symbolsLoc == null || symbolsLoc.length == 0) {
            return;
        }
        String[] optValuesLoc = this.optValues;
        if ((optValuesLoc == null || optValuesLoc.length == 0) && this.symbols != null) {
            BeanSymbol symbol = this.symbols[0];
            IConfigProvider configController = vContext.getConfigController();
            if (configController != null) {
                List<@Nullable String> optValuesList = configController.getPropertyRange(symbol.getSymbol());
                this.optValues = optValuesList.toArray(new String[optValuesList.size()]);
            }
        }
        if ((optValuesLoc = this.optValues) != null) {
            String[] optNamesLoc = this.optNames = (String[])optValuesLoc.clone();
            if (this.pattern != null && optNamesLoc != null) {
                String defaultPatternName = String.valueOf(this.prefix) + " " + '0' + " " + this.postfix;
                Pattern p = Pattern.compile(this.pattern);
                int i = 0;
                while (i < optValuesLoc.length) {
                    Matcher m = p.matcher(optValuesLoc[i]);
                    optNamesLoc[i] = m.find() ? String.valueOf(this.prefix) + " " + m.group() + " " + this.postfix : defaultPatternName;
                    ++i;
                }
            }
            if (this.unit != null && optNamesLoc != null) {
                int i = 0;
                while (i < optValuesLoc.length) {
                    int n = i++;
                    optNamesLoc[n] = String.valueOf(optNamesLoc[n]) + " " + this.unit;
                }
            }
        }
    }

    @Override
    public void update(ValidationContext vContext) {
    }

    public static class BeanSymbol {
        protected String symbol;
        protected String[] regNames;

        public BeanSymbol(BeanSymbol proto) {
            this.symbol = proto.symbol;
            this.regNames = (String[])proto.regNames.clone();
        }

        public BeanSymbol(String _symbol, String[] _regNames) {
            this.symbol = _symbol;
            this.regNames = (String[])_regNames.clone();
        }

        public String[] getRegNames() {
            return (String[])this.regNames.clone();
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

