/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.reports.IReportGenerator;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AutoReportsDialog
extends Dialog {
    private static final int TEXT_FILE_WIDTH_HINT = 250;
    private static final Logger LOGGER = LogManager.getLogger(AutoReportsDialog.class);
    @Nullable
    private transient VPresentationModel mainData;
    @Nullable
    private transient IReportGenerator.AutoReportData data;
    @Nullable
    protected Shell shlDdrvReports;
    @Nullable
    private Combo comboFileType;
    @Nullable
    private Combo comboRepetitionType;
    @Nullable
    private Text textFile;
    @Nullable
    private Text textRepetition;
    @Nullable
    private transient ControlDecoration textFileDecorator;
    @Nullable
    private transient ControlDecoration textRepetitionDecorator;
    @Nullable
    private Button btnOk;
    @Nullable
    private Button btnCancel;
    @Nullable
    private Button btnInitialDdrConfiguration;
    @Nullable
    private Button btnDetailedCellResults;
    @Nullable
    private Button btnCellUpdatedRegisters;
    @Nullable
    private Button btnErrorCaptureRegisters;
    @Nullable
    private Button btnEnable;
    @Nullable
    private Button btnAddTimestampSuffix;
    @Nullable
    private Button btnBrowse;
    @Nullable
    private Label lblFile;
    @Nullable
    private Label lblExportAs;
    @Nullable
    private Label lblAutogenerateEvery;
    @Nullable
    private Group grpReportOptions;
    @Nullable
    private GridData gd_btnBrowse;
    @Nullable
    private GridData gd_comboRepetitionType;
    @Nullable
    private GridData gd_btnCellUpdatedRegisters;
    @Nullable
    private GridData gd_btnErrorCaptureRegisters;
    @Nullable
    private GridData gd_btnOk;
    @Nullable
    private GridData gd_btnCancel;

    public static boolean canWriteReportFileToDisk(String filePath) {
        File fileDir = new File(filePath).getParentFile();
        File tempfile = new File(fileDir, "testwrite.tmp");
        try {
            return tempfile.createNewFile() && tempfile.delete();
        }
        catch (Exception securityException) {
            LOGGER.warning(securityException.getMessage());
            return false;
        }
    }

    public static boolean isReportFilePathValid(String filePath) {
        if (filePath.isEmpty()) {
            return false;
        }
        File reportDir = new File(filePath).getParentFile();
        return reportDir != null && reportDir.exists();
    }

    public AutoReportsDialog(Shell parent, int style, VPresentationModel _mainData) {
        super(parent, style);
        this.setText(Messages.SWTDialog);
        this.mainData = _mainData;
        this.data = this.mainData.getAutoReportData();
    }

    private void createContents() {
        Shell shlDdrvReportsLoc = this.shlDdrvReports = new Shell(this.getParent(), this.getStyle());
        shlDdrvReportsLoc.setText(Messages.AutoGenReportShell);
        shlDdrvReportsLoc.setLayout((Layout)new GridLayout(1, false));
        Button btnEnableLoc = this.btnEnable = new Button((Composite)shlDdrvReportsLoc, 32);
        btnEnableLoc.setText(Messages.EnableAutoGenBtn);
        btnEnableLoc.addSelectionListener((SelectionListener)new ReportOptionSelectionListener(this));
        Shell _shlDdrvReports = this.shlDdrvReports;
        if (_shlDdrvReports != null) {
            ControlDecoration textFileDecLoc;
            Composite fileComposite = new Composite((Composite)_shlDdrvReports, 0);
            fileComposite.setLayout((Layout)new GridLayout(3, false));
            fileComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.lblFile = new Label(fileComposite, 0);
            this.lblFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            if (this.lblFile != null) {
                this.lblFile.setText(Messages.FileLabel);
            }
            this.textFile = new Text(fileComposite, 2048);
            GridData textFileGd = new GridData(4, 0x1000000, true, false, 1, 1);
            textFileGd.widthHint = 250;
            Text textFileLoc = this.textFile;
            if (textFileLoc != null) {
                textFileLoc.setLayoutData((Object)textFileGd);
                textFileLoc.addFocusListener((FocusListener)new ReportPathFocusListener(this));
                textFileLoc.setEditable(false);
            }
            if ((textFileDecLoc = this.textFileDecorator) != null) {
                textFileDecLoc = new ControlDecoration((Control)this.textFile, 131200);
                textFileDecLoc.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
                textFileDecLoc.hide();
            }
            if (this.textFile != null) {
                this.textFile.setData("qcs.validation.ddr.widget.decorator", (Object)this.textFileDecorator);
            }
            Button btnBrowseLoc = this.btnBrowse = new Button(fileComposite, 0);
            this.gd_btnBrowse = new GridData(16384, 0x1000000, false, false, 1, 1);
            this.gd_btnBrowse.horizontalIndent = 10;
            btnBrowseLoc.setLayoutData((Object)this.gd_btnBrowse);
            btnBrowseLoc.setText(Messages.BrowseBtn);
            btnBrowseLoc.addSelectionListener((SelectionListener)new BrowseReportSelectionListener(this));
            Button btnAddTimestampSuffixLoc = this.btnAddTimestampSuffix;
            if (btnAddTimestampSuffixLoc != null) {
                btnAddTimestampSuffixLoc = new Button(fileComposite, 32);
                btnAddTimestampSuffixLoc.setEnabled(false);
                btnAddTimestampSuffixLoc.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
                btnAddTimestampSuffixLoc.setText(Messages.AddTimestampBtn);
                btnAddTimestampSuffixLoc.addSelectionListener((SelectionListener)new AddTimestampSelectionListener(this));
            }
            Composite fileTypeComposite = new Composite((Composite)_shlDdrvReports, 0);
            fileTypeComposite.setLayout((Layout)new GridLayout(2, false));
            fileTypeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            Label lblExportAsLoc = this.lblExportAs = new Label(fileTypeComposite, 0);
            lblExportAsLoc.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblExportAsLoc.setText(Messages.TypeLabel);
            Combo comboFileTypeLoc = this.comboFileType = new Combo(fileTypeComposite, 8);
            comboFileTypeLoc.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            comboFileTypeLoc.setItems(IReportGenerator.ReportType.getExtensionNames());
            comboFileTypeLoc.select(0);
            comboFileTypeLoc.addSelectionListener((SelectionListener)new ReportTypeSelectionListener(this));
            Composite composite = new Composite((Composite)_shlDdrvReports, 0);
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            composite.setLayout((Layout)new GridLayout(3, false));
            Label lblAutogenerateEveryLoc = this.lblAutogenerateEvery = new Label(composite, 0);
            lblAutogenerateEveryLoc.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblAutogenerateEveryLoc.setText(Messages.AutoGenEveryLabel);
            Text textRepetitionLoc = this.textRepetition = new Text(composite, 2048);
            textRepetitionLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            textRepetitionLoc.addFocusListener((FocusListener)new ReportRepetitionFocusListener(this));
            textRepetitionLoc.addVerifyListener((VerifyListener)new ReportRepetitionVerifyListener(this));
            ControlDecoration textRepetitionDecoratorLoc = this.textRepetitionDecorator = new ControlDecoration((Control)this.textRepetition, 131200);
            textRepetitionDecoratorLoc.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            textRepetitionDecoratorLoc.hide();
            if (this.textRepetition != null) {
                this.textRepetition.setData("qcs.validation.ddr.widget.decorator", (Object)this.textRepetitionDecorator);
            }
            Combo comboRepetitionTypeLoc = this.comboRepetitionType = new Combo(composite, 8);
            comboRepetitionTypeLoc.setItems(IReportGenerator.AutoReportMode.getUiNames());
            this.gd_comboRepetitionType = new GridData(4, 0x1000000, false, false, 1, 1);
            this.gd_comboRepetitionType.horizontalIndent = 10;
            comboRepetitionTypeLoc.setLayoutData((Object)this.gd_comboRepetitionType);
            comboRepetitionTypeLoc.select(0);
            comboRepetitionTypeLoc.addSelectionListener((SelectionListener)new RepetitionModeSelectionListener(this));
            Group grpReportOptionsLoc = this.grpReportOptions = new Group((Composite)this.shlDdrvReports, 0);
            grpReportOptionsLoc.setLayout((Layout)new GridLayout(1, false));
            grpReportOptionsLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            grpReportOptionsLoc.setText(Messages.ReportOptions);
            Button btnInitialDdrConfigurationLoc = this.btnInitialDdrConfiguration = new Button((Composite)grpReportOptionsLoc, 32);
            btnInitialDdrConfigurationLoc.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            btnInitialDdrConfigurationLoc.setText(Messages.InitialConfigBtn);
            btnInitialDdrConfigurationLoc.addSelectionListener((SelectionListener)new ReportOptionSelectionListener(this));
            Button btnDetailedCellResultsLoc = this.btnDetailedCellResults = new Button((Composite)grpReportOptionsLoc, 32);
            btnDetailedCellResultsLoc.setText(Messages.DetailedCellBtn);
            btnDetailedCellResultsLoc.addSelectionListener((SelectionListener)new ReportOptionSelectionListener(this));
            this.btnCellUpdatedRegisters = new Button((Composite)grpReportOptionsLoc, 32);
            this.gd_btnCellUpdatedRegisters = new GridData(16384, 0x1000000, false, false, 1, 1);
            this.gd_btnCellUpdatedRegisters.horizontalIndent = 20;
            Button btnCellUpdatedRegistersLoc = this.btnCellUpdatedRegisters;
            if (btnCellUpdatedRegistersLoc != null) {
                btnCellUpdatedRegistersLoc.setLayoutData((Object)this.gd_btnCellUpdatedRegisters);
                btnCellUpdatedRegistersLoc.setText(Messages.UpdateRegistersBtn);
                btnCellUpdatedRegistersLoc.addSelectionListener((SelectionListener)new ReportOptionSelectionListener(this));
            }
            this.btnErrorCaptureRegisters = new Button((Composite)grpReportOptionsLoc, 32);
            this.gd_btnErrorCaptureRegisters = new GridData(16384, 0x1000000, false, false, 1, 1);
            this.gd_btnErrorCaptureRegisters.horizontalIndent = 20;
            Button btnErrorCaptureRegistersLoc = this.btnErrorCaptureRegisters;
            if (btnErrorCaptureRegistersLoc != null) {
                btnErrorCaptureRegistersLoc.setLayoutData((Object)this.gd_btnErrorCaptureRegisters);
                btnErrorCaptureRegistersLoc.setText(Messages.ErrCaptureRegistersBtn);
                btnErrorCaptureRegistersLoc.addSelectionListener((SelectionListener)new ReportOptionSelectionListener(this));
            }
            Label label = new Label((Composite)this.shlDdrvReports, 258);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            Composite okCancelComposite = new Composite((Composite)_shlDdrvReports, 0);
            okCancelComposite.setLayout((Layout)new GridLayout(2, false));
            okCancelComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.btnOk = new Button(okCancelComposite, 0);
            this.gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
            this.gd_btnOk.widthHint = 100;
            Button btnOkLoc = this.btnOk;
            if (btnOkLoc != null) {
                btnOkLoc.setLayoutData((Object)this.gd_btnOk);
                btnOkLoc.setText(Messages.OkBtn);
                btnOkLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (AutoReportsDialog.this.verifyWriteAccess() && AutoReportsDialog.this.shlDdrvReports != null) {
                            AutoReportsDialog.this.shlDdrvReports.close();
                        }
                    }
                });
            }
            this.btnCancel = new Button(okCancelComposite, 0);
            this.gd_btnCancel = new GridData(131072, 0x1000000, false, false, 1, 1);
            this.gd_btnCancel.widthHint = 100;
            Button btnCancelLoc = this.btnCancel;
            if (btnCancelLoc != null) {
                btnCancelLoc.setLayoutData((Object)this.gd_btnCancel);
                btnCancelLoc.setText(Messages.CancelBtn);
                btnCancelLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (AutoReportsDialog.this.shlDdrvReports != null) {
                            AutoReportsDialog.this.shlDdrvReports.close();
                        }
                    }
                });
            }
        }
        if (this.shlDdrvReports != null) {
            this.shlDdrvReports.pack();
        }
    }

    private void enableUi() {
        IReportGenerator.AutoReportData dataLoc = this.data;
        if (dataLoc != null) {
            if (this.lblFile != null) {
                this.lblFile.setEnabled(dataLoc.enabled);
            }
            if (this.btnBrowse != null) {
                this.btnBrowse.setEnabled(dataLoc.enabled);
            }
            if (this.btnAddTimestampSuffix != null) {
                this.btnAddTimestampSuffix.setEnabled(dataLoc.enabled);
            }
            if (this.lblExportAs != null) {
                this.lblExportAs.setEnabled(dataLoc.enabled);
            }
            if (this.lblAutogenerateEvery != null) {
                this.lblAutogenerateEvery.setEnabled(dataLoc.enabled);
            }
            if (this.grpReportOptions != null) {
                this.grpReportOptions.setEnabled(dataLoc.enabled);
            }
            if (this.textFile != null) {
                this.textFile.setEnabled(dataLoc.enabled);
            }
            if (this.comboFileType != null) {
                this.comboFileType.setEnabled(dataLoc.enabled);
            }
            if (this.comboRepetitionType != null) {
                this.comboRepetitionType.setEnabled(dataLoc.enabled);
            }
            if (this.textRepetition != null) {
                this.textRepetition.setEnabled(dataLoc.enabled);
            }
            if (this.btnInitialDdrConfiguration != null) {
                this.btnInitialDdrConfiguration.setEnabled(dataLoc.enabled);
            }
            if (this.btnDetailedCellResults != null) {
                this.btnDetailedCellResults.setEnabled(dataLoc.enabled);
            }
            if (this.btnCellUpdatedRegisters != null) {
                this.btnCellUpdatedRegisters.setEnabled(dataLoc.addDetailedCellResults && dataLoc.enabled);
            }
            if (this.btnErrorCaptureRegisters != null) {
                this.btnErrorCaptureRegisters.setEnabled(dataLoc.addDetailedCellResults && dataLoc.enabled);
            }
        }
    }

    private @Nullable String getFilePathText() {
        IReportGenerator.AutoReportData dataLoc = this.data;
        if (dataLoc != null) {
            String filePath = dataLoc.getConcreteFilePath();
            if (dataLoc.timestampSuffix && !filePath.isEmpty()) {
                String suffixedFilePath = filePath.substring(0, filePath.lastIndexOf("."));
                suffixedFilePath = String.valueOf(suffixedFilePath) + Messages.TimestampTemplate;
                suffixedFilePath = String.valueOf(suffixedFilePath) + filePath.substring(filePath.lastIndexOf("."), filePath.length());
                return suffixedFilePath;
            }
            return filePath;
        }
        return null;
    }

    public @Nullable IReportGenerator.ReportType getSelectedReportType() {
        if (this.comboFileType != null) {
            int index = this.comboFileType.getSelectionIndex();
            return IReportGenerator.ReportType.values()[index];
        }
        return null;
    }

    public void open() {
        Shell parent;
        this.createContents();
        this.populateUi();
        this.enableUi();
        this.verifyUserInput();
        Shell shlDdrvReportsLoc = this.shlDdrvReports;
        if (shlDdrvReportsLoc != null) {
            shlDdrvReportsLoc.open();
            shlDdrvReportsLoc.layout();
        }
        if ((parent = this.getParent()) != null) {
            Display display = parent.getDisplay();
            while (this.shlDdrvReports != null && !this.shlDdrvReports.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private void populateUi() {
        IReportGenerator.AutoReportData dataLoc = this.data;
        if (dataLoc != null) {
            Text lTextFile;
            if (this.btnEnable != null) {
                this.btnEnable.setSelection(dataLoc.enabled);
            }
            if ((lTextFile = this.textFile) != null) {
                String ltext = this.getFilePathText();
                assert (ltext != null);
                lTextFile.setText(ltext);
            }
            int reportTypeIdx = 0;
            IReportGenerator.ReportType[] reportTypeArray = IReportGenerator.ReportType.values();
            int n = reportTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IReportGenerator.ReportType type = reportTypeArray[n2];
                if (type == dataLoc.getReportType()) break;
                ++reportTypeIdx;
                ++n2;
            }
            if (this.comboFileType != null) {
                this.comboFileType.select(reportTypeIdx);
            }
            int autoUpdateModeIdx = 0;
            IReportGenerator.AutoReportMode[] autoReportModeArray = IReportGenerator.AutoReportMode.values();
            int n3 = autoReportModeArray.length;
            n = 0;
            while (n < n3) {
                IReportGenerator.AutoReportMode mode = autoReportModeArray[n];
                if (mode == dataLoc.autoReportMode) break;
                ++autoUpdateModeIdx;
                ++n;
            }
            if (this.btnAddTimestampSuffix != null) {
                this.btnAddTimestampSuffix.setSelection(dataLoc.timestampSuffix);
            }
            if (this.comboRepetitionType != null) {
                this.comboRepetitionType.select(autoUpdateModeIdx);
            }
            if (this.textRepetition != null) {
                this.textRepetition.setText(" " + dataLoc.autoReportRepetition);
            }
            if (this.btnInitialDdrConfiguration != null) {
                this.btnInitialDdrConfiguration.setSelection(dataLoc.addInitConfigs);
            }
            if (this.btnDetailedCellResults != null) {
                this.btnDetailedCellResults.setSelection(dataLoc.addDetailedCellResults);
            }
            if (this.btnCellUpdatedRegisters != null) {
                this.btnCellUpdatedRegisters.setSelection(dataLoc.addUpdatedRegs);
            }
            if (this.btnErrorCaptureRegisters != null) {
                this.btnErrorCaptureRegisters.setSelection(dataLoc.addErrCaptRegs);
            }
        }
    }

    public void setFilePath(String filePath) {
        IReportGenerator.AutoReportData dataLoc = this.data;
        ControlDecoration textFileDecoratorLoc = this.textFileDecorator;
        if (dataLoc != null && textFileDecoratorLoc != null) {
            IReportGenerator.ReportType selectedReport = this.getSelectedReportType();
            if (selectedReport != null) {
                dataLoc.setReportType(selectedReport);
            }
            if (!filePath.endsWith(dataLoc.getReportType().defaultExt)) {
                dataLoc.setConcreteFilePath(String.valueOf(filePath.substring(0, filePath.lastIndexOf("."))) + dataLoc.getReportType().defaultExt);
            } else {
                dataLoc.setConcreteFilePath(filePath);
            }
            Text lTextFile = this.textFile;
            if (lTextFile != null) {
                String ltext = this.getFilePathText();
                assert (ltext != null);
                lTextFile.setText(ltext);
            }
            if (AutoReportsDialog.isReportFilePathValid(filePath)) {
                textFileDecoratorLoc.hide();
            } else {
                textFileDecoratorLoc.setDescriptionText(Messages.InvalidFilePath);
                textFileDecoratorLoc.show();
                if (this.btnOk != null) {
                    this.btnOk.setEnabled(false);
                }
            }
        }
    }

    void updateReportOptions(Button b) {
        IReportGenerator.AutoReportData dataLoc = this.data;
        if (dataLoc != null) {
            if (b == this.btnInitialDdrConfiguration) {
                dataLoc.addInitConfigs = b.getSelection();
            }
            if (b == this.btnDetailedCellResults) {
                dataLoc.addDetailedCellResults = b.getSelection();
                if (this.btnCellUpdatedRegisters != null) {
                    this.btnCellUpdatedRegisters.setEnabled(dataLoc.addDetailedCellResults);
                }
                if (this.btnErrorCaptureRegisters != null) {
                    this.btnErrorCaptureRegisters.setEnabled(dataLoc.addDetailedCellResults);
                }
                if (!dataLoc.addDetailedCellResults) {
                    dataLoc.addUpdatedRegs = false;
                    dataLoc.addErrCaptRegs = false;
                }
            }
            if (b == this.btnErrorCaptureRegisters) {
                dataLoc.addErrCaptRegs = b.getSelection();
            }
            if (b == this.btnCellUpdatedRegisters) {
                dataLoc.addUpdatedRegs = b.getSelection();
            }
            if (b == this.btnEnable) {
                dataLoc.enabled = b.getSelection();
                this.enableUi();
            }
            if (b == this.btnAddTimestampSuffix) {
                Text lTextFile;
                dataLoc.timestampSuffix = this.btnAddTimestampSuffix.getSelection();
                if (!dataLoc.getConcreteFilePath().isEmpty() && (lTextFile = this.textFile) != null) {
                    String ltext = this.getFilePathText();
                    assert (ltext != null);
                    lTextFile.setText(ltext);
                }
            }
        }
    }

    public void updateReportType() {
        if (this.comboFileType != null) {
            int typeIdx = this.comboFileType.getSelectionIndex();
            IReportGenerator.ReportType newType = IReportGenerator.ReportType.values()[typeIdx];
            IReportGenerator.AutoReportData dataLoc = this.data;
            if (dataLoc != null && dataLoc.getReportType() != newType) {
                dataLoc.setReportType(newType);
                String filePath = dataLoc.getConcreteFilePath();
                if (filePath.contains(".")) {
                    dataLoc.setConcreteFilePath(String.valueOf(filePath.substring(0, filePath.lastIndexOf("."))) + newType.defaultExt);
                } else {
                    dataLoc.setConcreteFilePath(String.valueOf(filePath) + newType.defaultExt);
                }
                Text lTextFile = this.textFile;
                if (lTextFile != null) {
                    String ltext = this.getFilePathText();
                    assert (ltext != null);
                    lTextFile.setText(ltext);
                }
            }
        }
    }

    public boolean verifyFilePath() {
        ControlDecoration textFileDecoratorLoc;
        IReportGenerator.AutoReportData dataLoc = this.data;
        if (dataLoc != null && (textFileDecoratorLoc = this.textFileDecorator) != null) {
            if (AutoReportsDialog.isReportFilePathValid(dataLoc.getConcreteFilePath())) {
                this.updateReportType();
                textFileDecoratorLoc.hide();
                return true;
            }
            if (dataLoc.enabled) {
                textFileDecoratorLoc.setDescriptionText(Messages.InvalidFilePath);
                textFileDecoratorLoc.show();
            }
            return false;
        }
        return false;
    }

    public boolean verifyRepetition() {
        block7: {
            if (this.comboRepetitionType != null) {
                int repTypeIdx = this.comboRepetitionType.getSelectionIndex();
                IReportGenerator.AutoReportMode autoRepMode = IReportGenerator.AutoReportMode.values()[repTypeIdx];
                int minRep = autoRepMode.min();
                int maxRep = autoRepMode.max();
                IReportGenerator.AutoReportData dataLoc = this.data;
                ControlDecoration textRepetitionDecoratorLoc = this.textRepetitionDecorator;
                if (dataLoc != null && textRepetitionDecoratorLoc != null) {
                    int numRep;
                    block8: {
                        this.data.autoReportMode = autoRepMode;
                        try {
                            String selectedRep;
                            if (this.textRepetition == null || (selectedRep = this.textRepetition.getText()) == null) break block7;
                            numRep = Integer.decode(selectedRep);
                            if (numRep >= minRep && numRep <= maxRep) break block8;
                            if (dataLoc.enabled) {
                                textRepetitionDecoratorLoc.setDescriptionText(MessageFormat.format(Messages.InvalidValue, new Integer(minRep), new Integer(maxRep)));
                                textRepetitionDecoratorLoc.show();
                            }
                            return false;
                        }
                        catch (Exception e) {
                            LOGGER.severe(String.valueOf(e.getMessage()) + MessageFormat.format(Messages.InvalidValue, new Integer(minRep), new Integer(maxRep)));
                            if (dataLoc.enabled) {
                                textRepetitionDecoratorLoc.setDescriptionText(MessageFormat.format(Messages.InvalidValue, new Integer(minRep), new Integer(maxRep)));
                                textRepetitionDecoratorLoc.show();
                            }
                            return false;
                        }
                    }
                    textRepetitionDecoratorLoc.hide();
                    dataLoc.autoReportRepetition = numRep;
                    return true;
                }
            }
        }
        return false;
    }

    public void verifyUserInput() {
        boolean pathOk = this.verifyFilePath();
        boolean repOk = this.verifyRepetition();
        if (this.btnOk != null) {
            this.btnOk.setEnabled(pathOk && repOk);
        }
    }

    public boolean verifyWriteAccess() {
        IReportGenerator.AutoReportData dataLoc = this.data;
        if (dataLoc != null) {
            if (dataLoc.getConcreteFilePath().equals("")) {
                return false;
            }
            if (AutoReportsDialog.canWriteReportFileToDisk(dataLoc.getConcreteFilePath())) {
                return true;
            }
            if (dataLoc.enabled) {
                ControlDecoration textFileDecoratorLoc;
                if (this.btnOk != null) {
                    this.btnOk.setEnabled(false);
                }
                if ((textFileDecoratorLoc = this.textFileDecorator) != null) {
                    textFileDecoratorLoc.setDescriptionText(String.valueOf(Messages.PermissionDenied) + System.getProperty("user.name"));
                    textFileDecoratorLoc.show();
                }
            }
            return false;
        }
        return false;
    }

    protected static class AddTimestampSelectionListener
    extends SelectionAdapter {
        private AutoReportsDialog parentDialog;

        public AddTimestampSelectionListener(AutoReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void widgetSelected(SelectionEvent e) {
            Button btn;
            if (e != null && (btn = (Button)e.widget) != null) {
                this.parentDialog.updateReportOptions(btn);
            }
        }
    }

    protected static class BrowseReportSelectionListener
    extends SelectionAdapter {
        private AutoReportsDialog parentDialog;

        public BrowseReportSelectionListener(AutoReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(this.parentDialog.getParent(), 8192);
            dialog.setOverwrite(false);
            IReportGenerator.ReportType repType = this.parentDialog.getSelectedReportType();
            if (repType != null) {
                dialog.setFilterNames(new String[]{repType.filterName});
                dialog.setFilterExtensions(new String[]{repType.filterExt});
                dialog.setFileName(String.valueOf(Messages.AutoReportName) + repType.defaultExt);
                dialog.setText(Messages.OpenFileTitle);
                String filePath = dialog.open();
                if (filePath != null) {
                    this.parentDialog.setFilePath(filePath);
                }
                this.parentDialog.verifyUserInput();
            }
        }
    }

    protected static class RepetitionModeSelectionListener
    extends SelectionAdapter {
        private AutoReportsDialog parentDialog;

        public RepetitionModeSelectionListener(AutoReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void widgetSelected(SelectionEvent e) {
            this.parentDialog.verifyUserInput();
        }
    }

    protected static class ReportOptionSelectionListener
    extends SelectionAdapter {
        private AutoReportsDialog parentDialog;

        public ReportOptionSelectionListener(AutoReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void widgetSelected(SelectionEvent e) {
            Button btn;
            if (e != null && (btn = (Button)e.widget) != null) {
                this.parentDialog.updateReportOptions(btn);
            }
        }
    }

    protected static class ReportPathFocusListener
    extends FocusAdapter {
        private AutoReportsDialog parentDialog;

        public ReportPathFocusListener(AutoReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void focusLost(@Nullable FocusEvent e) {
            this.parentDialog.verifyUserInput();
        }
    }

    protected static class ReportRepetitionFocusListener
    extends FocusAdapter {
        private AutoReportsDialog parentDialog;

        public ReportRepetitionFocusListener(AutoReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void focusLost(@Nullable FocusEvent e) {
            this.parentDialog.verifyUserInput();
        }
    }

    protected static class ReportRepetitionVerifyListener
    implements VerifyListener {
        private AutoReportsDialog parentDialog;

        public ReportRepetitionVerifyListener(AutoReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void verifyText(@Nullable VerifyEvent event) {
            if (event != null) {
                Pattern p;
                Matcher m;
                if (event.start == event.end) {
                    return;
                }
                boolean specialKey = false;
                switch (event.keyCode) {
                    case 8: 
                    case 127: {
                        specialKey = true;
                        break;
                    }
                }
                event.doit = !specialKey ? (m = (p = Pattern.compile("[0-9]+")).matcher(event.text)).matches() : true;
            }
            this.parentDialog.verifyUserInput();
        }
    }

    protected static class ReportTypeSelectionListener
    extends SelectionAdapter {
        private AutoReportsDialog parentDialog;

        public ReportTypeSelectionListener(AutoReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void widgetSelected(SelectionEvent e) {
            this.parentDialog.verifyUserInput();
        }
    }
}

