/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import java.util.logging.Logger;

class ByteConverter {
    private static final String CONVERT_ERR_VAL = "0";
    private static final Logger LOGGER = LogManager.getLogger(ByteConverter.class);
    @Nullable
    private String fromBase;
    @Nullable
    private String toBase;

    public @Nullable Object convert(Object fromObject) {
        String val = null;
        try {
            long kByteVal = 0L;
            String fromBaseLoc = this.fromBase;
            String toBaseLoc = this.toBase;
            long value = Long.parseLong(fromObject.toString());
            if (fromBaseLoc != null && toBaseLoc != null) {
                if (fromBaseLoc.equals(Messages.UnitB)) {
                    kByteVal = value;
                } else if (fromBaseLoc.equals(Messages.UnitKB) && value <= 0x1FFFFFFFFFFFFFL) {
                    kByteVal = value * 1024L;
                } else if (fromBaseLoc.equals(Messages.UnitMB) && value <= 0x7FFFFFFFFFFL) {
                    kByteVal = value * 0x100000L;
                } else if (fromBaseLoc.equals(Messages.UnitGB) && value <= 0x1FFFFFFFFL) {
                    kByteVal = value * 0x40000000L;
                }
                if (toBaseLoc.equals(Messages.UnitB)) {
                    val = Long.toString(kByteVal);
                } else if (toBaseLoc.equals(Messages.UnitKB)) {
                    val = Long.toString(kByteVal / 1024L);
                } else if (toBaseLoc.equals(Messages.UnitMB)) {
                    val = Long.toString(kByteVal / 0x100000L);
                } else if (toBaseLoc.equals(Messages.UnitGB)) {
                    val = Long.toString(kByteVal / 0x40000000L);
                }
            }
        }
        catch (Exception e) {
            val = CONVERT_ERR_VAL;
            LOGGER.warning(e.getMessage());
        }
        return val;
    }

    public Object getFromType() {
        return String.class;
    }

    public Object getToType() {
        return String.class;
    }

    public void setBases(String fromBase, String toBase) {
        this.fromBase = fromBase;
        this.toBase = toBase;
    }
}

