/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IMemValViewConfigProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExecutionView
extends Composite {
    protected static final Logger LOGGER = LogManager.getLogger(ExecutionView.class);
    @Nullable
    private transient IMemValViewConfigProvider memValViewConfigProvider;
    private Button btnRunTests;
    private transient ControlDecoration btnRunTestsDecorator;

    private static @Nullable Image getErrorDecoratorImage() {
        return FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    }

    private static @Nullable Image getInfoDecoratorImage() {
        return FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
    }

    private static @Nullable Image getWarningDecoratorImage() {
        return FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
    }

    public ExecutionView(Composite parentView) {
        super(parentView, 0);
        IConfigurationElement[] viewConfig = IMemValViewConfigProvider.getConfigProviders();
        try {
            IConfigurationElement[] iConfigurationElementArray = viewConfig;
            int n = viewConfig.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof IMemValViewConfigProvider) {
                    this.memValViewConfigProvider = (IMemValViewConfigProvider)o;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            LOGGER.warning(ex.getLocalizedMessage());
        }
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnRunTests = new Button((Composite)this, 8);
        this.btnRunTests.setLayoutData((Object)new GridData(4, 0, true, false));
        this.updateVButtonText();
        this.btnRunTests.setImage(Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui.cheatsheets/icons/elcl16/start_task.png"));
        this.btnRunTests.setEnabled(false);
        this.btnRunTestsDecorator = new ControlDecoration((Control)this.btnRunTests, 0x1004000);
        this.btnRunTestsDecorator.setImage(ExecutionView.getWarningDecoratorImage());
        this.btnRunTestsDecorator.setDescriptionText("");
        this.btnRunTestsDecorator.hide();
        this.btnRunTests.setData("qcs.validation.ddr.widget.decorator", (Object)this.btnRunTestsDecorator);
    }

    protected void checkSubclass() {
    }

    public void dispose() {
        this.btnRunTests.dispose();
        super.dispose();
    }

    public void disableView() {
        this.btnRunTests.setEnabled(false);
    }

    public void setInput(ExecutionPresentationModel data) {
        if (this.btnRunTests.isDisposed()) {
            return;
        }
        if (this.btnRunTests.getEnabled() != data.isStartEnabled()) {
            this.setValidateButtonEnabled(data.isStartEnabled());
        }
        ExecutionPresentationModel.StartValidationMode startMode = data.getStartMode();
        this.updateVButton(startMode);
        ExecutionPresentationModel.DecoratorType startDecType = data.getStartDecoratorType();
        String startDecTooltip = data.getStartDecoratorTooltip();
        if (!this.btnRunTestsDecorator.getDescriptionText().equals(startDecTooltip)) {
            switch (startDecType) {
                case ERROR: {
                    this.btnRunTestsDecorator.setDescriptionText(startDecTooltip);
                    this.btnRunTestsDecorator.setImage(ExecutionView.getErrorDecoratorImage());
                    this.btnRunTestsDecorator.show();
                    break;
                }
                case INFO: {
                    this.btnRunTestsDecorator.setDescriptionText(startDecTooltip);
                    this.btnRunTestsDecorator.setImage(ExecutionView.getInfoDecoratorImage());
                    this.btnRunTestsDecorator.show();
                    break;
                }
                case NONE: {
                    this.btnRunTestsDecorator.setDescriptionText("");
                    this.btnRunTestsDecorator.hide();
                    break;
                }
                case WARNING: {
                    this.btnRunTestsDecorator.setDescriptionText(startDecTooltip);
                    this.btnRunTestsDecorator.setImage(ExecutionView.getWarningDecoratorImage());
                    this.btnRunTestsDecorator.show();
                    break;
                }
            }
        }
    }

    public void setValidateButtonEnabled(boolean enabled) {
        this.btnRunTests.setEnabled(enabled);
    }

    public void setVButtonSelectionListener(SelectionListener listener) {
        this.btnRunTests.addSelectionListener(listener);
    }

    public void updateVButton(ExecutionPresentationModel.StartValidationMode mode) {
        switch (mode) {
            case CANCEL: {
                this.btnRunTests.setImage(Activator.getDefault().getImage("nav_stop.gif"));
                this.btnRunTests.setText(Messages.CancelTests);
                this.btnRunTests.setToolTipText(Messages.CancelTests);
                break;
            }
            case NEXT_STEP: {
                this.btnRunTests.setText(Messages.NextStepButtonString);
                this.btnRunTests.setToolTipText(Messages.NextStepButtonString);
                this.btnRunTests.setImage(Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui.cheatsheets/icons/elcl16/start_task.png"));
                break;
            }
            case VALIDATE: {
                this.updateVButtonText();
                this.btnRunTests.setImage(Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui.cheatsheets/icons/elcl16/start_task.png"));
                break;
            }
            case WAIT_SYNC: {
                this.btnRunTests.setText(Messages.WaitForSyncButtonString);
                this.btnRunTests.setToolTipText(Messages.WaitForSyncTooltipString);
                this.btnRunTests.setImage(null);
            }
        }
    }

    private void updateVButtonText() {
        String customTestsLabel;
        String runTestsLabel = Messages.StartValidation;
        if (this.memValViewConfigProvider != null && !(customTestsLabel = this.memValViewConfigProvider.getRunTestsButtonName()).isEmpty()) {
            runTestsLabel = customTestsLabel;
        }
        this.btnRunTests.setText(runTestsLabel);
        this.btnRunTests.setToolTipText(runTestsLabel);
    }
}

