/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.IChartView;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImageEyeView
implements IChartView {
    @Nullable
    private ScrolledComposite graphScrolledPanel;
    @Nullable
    private Canvas graphCanvas;
    @Nullable
    private Image graphImage;
    @Nullable
    private VStagePresentation selectedStage;

    @Override
    public @Nullable Canvas createChart(CTabFolder scenTabFolder, @Nullable CTabItem diagsTab) {
        Composite scrolledCompositeParent = new Composite((Composite)scenTabFolder, 0);
        scrolledCompositeParent.setLayout((Layout)new FillLayout());
        ScrolledComposite crtGraphScrolledPanel = this.graphScrolledPanel = new ScrolledComposite(scrolledCompositeParent, 2816);
        crtGraphScrolledPanel.setExpandHorizontal(true);
        crtGraphScrolledPanel.setExpandVertical(true);
        Canvas crtGraphCanvas = this.graphCanvas = new Canvas((Composite)crtGraphScrolledPanel, 0);
        crtGraphCanvas.setData((Object)Messages.VScenarioView_diagsTabName);
        crtGraphCanvas.setLayout((Layout)new GridLayout(1, true));
        crtGraphCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.populateCanvas(crtGraphCanvas);
        crtGraphCanvas.addListener(9, event -> {
            Image crtGraphImage = this.graphImage;
            if (crtGraphImage != null) {
                GC gc = Objects.requireNonNull(Objects.requireNonNull(event).gc);
                gc.setAntialias(1);
                gc.setInterpolation(2);
                gc.drawImage(crtGraphImage, 0, 0);
            }
        });
        crtGraphScrolledPanel.setContent((Control)this.graphCanvas);
        crtGraphScrolledPanel.setDragDetect(true);
        CTabItem diagsTabLoc = diagsTab;
        if (diagsTabLoc != null && !diagsTabLoc.isDisposed()) {
            diagsTabLoc.setControl((Control)scrolledCompositeParent);
        }
        return this.graphCanvas;
    }

    @Override
    public @Nullable Canvas setInput(VStagePresentation selectedStage, CTabFolder scenTabFolder, CTabItem diagsTab) {
        this.selectedStage = selectedStage;
        this.graphCanvas = this.createChart(scenTabFolder, diagsTab);
        if (this.graphCanvas != null) {
            this.graphCanvas.redraw();
        }
        return this.graphCanvas;
    }

    @Override
    public void setScenarioPaintListener(PaintListener paintListener) {
    }

    @Override
    public @Nullable Canvas createEmptyView(CTabFolder scenTabFolder, @Nullable CTabItem diagsTab) {
        Composite scrolledCompositeParent = new Composite((Composite)scenTabFolder, 0);
        scrolledCompositeParent.setLayout((Layout)new FillLayout());
        ScrolledComposite crtGraphScrolledPanel = this.graphScrolledPanel = new ScrolledComposite(scrolledCompositeParent, 2816);
        crtGraphScrolledPanel.setExpandHorizontal(true);
        crtGraphScrolledPanel.setExpandVertical(true);
        Canvas crtGraphCanvas = this.graphCanvas = new Canvas((Composite)this.graphScrolledPanel, 0);
        crtGraphCanvas.setLayout((Layout)new GridLayout(1, true));
        crtGraphCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.populateCanvas(crtGraphCanvas);
        return this.graphCanvas;
    }

    private void populateCanvas(Canvas graph) {
        VTable table;
        VParamVariation cell;
        VTableGroup[] tableGroup;
        VScenarioPresentation scenario;
        VStagePresentation stage = this.selectedStage;
        if (stage != null && (scenario = stage.getSelectedScenario()) != null && (tableGroup = scenario.getModel().getTableGroups()) != null && (cell = (table = tableGroup[0].getTables()[0]).getParamVariation(new Point(0, 0))) != null) {
            VRunResult runResult = cell.getResult(0);
            GridData layoutData = new GridData(64, 64, true, true);
            layoutData.verticalAlignment = 128;
            layoutData.horizontalAlignment = 1;
            if (runResult != null) {
                if (runResult.getType() == VRunResult.ResultType.FAILED) {
                    Text text = new Text((Composite)graph, 515);
                    text.setText(runResult.getErrorMessage());
                    text.setLayoutData((Object)layoutData);
                    text.setVisible(true);
                } else if (runResult.getType() == VRunResult.ResultType.PASSED) {
                    String figureFilePath = TestResultsLogger.getFigureLogFilePath(cell);
                    if (Files.exists(Paths.get(figureFilePath, new String[0]), new LinkOption[0])) {
                        Image crtGraphImage = this.graphImage = new Image((Device)graph.getDisplay(), figureFilePath);
                        Point imageSize = new Point(crtGraphImage.getBounds().width, crtGraphImage.getBounds().height);
                        graph.setSize(imageSize);
                        if (this.graphScrolledPanel != null) {
                            ScrolledComposite crtGraphScrolledPanel = this.graphScrolledPanel;
                            crtGraphScrolledPanel.setMinSize(imageSize);
                        }
                    } else {
                        Label label = new Label((Composite)graph, 1);
                        label.setText(Messages.DiagTestCollectingData);
                        label.setLayoutData((Object)layoutData);
                        label.setVisible(true);
                    }
                } else if (table.getState() == VTable.TableState.RUNNING) {
                    Label label = new Label((Composite)graph, 1);
                    label.setText(Messages.DiagTestNoData);
                    label.setLayoutData((Object)layoutData);
                    label.setVisible(true);
                }
            }
        }
    }
}

