/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.reports.IReportGenerator;
import com.nxp.swtools.mem.validation.ui.VScenarioView;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReportsDialog
extends Dialog {
    private static final Logger LOGGER = LogManager.getLogger(ReportsDialog.class);
    private static final int TEXT_FILE_WIDTH_HINT = 250;
    @Nullable
    protected Shell shlDdrvReports;
    @Nullable
    Text textFile;
    @Nullable
    private ControlDecoration textFileDecorator;
    @Nullable
    private Combo comboFileType;
    @Nullable
    VPresentationModel mainData;
    @Nullable
    IReportGenerator.ReportData data;
    @Nullable
    private Button btnOk;
    @Nullable
    private Button btnCancel;
    @Nullable
    private Button btnInitialDdrConfiguration;
    @Nullable
    private Button btnDetailedCellResults;
    @Nullable
    private Button btnCellUpdatedRegisters;
    @Nullable
    private Button btnErrorCaptureRegisters;
    @Nullable
    private Label lblFile;
    @Nullable
    private Button btnBrowse;
    @Nullable
    private Label lblExportAs;
    @Nullable
    private Group grpReportOptions;
    @Nullable
    private GridData gd_btnCellUpdatedRegisters;
    @Nullable
    private GridData gd_btnErrorCaptureRegisters;
    @Nullable
    private GridData gd_btnOk;
    @Nullable
    private GridData gd_btnCancel;

    public static boolean canWriteReportFileToDisk(String filePath) {
        File fileDir = new File(filePath).getParentFile();
        File tempfile = new File(fileDir, "testwrite.tmp");
        try {
            return tempfile.createNewFile() && tempfile.delete();
        }
        catch (Exception securityException) {
            LOGGER.info(securityException.getMessage());
            return false;
        }
    }

    public static boolean isReportFilePathValid(String filePath) {
        if (filePath.isEmpty()) {
            return false;
        }
        File reportDir = new File(filePath).getParentFile();
        return reportDir != null && reportDir.exists();
    }

    public ReportsDialog(Shell parent, int style, VPresentationModel mainData, IReportGenerator.ReportType reportType) {
        super(parent, style);
        this.setText(Messages.SWTDialogTitle);
        this.mainData = mainData;
        IReportGenerator.ReportData dataLoc = this.data = mainData.getReportData();
        if (reportType == IReportGenerator.ReportType.JPG) {
            VScenarioView vScenarioV = mainData.getView().getScenarioView();
            if (vScenarioV.isImageEyeViewVisible()) {
                dataLoc.setReportType(IReportGenerator.ReportType.PNG);
            } else if (vScenarioV.isOverlayDiagsVisible()) {
                dataLoc.setReportType(IReportGenerator.ReportType.HTML);
            } else {
                dataLoc.setReportType(reportType);
            }
        } else {
            dataLoc.setReportType(reportType);
        }
        if (!dataLoc.getConcreteFilePath().endsWith(dataLoc.getReportType().defaultExt)) {
            dataLoc.setConcreteFilePath("");
        }
    }

    private void createContents() {
        IConfigProvider configController;
        Shell parent = this.getParent();
        Shell shlDdrvReportsLoc = this.shlDdrvReports = new Shell(parent, this.getStyle());
        if (parent != null) {
            Point parentSize = parent.getSize();
            shlDdrvReportsLoc.setLocation(parentSize.x / 2, parentSize.y / 2);
        }
        if ((configController = ValidationContext.getInstance().getConfigController()) != null) {
            shlDdrvReportsLoc.setText(configController.getReportLabel());
        } else {
            shlDdrvReportsLoc.setText(Messages.GenerateReportLabel);
        }
        shlDdrvReportsLoc.setLayout((Layout)new GridLayout(1, false));
        Shell _shlDdrvReports = this.shlDdrvReports;
        if (_shlDdrvReports != null) {
            _shlDdrvReports.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    if (ReportsDialog.this.textFile != null) {
                        ReportsDialog.this.textFile.setText("");
                    }
                }
            });
            Composite fileComposite = new Composite((Composite)_shlDdrvReports, 0);
            fileComposite.setLayout((Layout)new GridLayout(3, false));
            fileComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            Label lblFileLoc = this.lblFile = new Label(fileComposite, 0);
            lblFileLoc.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            lblFileLoc.setText(Messages.FileLabel);
            this.textFile = new Text(fileComposite, 2048);
            GridData textFileGd = new GridData(4, 0x1000000, true, false, 1, 1);
            textFileGd.widthHint = 250;
            Text textFileLoc = this.textFile;
            if (textFileLoc != null) {
                textFileLoc.setEditable(SWToolsProperties.isTestOn());
                textFileLoc.setLayoutData((Object)textFileGd);
                textFileLoc.addFocusListener((FocusListener)new ReportPathFocusListener(this));
                textFileLoc.addModifyListener((ModifyListener)new FilePathListener(this));
            }
            ControlDecoration textFileDecoratorLoc = this.textFileDecorator = new ControlDecoration((Control)this.textFile, 131200);
            textFileDecoratorLoc.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            textFileDecoratorLoc.hide();
            if (this.textFile != null) {
                this.textFile.setData("qcs.validation.ddr.widget.decorator", (Object)this.textFileDecorator);
            }
            this.btnBrowse = new Button(fileComposite, 0);
            GridData gd_btnBrowse = new GridData(16384, 0x1000000, false, false, 1, 1);
            gd_btnBrowse.horizontalIndent = 10;
            Button btnBrowseLoc = this.btnBrowse;
            if (btnBrowseLoc != null) {
                btnBrowseLoc.setLayoutData((Object)gd_btnBrowse);
                btnBrowseLoc.setText(Messages.BrowseLabel);
                btnBrowseLoc.addSelectionListener((SelectionListener)new BrowseReportSelectionListener(this));
            }
            Composite fileTypeComposite = new Composite((Composite)_shlDdrvReports, 0);
            fileTypeComposite.setLayout((Layout)new GridLayout(2, false));
            fileTypeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            Label lblExportAsLoc = this.lblExportAs = new Label(fileTypeComposite, 0);
            lblExportAsLoc.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            lblExportAsLoc.setText(Messages.TypeLabel);
            Combo comboFileTypeLoc = this.comboFileType = new Combo(fileTypeComposite, 8);
            comboFileTypeLoc.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            comboFileTypeLoc.setItems(IReportGenerator.ReportType.getExtensionNames());
            if (this.data != null) {
                IReportGenerator.ReportData dataLoc = this.data;
                int reportTypeIdx = comboFileTypeLoc.indexOf(dataLoc.getReportType().filterName);
                if (reportTypeIdx >= 0) {
                    comboFileTypeLoc.select(reportTypeIdx);
                } else {
                    comboFileTypeLoc.select(3);
                }
            }
            comboFileTypeLoc.setEnabled(false);
            Group grpReportOptionsLoc = this.grpReportOptions = new Group((Composite)this.shlDdrvReports, 0);
            grpReportOptionsLoc.setLayout((Layout)new GridLayout(1, false));
            grpReportOptionsLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            grpReportOptionsLoc.setText(Messages.ReportOptLabel);
            Button btnInitialDdrConfigurationLoc = this.btnInitialDdrConfiguration = new Button((Composite)grpReportOptionsLoc, 32);
            btnInitialDdrConfigurationLoc.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            btnInitialDdrConfigurationLoc.setText(Messages.InitialDDRConfigLabel);
            btnInitialDdrConfigurationLoc.addSelectionListener((SelectionListener)new ReportOptionSelectionListener(this));
            Button btnDetailedCellResultsLoc = this.btnDetailedCellResults = new Button((Composite)grpReportOptionsLoc, 32);
            btnDetailedCellResultsLoc.setText(Messages.DetailedResultsLabel);
            btnDetailedCellResultsLoc.addSelectionListener((SelectionListener)new ReportOptionSelectionListener(this));
            this.btnCellUpdatedRegisters = new Button((Composite)grpReportOptionsLoc, 32);
            this.gd_btnCellUpdatedRegisters = new GridData(16384, 0x1000000, false, false, 1, 1);
            this.gd_btnCellUpdatedRegisters.horizontalIndent = 20;
            Button btnCellUpdatedRegistersLoc = this.btnCellUpdatedRegisters;
            if (btnCellUpdatedRegistersLoc != null) {
                btnCellUpdatedRegistersLoc.setLayoutData((Object)this.gd_btnCellUpdatedRegisters);
                btnCellUpdatedRegistersLoc.setText(Messages.UpdatedRegsLabel);
                btnCellUpdatedRegistersLoc.addSelectionListener((SelectionListener)new ReportOptionSelectionListener(this));
            }
            this.btnErrorCaptureRegisters = new Button((Composite)grpReportOptionsLoc, 32);
            this.gd_btnErrorCaptureRegisters = new GridData(16384, 0x1000000, false, false, 1, 1);
            this.gd_btnErrorCaptureRegisters.horizontalIndent = 20;
            Button btnErrorCaptureRegistersLoc = this.btnErrorCaptureRegisters;
            if (btnErrorCaptureRegistersLoc != null) {
                btnErrorCaptureRegistersLoc.setLayoutData((Object)this.gd_btnErrorCaptureRegisters);
                btnErrorCaptureRegistersLoc.setText(Messages.ErrCaptureRegsLabel);
                btnErrorCaptureRegistersLoc.addSelectionListener((SelectionListener)new ReportOptionSelectionListener(this));
            }
            grpReportOptionsLoc.setVisible(false);
            btnInitialDdrConfigurationLoc.setVisible(false);
            btnInitialDdrConfigurationLoc.setVisible(false);
            if (btnCellUpdatedRegistersLoc != null) {
                btnCellUpdatedRegistersLoc.setVisible(false);
            }
            if (btnErrorCaptureRegistersLoc != null) {
                btnErrorCaptureRegistersLoc.setVisible(false);
            }
            Composite bottomPart = new Composite((Composite)_shlDdrvReports, 0);
            bottomPart.setLayout((Layout)new GridLayout(1, false));
            bottomPart.setLayoutData((Object)new GridData(4, 1024, true, true, 1, 1));
            Label label = new Label(bottomPart, 258);
            label.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            Composite okCancelComposite = new Composite(bottomPart, 0);
            okCancelComposite.setLayout((Layout)new GridLayout(2, false));
            okCancelComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            _shlDdrvReports.layout(true);
            this.btnOk = new Button(okCancelComposite, 0);
            this.gd_btnOk = new GridData(4, 0x1000000, true, false, 1, 1);
            this.gd_btnOk.widthHint = 10;
            Button btnOkLoc = this.btnOk;
            if (btnOkLoc != null) {
                btnOkLoc.setLayoutData((Object)this.gd_btnOk);
                btnOkLoc.setText(Messages.OkBtn);
                btnOkLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (ReportsDialog.this.verifyWriteAccess()) {
                            VPresentationModel mainDataLoc;
                            IReportGenerator.ReportType selRepType = ReportsDialog.this.getSelectedReportType();
                            if (selRepType != null && ReportsDialog.this.data != null) {
                                ReportsDialog.this.data.setReportType(selRepType);
                            }
                            if ((mainDataLoc = ReportsDialog.this.mainData) != null) {
                                mainDataLoc.generateReport(mainDataLoc.getSelectedScenarioTerminatedTables(false));
                                if (ReportsDialog.this.textFile != null) {
                                    ReportsDialog.this.textFile.setText("");
                                }
                                if (ReportsDialog.this.shlDdrvReports != null) {
                                    ReportsDialog.this.shlDdrvReports.close();
                                }
                            }
                        }
                    }
                });
            }
            this.btnCancel = new Button(okCancelComposite, 0);
            this.gd_btnCancel = new GridData(4, 0x1000000, true, false, 1, 1);
            this.gd_btnCancel.widthHint = 10;
            Button btnCancelLoc = this.btnCancel;
            if (btnCancelLoc != null) {
                btnCancelLoc.setLayoutData((Object)this.gd_btnCancel);
                btnCancelLoc.setText(Messages.CancelBtn);
                btnCancelLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (ReportsDialog.this.shlDdrvReports != null) {
                            ReportsDialog.this.shlDdrvReports.close();
                        }
                    }
                });
            }
        }
        if (this.shlDdrvReports != null) {
            this.shlDdrvReports.pack();
        }
    }

    private void enableUi() {
        IReportGenerator.ReportData dataLoc;
        if (this.lblFile != null) {
            this.lblFile.setEnabled(true);
        }
        if (this.btnBrowse != null) {
            this.btnBrowse.setEnabled(true);
        }
        if (this.lblExportAs != null) {
            this.lblExportAs.setEnabled(true);
        }
        if (this.grpReportOptions != null) {
            this.grpReportOptions.setEnabled(true);
        }
        if (this.textFile != null) {
            this.textFile.setEnabled(true);
        }
        if (this.comboFileType != null) {
            this.comboFileType.setEnabled(false);
        }
        if (this.btnInitialDdrConfiguration != null) {
            this.btnInitialDdrConfiguration.setEnabled(true);
        }
        if (this.btnDetailedCellResults != null) {
            this.btnDetailedCellResults.setEnabled(true);
        }
        if ((dataLoc = this.data) != null) {
            if (this.btnCellUpdatedRegisters != null) {
                this.btnCellUpdatedRegisters.setEnabled(dataLoc.addDetailedCellResults);
            }
            if (this.btnErrorCaptureRegisters != null) {
                this.btnErrorCaptureRegisters.setEnabled(dataLoc.addDetailedCellResults);
            }
        }
    }

    public @Nullable IReportGenerator.ReportType getSelectedReportType() {
        Combo comboFileTypeLoc = this.comboFileType;
        if (comboFileTypeLoc != null && comboFileTypeLoc.getVisible()) {
            int index = comboFileTypeLoc.getSelectionIndex();
            return IReportGenerator.ReportType.values()[index];
        }
        return IReportGenerator.ReportType.JPG;
    }

    public void open() {
        this.createContents();
        this.populateUi();
        this.enableUi();
        this.verifyUserInput();
        Shell shlDdrvReportsLoc = this.shlDdrvReports;
        if (shlDdrvReportsLoc != null) {
            shlDdrvReportsLoc.open();
            shlDdrvReportsLoc.layout();
            Shell parent = this.getParent();
            if (parent != null) {
                Display display = parent.getDisplay();
                while (!shlDdrvReportsLoc.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        }
    }

    private void populateUi() {
        IReportGenerator.ReportData dataLoc = this.data;
        if (dataLoc != null) {
            if (this.textFile != null) {
                this.textFile.setText(dataLoc.getConcreteFilePath());
            }
            int reportTypeIdx = 0;
            IReportGenerator.ReportType[] reportTypeArray = IReportGenerator.ReportType.values();
            int n = reportTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IReportGenerator.ReportType type = reportTypeArray[n2];
                if (type == dataLoc.getReportType()) break;
                ++reportTypeIdx;
                ++n2;
            }
            if (this.comboFileType != null) {
                this.comboFileType.select(reportTypeIdx);
            }
            if (this.btnInitialDdrConfiguration != null) {
                this.btnInitialDdrConfiguration.setSelection(dataLoc.addInitConfigs);
            }
            if (this.btnDetailedCellResults != null) {
                this.btnDetailedCellResults.setSelection(dataLoc.addDetailedCellResults);
            }
            if (this.btnCellUpdatedRegisters != null) {
                this.btnCellUpdatedRegisters.setSelection(dataLoc.addUpdatedRegs);
            }
            if (this.btnErrorCaptureRegisters != null) {
                this.btnErrorCaptureRegisters.setSelection(dataLoc.addErrCaptRegs);
            }
        }
    }

    public void setFilePath(String filePath) {
        IReportGenerator.ReportData dataLoc = this.data;
        ControlDecoration textFileDecoratorLoc = this.textFileDecorator;
        if (dataLoc != null && textFileDecoratorLoc != null) {
            IReportGenerator.ReportType selectedReport = this.getSelectedReportType();
            if (selectedReport != null) {
                dataLoc.setReportType(selectedReport);
            }
            if (!filePath.endsWith(dataLoc.getReportType().defaultExt)) {
                dataLoc.setConcreteFilePath(String.valueOf(filePath.substring(0, filePath.lastIndexOf("."))) + dataLoc.getReportType().defaultExt);
            } else {
                dataLoc.setConcreteFilePath(filePath);
            }
            if (this.textFile != null) {
                this.textFile.setText(dataLoc.getConcreteFilePath());
            }
            if (ReportsDialog.isReportFilePathValid(filePath)) {
                textFileDecoratorLoc.hide();
            } else {
                textFileDecoratorLoc.setDescriptionText(Messages.InvalidFilePath);
                textFileDecoratorLoc.show();
                if (this.btnOk != null) {
                    this.btnOk.setEnabled(false);
                }
            }
        }
    }

    void updateReportOptions(Button b) {
        IReportGenerator.ReportData dataLoc = this.data;
        if (dataLoc != null) {
            if (b == this.btnInitialDdrConfiguration) {
                dataLoc.addInitConfigs = b.getSelection();
            }
            if (b == this.btnDetailedCellResults) {
                this.data.addDetailedCellResults = b.getSelection();
                if (this.btnCellUpdatedRegisters != null) {
                    this.btnCellUpdatedRegisters.setEnabled(dataLoc.addDetailedCellResults);
                }
                if (this.btnErrorCaptureRegisters != null) {
                    this.btnErrorCaptureRegisters.setEnabled(dataLoc.addDetailedCellResults);
                }
                if (!dataLoc.addDetailedCellResults) {
                    dataLoc.addUpdatedRegs = false;
                    dataLoc.addErrCaptRegs = false;
                }
            }
            if (b == this.btnErrorCaptureRegisters) {
                dataLoc.addErrCaptRegs = b.getSelection();
            }
            if (b == this.btnCellUpdatedRegisters) {
                dataLoc.addUpdatedRegs = b.getSelection();
            }
        }
    }

    public void updateReportType() {
        if (this.comboFileType != null) {
            int typeIdx = this.comboFileType.getSelectionIndex();
            IReportGenerator.ReportType newType = IReportGenerator.ReportType.values()[typeIdx];
            IReportGenerator.ReportData dataLoc = this.data;
            if (dataLoc != null && dataLoc.getReportType() != newType) {
                dataLoc.setReportType(newType);
                String filePath = dataLoc.getConcreteFilePath();
                if (filePath.contains(".")) {
                    dataLoc.setConcreteFilePath(String.valueOf(filePath.substring(0, filePath.lastIndexOf("."))) + newType.defaultExt);
                } else {
                    dataLoc.setConcreteFilePath(String.valueOf(filePath) + newType.defaultExt);
                }
                if (this.textFile != null) {
                    this.textFile.setText(dataLoc.getConcreteFilePath());
                }
            }
        }
    }

    public boolean verifyFilePath() {
        if (this.textFile != null) {
            ControlDecoration textFileDecoratorLoc;
            String filePath = this.textFile.getText();
            if (this.data != null) {
                this.data.setConcreteFilePath(filePath);
            }
            if ((textFileDecoratorLoc = this.textFileDecorator) != null) {
                if (ReportsDialog.isReportFilePathValid(filePath)) {
                    this.updateReportType();
                    textFileDecoratorLoc.hide();
                    return true;
                }
                textFileDecoratorLoc.setDescriptionText(Messages.InvalidFilePath);
                textFileDecoratorLoc.show();
                return false;
            }
        }
        return false;
    }

    public void verifyUserInput() {
        boolean pathOk = this.verifyFilePath();
        if (this.btnOk != null) {
            this.btnOk.setEnabled(pathOk);
        }
    }

    public boolean verifyWriteAccess() {
        if (this.textFile != null) {
            ControlDecoration textFileDecoratorLoc;
            String filePath = this.textFile.getText();
            if (this.data != null) {
                this.data.setConcreteFilePath(filePath);
            }
            if (filePath.isEmpty()) {
                return false;
            }
            if (ReportsDialog.canWriteReportFileToDisk(filePath)) {
                return true;
            }
            if (this.btnOk != null) {
                this.btnOk.setEnabled(false);
            }
            if ((textFileDecoratorLoc = this.textFileDecorator) != null) {
                textFileDecoratorLoc.setDescriptionText(String.valueOf(Messages.PermissionDenied) + System.getProperty("user.name"));
                textFileDecoratorLoc.show();
            }
            return false;
        }
        return false;
    }

    protected static class BrowseReportSelectionListener
    extends SelectionAdapter {
        private ReportsDialog parentDialog;

        public BrowseReportSelectionListener(ReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public static MessageBox overwriteDialog(String fileName, Shell shell) {
            MessageBox overwriteDialog = new MessageBox(shell, 200);
            String overwriteMessage = MessageFormat.format(Messages.Overwrite_Message, fileName);
            overwriteDialog.setMessage(overwriteMessage);
            overwriteDialog.setText(Messages.Confirm_SaveAs);
            return overwriteDialog;
        }

        public static boolean shouldOverwriteFile(Shell shell, File selectedFile) {
            MessageBox overwriteDialog = BrowseReportSelectionListener.overwriteDialog(selectedFile.getName(), shell);
            int buttonOption = overwriteDialog.open();
            return buttonOption == 64;
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(this.parentDialog.getParent(), 8192);
            dialog.setOverwrite(true);
            IReportGenerator.ReportType repType = this.parentDialog.getSelectedReportType();
            if (repType != null) {
                dialog.setFilterNames(new String[]{repType.filterName});
                dialog.setFilterExtensions(new String[]{repType.filterExt});
                IConfigProvider configController = ValidationContext.getInstance().getConfigController();
                if (configController != null) {
                    dialog.setText(configController.getReportFileDialogTitle());
                    dialog.setFileName(String.valueOf(configController.getFileReportName()) + repType.defaultExt);
                } else {
                    dialog.setFileName(String.valueOf(Messages.DefaultReportName) + repType.defaultExt);
                    dialog.setText(Messages.SelectFileDialogTitle);
                }
                String filePath = dialog.open();
                if (filePath != null) {
                    if (!filePath.endsWith(repType.defaultExt)) {
                        filePath = String.valueOf(filePath) + repType.defaultExt;
                        File selectedFile = new File(filePath);
                        Shell shell = this.parentDialog.getParent();
                        if (shell != null && selectedFile.exists() && !BrowseReportSelectionListener.shouldOverwriteFile(shell, selectedFile)) {
                            filePath = "";
                        }
                    }
                    this.parentDialog.setFilePath(filePath);
                }
                this.parentDialog.verifyUserInput();
            }
        }
    }

    protected static class FilePathListener
    implements ModifyListener {
        private ReportsDialog parentDialog;

        public FilePathListener(ReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void modifyText(@NonNull ModifyEvent e) {
            this.parentDialog.verifyUserInput();
        }
    }

    protected static class ReportOptionSelectionListener
    extends SelectionAdapter {
        private ReportsDialog parentDialog;

        public ReportOptionSelectionListener(ReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void widgetSelected(SelectionEvent e) {
            Button b;
            if (e != null && (b = (Button)e.widget) != null) {
                this.parentDialog.updateReportOptions(b);
            }
        }
    }

    protected static class ReportPathFocusListener
    extends FocusAdapter {
        private ReportsDialog parentDialog;

        public ReportPathFocusListener(ReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void focusLost(FocusEvent e) {
            this.parentDialog.verifyUserInput();
        }
    }

    protected static class ReportTypeSelectionListener
    extends SelectionAdapter {
        private ReportsDialog parentDialog;

        public ReportTypeSelectionListener(ReportsDialog _parentDialog) {
            this.parentDialog = _parentDialog;
        }

        public void widgetSelected(SelectionEvent e) {
            this.parentDialog.verifyUserInput();
        }
    }
}

