/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.utils;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.mem.validation.connections.ui.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ConnectionUtils {
    protected static final Logger LOGGER = LogManager.getLogger(ConnectionUtils.class);
    private static final String WINDOWS_COMMAND = "REG QUERY \"HKEY_LOCAL_MACHINE\\HARDWARE\\DEVICEMAP\\SERIALCOMM\\";
    private static final String REQUEST_TO_WINDOWS_REGISTRY_USBCCGP_SERVICE = "REG QUERY \"HKLM\\SYSTEM\\CurrentControlSet\\services\\usbccgp\\Enum\\";
    private static final String PATH_TO_GDB_SERVER_EXECUTABLE = "${S32DS_GDB_SERVER_EXECUTABLE_PATH}";
    private static final String DEBUG_PROBE_PARAMETER_PREFIX = "-t";
    private static final String S32DBG = "s32dbg:";
    protected static final String SH_RUNNER_REQUEST = "/bin/sh";
    protected static final String STRING_COMMAND = "-c";
    protected static final String SERIAL_PREFIX = "/dev/";
    private static final String LINUX_COMMAND = "ls -lA /dev/serial/by-id";
    private static final String USB_DEVICES_REQUEST = "usb-devices";
    private static final String USB_DEVICE_SERIAL_NUMBER = "SerialNumber=";
    private static final String VID_PID = "VID_%s&PID_%s";
    private static final String VID_USB_ETH = "15A2";
    private static final String PID_USB_ETH = "0067";
    private static final String SOC_CONNECTED = "SoC Request: Success";
    private static final String REG_SZ = "REG_SZ";
    private static final String USB_FTDI = "usb-FTDI";

    public static final List<String> runProcessForOutput(String toExecute) {
        Process process = null;
        try {
            List<String> list;
            block18: {
                String[] linuxExecute22;
                if (OSDetect.isWindows()) {
                    process = Runtime.getRuntime().exec(toExecute);
                } else {
                    linuxExecute22 = new String[]{SH_RUNNER_REQUEST, STRING_COMMAND, toExecute};
                    process = Runtime.getRuntime().exec(linuxExecute22);
                }
                linuxExecute22 = null;
                Object var3_5 = null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
                try {
                    list = reader.lines().collect(Collectors.toList());
                    if (reader == null) break block18;
                }
                catch (Throwable linuxExecute22) {
                    try {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            throw linuxExecute22;
                        }
                        catch (Throwable throwable) {
                            if (linuxExecute22 == null) {
                                linuxExecute22 = throwable;
                            } else if (linuxExecute22 != throwable) {
                                linuxExecute22.addSuppressed(throwable);
                            }
                            throw linuxExecute22;
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.severe(ex.getMessage());
                        List<String> list2 = Collections.emptyList();
                        return list2;
                    }
                }
                reader.close();
            }
            return list;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static String[] getAvailableProbe() {
        String[] probeAddress = new String[]{Messages.SerialNrPlaceholder};
        String deviceVidPidEth = String.format(VID_PID, VID_USB_ETH, PID_USB_ETH);
        ArrayList<String> probeIDList = new ArrayList<String>();
        if (OSDetect.isWindows()) {
            List<String> result = ConnectionUtils.runProcessForOutput(REQUEST_TO_WINDOWS_REGISTRY_USBCCGP_SERVICE);
            for (String line : result) {
                if (!line.contains(deviceVidPidEth)) continue;
                String deviceId = line.substring(line.indexOf(deviceVidPidEth) + deviceVidPidEth.length() + 1);
                probeIDList.add(deviceId);
            }
        } else {
            boolean deviceFound = false;
            List<String> result = ConnectionUtils.runProcessForOutput(USB_DEVICES_REQUEST);
            for (String line : result) {
                if (line.contains(VID_USB_ETH.toLowerCase()) && line.contains(PID_USB_ETH.toLowerCase())) {
                    deviceFound = true;
                    continue;
                }
                if (!deviceFound || !line.contains(USB_DEVICE_SERIAL_NUMBER)) continue;
                int index = line.indexOf(USB_DEVICE_SERIAL_NUMBER);
                String deviceId = line.substring(index + USB_DEVICE_SERIAL_NUMBER.length());
                probeIDList.add(deviceId);
                deviceFound = false;
            }
        }
        return probeIDList.size() > 0 ? probeIDList.toArray(new String[0]) : probeAddress;
    }

    public static String[] getCOMPorts() {
        String[] comPorts = new String[]{Messages.UNDEFINED_PORT_NAME};
        ArrayList<String> serialPortsList = new ArrayList<String>();
        if (OSDetect.isWindows()) {
            List<String> result = ConnectionUtils.runProcessForOutput(WINDOWS_COMMAND);
            for (String line : result) {
                if (!line.contains(REG_SZ)) continue;
                String comport = line.substring(line.lastIndexOf(" ") + 1);
                serialPortsList.add(comport);
            }
        } else {
            List<String> result = ConnectionUtils.runProcessForOutput(LINUX_COMMAND);
            for (String line : result) {
                if (!line.contains(USB_FTDI)) continue;
                String comport = SERIAL_PREFIX + line.substring(line.lastIndexOf("/") + 1);
                serialPortsList.add(comport);
            }
        }
        return serialPortsList.size() > 0 ? ConnectionUtils.sortList(serialPortsList).toArray(new String[0]) : comPorts;
    }

    public static List<String> sortList(List<String> list) {
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return this.extractInt(s1) - this.extractInt(s2);
            }

            int extractInt(String s) {
                String num = s.replaceAll("\\D", "");
                return num.isEmpty() ? 0 : Integer.parseInt(num);
            }
        });
        return list;
    }

    public static void testConnection(String deviceAddress) {
        String message = Messages.ProbeDisconnected;
        try {
            String gdbPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(PATH_TO_GDB_SERVER_EXECUTABLE);
            if (gdbPath != null) {
                String[] command = new String[]{gdbPath, DEBUG_PROBE_PARAMETER_PREFIX, S32DBG + deviceAddress};
                try {
                    Process process = Runtime.getRuntime().exec(command);
                    try {
                        Throwable throwable = null;
                        Object var6_10 = null;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                            for (String line : reader.lines().collect(Collectors.toList())) {
                                if (!line.equals(SOC_CONNECTED)) continue;
                                message = Messages.ProbeConnected;
                                break;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.severe(e.getMessage());
                    }
                }
                catch (IOException e) {
                    LOGGER.severe(e.getMessage());
                }
            }
            Display display = Display.getDefault();
            Shell currentShell = display.getActiveShell();
            MessageDialog.openInformation((Shell)currentShell, (String)Messages.ConnectionTest, (String)message);
        }
        catch (CoreException e) {
            LOGGER.severe(e.getMessage());
        }
    }
}

