/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.utils;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LoggingUtils {
    public static final String ERROR_REGEX = "([Ee][Rr][Rr][Oo][Rr])|([Ee][Xx][Cc][Ee][Pp][Tt][Ii][Oo][Nn])|([Ff][Aa][iI][Ll])|([Rr][Ee][Aa][Dd][Yy])";
    public static final String WARNING_PHYINIT_REGEX = "(\\[[Ww][Aa][Rr][Nn][Ii][Nn][Gg]\\])";
    public static final String ERROR_PHYINIT_REGEX = "(\\[[Ee][Rr][Rr][Oo][Rr]\\])";
    public static final String ERROR_MSG_REGEX = "(([Ee][Rr][Rr][Oo][Rr])|([Ee][Xx][Cc][Ee][Pp][Tt][Ii][Oo][Nn])|([Ff][Aa][iI][Ll])|([Rr][Ee][Aa][Dd][Yy]))\\s*:\\s*.*";
    public static final String PHY_ERROR_REGEX = "(DDR PHY:)(.*)(training failed)";
    public static final String PY_TRACEBACK_REGEX = "(^\\s*Traceback \\(most recent call last\\):\\s*(.*)(Error|Exception))|Traceback";
    public static final String CMD_ERROR_REGEX = "'quit' is not recognized as an internal or external command";
    public static final String FAIL_REASON_REGEX = "([Ff][Aa][Ii][Ll][\\s][Rr][Ee][Aa][Ss][Oo][Nn][:][\\s])";
    public static final String CCS_EXCEPTION_START = "(";
    public static final String CCS_EXCEPTION_END = ")";
    public static final String ERR_PREFIX = "<<";
    public static final String ERR_POSTFIX = ">>";
    public static final String ERR_DETAILS_PREFIX = "{{";
    public static final String ERR_DETAILS_POSTFIX = "}}";
    public static final Pattern errorPattern = Pattern.compile("([Ee][Rr][Rr][Oo][Rr])|([Ee][Xx][Cc][Ee][Pp][Tt][Ii][Oo][Nn])|([Ff][Aa][iI][Ll])|([Rr][Ee][Aa][Dd][Yy])");
    public static final Pattern errorMsgPattern = Pattern.compile("(([Ee][Rr][Rr][Oo][Rr])|([Ee][Xx][Cc][Ee][Pp][Tt][Ii][Oo][Nn])|([Ff][Aa][iI][Ll])|([Rr][Ee][Aa][Dd][Yy]))\\s*:\\s*.*");
    public static final Pattern phyFailurePattern = Pattern.compile("(DDR PHY:)(.*)(training failed)");
    public static final Pattern failReasonPattern = Pattern.compile("([Ff][Aa][Ii][Ll][\\s][Rr][Ee][Aa][Ss][Oo][Nn][:][\\s])");
    public static final Pattern pyTracePattern = Pattern.compile("(^\\s*Traceback \\(most recent call last\\):\\s*(.*)(Error|Exception))|Traceback", 32);
    public static final Pattern cmdErrorPattern = Pattern.compile("'quit' is not recognized as an internal or external command");
    public static final Pattern phyinitWarningPattern = Pattern.compile("(\\[[Ww][Aa][Rr][Nn][Ii][Nn][Gg]\\])");
    public static final Pattern phyinitErrorPattern = Pattern.compile("(\\[[Ee][Rr][Rr][Oo][Rr]\\])");

    public static @Nullable String extractErrorMessage(String logResults) {
        if (logResults.isEmpty()) {
            return null;
        }
        if (logResults.contains(ERR_DETAILS_PREFIX) && logResults.contains(ERR_DETAILS_POSTFIX)) {
            int startIdx = logResults.indexOf(ERR_DETAILS_PREFIX) + ERR_DETAILS_PREFIX.length();
            int endIdx = logResults.indexOf(ERR_DETAILS_POSTFIX);
            return logResults.substring(startIdx, endIdx);
        }
        if (logResults.contains(Messages.TargetDisconnected)) {
            return Messages.TargetDisconnected;
        }
        if (logResults.contains(Messages.TargetNotReady)) {
            return logResults;
        }
        if (logResults.contains(Messages.TargetConnected)) {
            return null;
        }
        Matcher m = errorMsgPattern.matcher(logResults);
        if (m.find()) {
            logResults = m.group();
        }
        int indexStart = logResults.lastIndexOf(ERR_PREFIX);
        int indexEnd = logResults.lastIndexOf(ERR_POSTFIX);
        int prefixLen = ERR_PREFIX.length();
        if (indexStart == -1 || indexEnd == -1) {
            indexStart = logResults.lastIndexOf(CCS_EXCEPTION_START);
            indexEnd = logResults.lastIndexOf(CCS_EXCEPTION_END);
            prefixLen = CCS_EXCEPTION_START.length();
        }
        if (indexStart <= indexEnd && indexStart != -1 && indexEnd != -1) {
            return logResults.substring(indexStart + prefixLen, indexEnd);
        }
        return logResults;
    }

    public static boolean isErrorMessage(@Nullable String logResults) {
        if (logResults == null || logResults.isEmpty()) {
            return true;
        }
        Matcher matcher = errorPattern.matcher(logResults);
        return matcher.find();
    }

    public static boolean isPyException(String result) {
        Matcher matcher = pyTracePattern.matcher(result);
        return matcher.find();
    }

    public static boolean isPhyinitWarning(String logResult) {
        Matcher matcherWarning = phyinitWarningPattern.matcher(logResult);
        return matcherWarning.find();
    }

    public static boolean isPhyinitError(String logResult) {
        Matcher matcherWarning = phyinitErrorPattern.matcher(logResult);
        return matcherWarning.find();
    }
}

