/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.utils;

import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final byte FIRST_PRINTABLE_ASCII = 32;
    public static final byte LAST_PRINTABLE_ASCII = 126;
    public static final String EOL = System.lineSeparator();
    public static final String NEW_LINE_REGEX = "\\r?\\n";
    private static final char ZERO_CHAR = '0';
    public static final String HEX_PREFIX = "0x";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("[\\n|\\r]");

    private StringUtils() {
    }

    public static boolean compareStrings(String[] expected, String[] actual, StringMatchStyle matchStyle) {
        if (expected.length != actual.length) {
            return false;
        }
        LinkedList<String> _expected = new LinkedList<String>(Arrays.asList(expected));
        String[] stringArray = actual;
        int n = actual.length;
        int n2 = 0;
        while (n2 < n) {
            String act = stringArray[n2];
            Iterator iter = _expected.iterator();
            boolean found = false;
            while (iter.hasNext()) {
                @Nullable String exp = (String)iter.next();
                switch (matchStyle) {
                    case STARTS_WITH: {
                        found = act.startsWith(exp);
                        break;
                    }
                    case ENDS_WITH: {
                        found = act.endsWith(exp);
                        break;
                    }
                    case CONTAINS: {
                        found = act.contains(exp);
                        break;
                    }
                    case EQUALS: {
                        found = act.equals(exp);
                    }
                }
                if (!found) continue;
                iter.remove();
                break;
            }
            if (!found) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean containsAll(String[] expected, String[] actual, StringMatchStyle matchStyle) {
        String[] stringArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            String strExpected = stringArray[n2];
            boolean found = false;
            String[] stringArray2 = actual;
            int n3 = actual.length;
            int n4 = 0;
            while (n4 < n3) {
                String strActual = stringArray2[n4];
                switch (matchStyle) {
                    case STARTS_WITH: {
                        found = strActual.startsWith(strExpected);
                        break;
                    }
                    case ENDS_WITH: {
                        found = strActual.endsWith(strExpected);
                        break;
                    }
                    case CONTAINS: {
                        found = strActual.contains(strExpected);
                        break;
                    }
                    case EQUALS: {
                        found = strActual.equals(strExpected);
                        break;
                    }
                    default: {
                        assert (false) : "Not supported match style: " + matchStyle.toString();
                        break;
                    }
                }
                if (found) break;
                ++n4;
            }
            if (!found) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean containsAny(String[] substrs, String[] strs) {
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            String[] stringArray2 = substrs;
            int n3 = substrs.length;
            int n4 = 0;
            while (n4 < n3) {
                String substr = stringArray2[n4];
                if (str.contains(substr)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static String capString(String str, int capLen) {
        if (str.length() <= capLen) {
            return str;
        }
        if (capLen < 3) {
            throw new IllegalArgumentException("Invalid cap value. Must be >= 3");
        }
        return String.valueOf(str.substring(0, capLen - 3)) + "...";
    }

    public static boolean hasWhiteSpace(String str) {
        return WHITESPACE_PATTERN.matcher(str).find();
    }

    public static boolean hasNewline(String str) {
        return NEWLINE_PATTERN.matcher(str).find();
    }

    public static String[] toLines(String str, boolean trim, boolean skipEmpty) {
        String[] lines = str.split(NEW_LINE_REGEX);
        if (!trim && !skipEmpty) {
            return lines;
        }
        ArrayList<String> linesTrimmed = new ArrayList<String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (trim) {
                line = line.trim();
            }
            if (!(skipEmpty && line.isEmpty() || line == null)) {
                linesTrimmed.add(line);
            }
            ++n2;
        }
        return linesTrimmed.toArray(new String[linesTrimmed.size()]);
    }

    public static String removeEOL(String text) {
        return text.replaceAll(System.lineSeparator(), "");
    }

    public static String parseAsNumber(String hexValue) {
        return hexValue.startsWith(HEX_PREFIX) ? hexValue.substring(2) : hexValue;
    }

    public static String toPrettyHex(long value, int numDigits) {
        String hexStr = Long.toHexString(value).toUpperCase();
        int prefixLen = numDigits - hexStr.length();
        char[] prefixBytes = new char[]{};
        if (prefixLen > 0) {
            prefixBytes = new char[prefixLen];
            Arrays.fill(prefixBytes, '0');
        }
        return HEX_PREFIX + new String(prefixBytes) + hexStr;
    }

    public static String asRepeatedChar(char ch, int len) {
        assert (len >= 0) : "The number of repetitions should be greater than 0!";
        if (len == 0) {
            return "";
        }
        char[] chars = new char[len];
        Arrays.fill(chars, ch);
        return new String(chars);
    }

    public static enum StringMatchStyle {
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        EQUALS;

    }
}

