/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;

public class AttributeReadingUtils {
    private static final String handlerId = "com.nxp.s32ds.debug.ide.ui.handlers.attributeReadingFailureStatusHandler";

    public static <T> T readAttribute(List<IStatus> errors, String attributeName, T defaultValue, ILaunchConfiguration lc) {
        if (errors == null) {
            throw new IllegalArgumentException("List with errors cannot be null.");
        }
        if (defaultValue instanceof String) {
            try {
                return (T)lc.getAttribute(attributeName, (String)defaultValue);
            }
            catch (CoreException e) {
                errors.add(e.getStatus());
                return defaultValue;
            }
        }
        if (defaultValue instanceof Integer) {
            try {
                return (T)Integer.valueOf(lc.getAttribute(attributeName, ((Integer)defaultValue).intValue()));
            }
            catch (CoreException e) {
                errors.add(e.getStatus());
                return defaultValue;
            }
        }
        if (defaultValue instanceof Boolean) {
            try {
                return (T)Boolean.valueOf(lc.getAttribute(attributeName, ((Boolean)defaultValue).booleanValue()));
            }
            catch (CoreException e) {
                errors.add(e.getStatus());
                return defaultValue;
            }
        }
        if (defaultValue instanceof List) {
            try {
                return (T)new ArrayList(lc.getAttribute(attributeName, (List)defaultValue));
            }
            catch (CoreException e) {
                errors.add(e.getStatus());
                return defaultValue;
            }
        }
        if (defaultValue instanceof Map) {
            try {
                return (T)new HashMap(lc.getAttribute(attributeName, (Map)defaultValue));
            }
            catch (CoreException e) {
                errors.add(e.getStatus());
                return defaultValue;
            }
        }
        errors.add((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.core", "Unsupported default value type."));
        return defaultValue;
    }

    public static void handleAttributeReadingFailure(IStatus status) {
        DebuggerCoreActivator.getInstance().log(status);
        try {
            RcpStatusHandlers.handleStatus((String)handlerId, (IStatus)status, null);
        }
        catch (CoreException ce) {
            DebuggerCoreActivator.getInstance().log(ce.getStatus());
        }
    }
}

