/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunchStateListener;
import com.nxp.s32ds.debug.ide.core.S32DebuggerConstants;
import com.nxp.s32ds.debug.ide.internal.core.ErrorMessages;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.osgi.util.NLS;

public class S32DSGdbLaunch
extends GdbLaunch
implements Comparable<S32DSGdbLaunch> {
    private static final String HANDLER_ID_PYTHON_SCRIPT_ERRORS = "com.nxp.s32ds.debug.ide.ui.handlers.pythonScriptFailureHandler";
    private static final String HANDLER_ID_SERVER_TERMINATION = "com.nxp.s32ds.debug.ide.s32debugger.ui.serverTerminationStatusHandler";
    private static final String PYTHON_PATH = "PYTHONPATH";
    private static final String S32DS_PYTHON_PATH = "${S32DS_PYTHONPATH}";
    private static final String GDB_VERSION_ARGUMENT = " --version";
    private static List<S32DSGdbLaunch> allLaunches = new ArrayList<S32DSGdbLaunch>();
    private boolean isInRunningState;
    private boolean isSuspended;
    private IProcess gdbClientProcess;
    private String gdbVersion;
    private String[] environment;

    public S32DSGdbLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        allLaunches.add(this);
        this.isInRunningState = false;
        this.gdbClientProcess = null;
        this.gdbVersion = null;
        this.environment = null;
        this.isSuspended = false;
    }

    public String getGDBVersion() throws CoreException {
        if (this.gdbVersion != null) {
            return this.gdbVersion;
        }
        IPath gdbPath = this.getGDBPath();
        Objects.requireNonNull(gdbPath, "GDB client path");
        this.gdbVersion = this.getGDBVersion(gdbPath.toOSString());
        return this.gdbVersion;
    }

    public String[] getLaunchEnvironment() throws CoreException {
        if (this.environment != null) {
            return this.environment;
        }
        String[] launchEnvironment = super.getLaunchEnvironment();
        ArrayList<String> environmentList = new ArrayList<String>();
        if (launchEnvironment.length == 0) {
            Map<String, String> environment = System.getenv();
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                this.addEnvironmentVariable(environmentList, entry.getKey(), entry.getValue());
            }
        } else {
            String[] stringArray = launchEnvironment;
            int n = launchEnvironment.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                environmentList.add(value);
                ++n2;
            }
        }
        if ("win32".equals(Platform.getOS())) {
            this.addEnvironmentVariable(environmentList, PYTHON_PATH, S32DS_PYTHON_PATH);
        }
        this.environment = environmentList.toArray(new String[environmentList.size()]);
        return this.environment;
    }

    public void shutdownSession(RequestMonitor rm) {
        if (!S32DSGdbLaunch.isShutdowned((ILaunch)this)) {
            allLaunches.remove(this);
            super.shutdownSession(rm);
            try {
                RcpStatusHandlers.getStatusHandlerService().getStatusHandler(HANDLER_ID_SERVER_TERMINATION).handleStatus(null, (Object)this);
            }
            catch (CoreException ex) {
                DebuggerCoreActivator.getInstance().logError("Cannot get status handler" + ex.getStatus());
            }
            S32DSGdbLaunchStateListener.forceRemovefromSuspendedList(this);
        } else {
            rm.done();
        }
    }

    public static boolean isShutdowned(ILaunch launch) {
        return launch instanceof S32DSGdbLaunch ? !allLaunches.contains(launch) : launch.isTerminated();
    }

    private void addEnvironmentVariable(List<String> environment, String variableName, String variableValue) {
        StringBuilder builder = new StringBuilder();
        builder.append(variableName);
        builder.append("=");
        builder.append(DebuggerUtils.substitute(variableValue));
        boolean isVariableFound = false;
        int i = 0;
        while (i < environment.size()) {
            if (environment.get(i).startsWith(variableName)) {
                environment.set(i, builder.toString());
                isVariableFound = true;
                break;
            }
            ++i;
        }
        if (!isVariableFound) {
            environment.add(builder.toString());
        }
    }

    public void setInRunningState() {
        this.isInRunningState = true;
    }

    public boolean isInRunningState() {
        return this.isInRunningState;
    }

    public void addCLIProcess(String label) throws CoreException {
        super.addCLIProcess(label);
        Optional<IProcess> clientProc = Arrays.stream(super.getProcesses()).filter(process -> label.equals(process.getLabel())).findFirst();
        if (clientProc.isPresent()) {
            this.gdbClientProcess = clientProc.get();
        }
        DebugPlugin.getDefault().addDebugEventListener(events -> {
            boolean clientTerminated = Arrays.stream(events).filter(event -> event.getSource() == this.gdbClientProcess).anyMatch(event -> 8 == event.getKind());
            if (clientTerminated) {
                try {
                    int exitCode = this.gdbClientProcess.getExitValue();
                    if (exitCode != 0) {
                        try {
                            RcpStatusHandlers.handleStatus((String)HANDLER_ID_PYTHON_SCRIPT_ERRORS, (IStatus)new Status(4, DebuggerCoreActivator.getInstance().getBundleId(), String.valueOf(exitCode)), (Object)this);
                        }
                        catch (CoreException coreException) {
                            DebuggerCoreActivator.getInstance().logError(ErrorMessages.GDBStatus_no_status_processor_service);
                        }
                    }
                }
                catch (DebugException debugException) {
                    DebuggerCoreActivator.getInstance().logError(ErrorMessages.GDBCLIProcess_cannot_get_exit_code);
                }
            }
        });
    }

    private String getGDBVersion(String gdbPath) throws CoreException {
        String[] environment = this.getLaunchEnvironment();
        String command = String.valueOf(gdbPath) + GDB_VERSION_ARGUMENT;
        String[] args = CommandLineUtil.argumentsToArray((String)command);
        Process process = null;
        Job timeoutJob = null;
        try {
            long startTime = System.currentTimeMillis();
            Process gdbProc = process = ProcessFactory.getFactory().exec(args, environment);
            timeoutJob = Job.createSystem((String)"GDB version timeout job", monitor -> {
                gdbProc.destroy();
                return Status.OK_STATUS;
            });
            IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode(S32DebuggerConstants.PREF_NODE_ID);
            int gdbLifetime = node.getInt("com.nxp.s32ds.debug.ide.core.preferences.gdb.lifetime", 15);
            timeoutJob.schedule((long)(gdbLifetime * 1000));
            String streamOutput = S32DSGdbLaunch.readStream(process.getInputStream());
            String gdbVersion = LaunchUtils.getGDBVersionFromText((String)streamOutput);
            if (gdbVersion == null || gdbVersion.isEmpty()) {
                Exception detailedException = null;
                if (!streamOutput.isEmpty()) {
                    detailedException = new Exception(NLS.bind((String)ErrorMessages.S32DSGDBLaunch_unexpected_gdb_version_answer, (Object)streamOutput));
                } else {
                    streamOutput = S32DSGdbLaunch.readStream(process.getErrorStream());
                    if (!streamOutput.isEmpty()) {
                        detailedException = new Exception(streamOutput);
                    }
                }
                throw new DebugException(DebuggerCoreActivator.getInstance().createStatus(4, NLS.bind((String)ErrorMessages.S32DSGDBLaunch_could_not_determine_gdb_version, (Object)StringUtil.join((String[])args, (String)" "), (Object)(System.currentTimeMillis() - startTime)), detailedException));
            }
            String string = gdbVersion;
            return string;
        }
        catch (IOException e) {
            throw new DebugException(DebuggerCoreActivator.getInstance().createStatus(4, NLS.bind((String)ErrorMessages.S32DSGDBLaunch_error_with_process, (Object)StringUtil.join((String[])args, (String)" ")), e));
        }
        finally {
            if (timeoutJob != null) {
                timeoutJob.cancel();
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    /*
     * Loose catch block
     */
    private static String readStream(InputStream stream) throws IOException {
        StringBuilder cmdOutput = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            String string;
            BufferedReader reader;
            InputStreamReader r;
            block17: {
                block16: {
                    String line;
                    r = new InputStreamReader(stream);
                    reader = new BufferedReader(r);
                    while ((line = reader.readLine()) != null) {
                        cmdOutput.append(line);
                        cmdOutput.append('\n');
                    }
                    string = cmdOutput.toString();
                    if (reader == null) break block16;
                    reader.close();
                }
                if (r == null) break block17;
                ((Reader)r).close();
            }
            return string;
            {
                catch (Throwable throwable2) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected void setSuspended(boolean suspended) {
        this.isSuspended = suspended;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    public int compareTo(S32DSGdbLaunch launch) {
        return this.equals(launch) ? 0 : 1;
    }
}

