/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunchStateListener;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;

public class S32DSGdbServerProcess
extends Spawner {
    private static final String HANDLER_ID_SERVER_TERMINATION = "com.nxp.s32ds.debug.ide.s32debugger.ui.serverTerminationStatusHandler";
    private final List<S32DSGdbLaunch> currentLaunches = new ArrayList<S32DSGdbLaunch>();
    private boolean serverTerminated = false;
    private BufferedInputStream bufferedInputStream = new BufferedInputStream(super.getInputStream());
    private static S32DSGdbServerProcess instance;
    private S32DSGdbLaunch initialLaunch;
    private int exitCode;

    private void stopCurrentLaunches() {
        this.initialLaunch = null;
        if (!DebuggerCoreActivator.debuggerStopped()) {
            for (final S32DSGdbLaunch launch : this.currentLaunches) {
                Query<Object> launchShutdownQuery = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        launch.shutdownSession((RequestMonitor)rm);
                    }
                };
                if (S32DSGdbLaunch.isShutdowned((ILaunch)launch)) continue;
                try {
                    launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    break;
                }
                try {
                    launchShutdownQuery.get(5L, TimeUnit.SECONDS);
                }
                catch (ExecutionException executionException) {
                    DebuggerCoreActivator.getInstance().logWarning(NLS.bind((String)"Launch termination ''{0}'' was not completed correctly", (Object)launch.getLaunchConfiguration().getName()));
                }
                catch (InterruptedException | TimeoutException exception) {}
            }
        }
        this.currentLaunches.clear();
    }

    public static S32DSGdbServerProcess getInstance(String[] cmdarray, String[] envp, File dir) {
        if (instance == null) {
            try {
                instance = new S32DSGdbServerProcess(cmdarray, envp, dir);
                S32DSGdbLaunchStateListener.getInstance();
            }
            catch (IOException iOException) {
                instance = null;
            }
        }
        return instance;
    }

    protected S32DSGdbServerProcess(String[] cmdarray, String[] envp, File dir) throws IOException {
        super(cmdarray, envp, dir);
        this.bufferedInputStream.mark(-1);
    }

    public InputStream getInputStream() {
        try {
            this.bufferedInputStream.reset();
        }
        catch (IOException iOException) {}
        return this.bufferedInputStream;
    }

    public InputStream getInputStreamEx() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return this.read(new byte[1]);
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return S32DSGdbServerProcess.this.bufferedInputStream.read(b, off, len);
            }
        };
    }

    public static void shutdownOnError() {
        if (instance != null && !instance.isServerTerminated()) {
            instance.terminate();
        }
    }

    public static boolean isOnShutdown() {
        return instance == null || instance.isServerTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int terminate() {
        S32DSGdbServerProcess s32DSGdbServerProcess = this;
        synchronized (s32DSGdbServerProcess) {
            if (this.serverTerminated) {
                return this.exitCode;
            }
            this.serverTerminated = true;
            instance = null;
        }
        this.stopCurrentLaunches();
        try {
            this.bufferedInputStream.close();
        }
        catch (IOException ex) {
            DebuggerCoreActivator.getInstance().logError(ex.getMessage());
        }
        try {
            RcpStatusHandlers.getStatusHandlerService().getStatusHandler(HANDLER_ID_SERVER_TERMINATION).handleStatus(null, (Object)this);
        }
        catch (CoreException ex) {
            DebuggerCoreActivator.getInstance().logError("Cannot get status handler" + ex.getStatus());
        }
        this.exitCode = super.terminate();
        return this.exitCode;
    }

    public static void addLaunch(S32DSGdbLaunch launch) {
        if (instance != null && !instance.isServerTerminated()) {
            if (S32DSGdbServerProcess.instance.initialLaunch == null) {
                S32DSGdbServerProcess.instance.initialLaunch = launch;
            }
            S32DSGdbServerProcess.instance.currentLaunches.add(launch);
        }
    }

    public static void removeLaunch(S32DSGdbLaunch launch) {
        if (instance != null && !instance.isServerTerminated()) {
            if (launch == S32DSGdbServerProcess.instance.initialLaunch) {
                S32DSGdbServerProcess.instance.initialLaunch = null;
            }
            S32DSGdbServerProcess.instance.currentLaunches.remove(launch);
        }
    }

    public synchronized boolean isServerTerminated() {
        return this.serverTerminated;
    }

    public static boolean hasInitialLaunch() {
        return instance != null && S32DSGdbServerProcess.instance.initialLaunch != null;
    }

    public static boolean hasLaunches() {
        return instance != null ? !S32DSGdbServerProcess.instance.currentLaunches.isEmpty() : false;
    }

    public static boolean isLaunchInitial(S32DSGdbLaunch launch) {
        return instance != null ? launch == S32DSGdbServerProcess.instance.initialLaunch : false;
    }

    public static boolean isServerRunning() {
        return instance != null;
    }
}

