/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.variables.preferences.internal.ui;

import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSValueVariable;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariablesLabelProviders;
import com.nxp.s32ds.cle.ide.variables.preferences.internal.ui.S32DSVariablesUiPreferencesActivator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class S32DSVariableEditDialog
extends Dialog {
    private final S32DSValueVariable variable;
    private final String defaultValue;
    private Text valueText;
    private Button resetButton;

    public S32DSVariableEditDialog(Shell shell, S32DSValueVariable variable) {
        super(shell);
        this.variable = variable;
        this.defaultValue = variable.getCleVariable().getDefaultValue();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(container);
        this.createNameField(container);
        this.createDescriptionField(container);
        this.createValueField(container);
        this.createResetButton(container);
        S32DSVariableEditDialog.applyDialogFont((Control)container);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)Messages.S32DSVariableEditDialog_edit_variable_0, (Object)this.variable.getName()));
    }

    protected void okPressed() {
        this.variable.setValue(this.getValueFromText());
        super.okPressed();
    }

    private String getValueFromText() {
        String text = this.valueText.getText();
        if (text.isEmpty()) {
            return this.defaultValue == null ? null : text;
        }
        return text;
    }

    private boolean equalsToText(String value) {
        return Objects.equals(value, this.getValueFromText());
    }

    private void createNameField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.S32DSVariableEditDialog_name);
        Text text = new Text(parent, 0);
        text.setText(this.variable.getName());
        text.setEditable(false);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)text);
    }

    private void createDescriptionField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.S32DSVariableEditDialog_description);
        Text text = new Text(parent, 0);
        text.setText(S32DSVariablesLabelProviders.wrapNull(this.variable.getDescription()));
        text.setEditable(false);
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).span(2, 1).applyTo((Control)text);
    }

    private void createValueField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.S32DSVariableEditDialog_value);
        this.valueText = new Text(parent, 2052);
        this.valueText.setText(S32DSVariablesLabelProviders.wrapNull(this.variable.getValue()));
        GridDataFactory.swtDefaults().grab(true, false).align(4, 0x1000000).hint(400, -1).applyTo((Control)this.valueText);
        this.valueText.addModifyListener(e -> this.valueChanged());
        Button button = new Button(parent, 8);
        button.setText(Messages.S32DSVariableEditDialog_browse);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DSVariableEditDialog.this.browsePressed();
            }
        });
    }

    private void valueChanged() {
        this.getButton(0).setEnabled(!this.equalsToText(this.variable.getValue()));
        this.updateResetButton();
    }

    private void createResetButton(Composite parent) {
        Label label = new Label(parent, 0);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        this.resetButton = new Button(parent, 8);
        this.resetButton.setText(Messages.S32DSVariableEditDialog_reset_to_default_value);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DSVariableEditDialog.this.valueText.setText(S32DSVariablesLabelProviders.wrapNull(S32DSVariableEditDialog.this.defaultValue));
                S32DSVariableEditDialog.this.valueText.setFocus();
            }
        });
        this.updateResetButton();
    }

    private void updateResetButton() {
        this.resetButton.setEnabled(!this.equalsToText(this.defaultValue));
    }

    private void browsePressed() {
        String selectedDir;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String value = this.valueText.getText();
        if (!value.trim().isEmpty()) {
            try {
                value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
                if (Files.exists(Paths.get(value, new String[0]), new LinkOption[0])) {
                    dialog.setFilterPath(value);
                }
            }
            catch (CoreException e) {
                S32DSVariablesUiPreferencesActivator.getInstance().logError(NLS.bind((String)"Cannot resolve variable value '''{0}'", (Object)value), e);
            }
        }
        if ((selectedDir = dialog.open()) != null) {
            this.valueText.setText(selectedDir);
        }
    }
}

