/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemoryAccessor;
import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpaces;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.swt.custom.CTabItem;

public class MemoryBase {
    private final Map<DsfSession, Collection<CTabItem>> session2Tab = new HashMap<DsfSession, Collection<CTabItem>>();
    private final Map<DsfSession, Collection<MemorySpace>> session2memory = new HashMap<DsfSession, Collection<MemorySpace>>();
    private final Map<MemorySpace, List<CTabItem>> memory2Tab = new HashMap<MemorySpace, List<CTabItem>>();
    private final List<IMemoryRenderingContainer> renderContainers;
    private MemoryAccessor memoryAccessor = MemorySpaces.getMemoryAccessor();
    private static MemoryBase instance;
    private static boolean MEMORY_TRACE;

    static {
        MEMORY_TRACE = false;
    }

    private MemoryBase() {
        this.session2Tab.clear();
        this.memory2Tab.clear();
        this.session2memory.clear();
        this.renderContainers = new ArrayList<IMemoryRenderingContainer>();
    }

    public static MemoryBase getInstance() {
        if (instance == null) {
            instance = new MemoryBase();
        }
        return instance;
    }

    public Collection<CTabItem> getCTabBySession(DsfSession session) {
        return this.session2Tab.getOrDefault(session, Collections.emptySet());
    }

    public Collection<Collection<CTabItem>> getCTabs() {
        return this.session2Tab.values();
    }

    public MemoryAccessor getMemoryAccessor() {
        return this.memoryAccessor;
    }

    public List<DeviceCoreMemorySpaceDescriptor> getMemorySpacesByContext() {
        return this.memoryAccessor.getDeviceMemorySpaceDescriptors((ILaunch)this.memoryAccessor.getLaunch());
    }

    public List<CTabItem> getTabByMemorySpace(MemorySpace memorySpace) {
        return this.memory2Tab.get(memorySpace);
    }

    public void removeMemorySpaceForSession(MemorySpace space) {
        this.memory2Tab.remove(space);
        for (Map.Entry<DsfSession, Collection<MemorySpace>> entry : this.session2memory.entrySet()) {
            Collection<MemorySpace> collection = entry.getValue();
            if (!collection.contains(space)) continue;
            collection.remove(space);
            break;
        }
    }

    public void removeMemorySpace(DsfSession session, MemorySpace space, CTabItem item) {
        if (session == null) {
            return;
        }
        this.removeMemorySpaceForSession(session, space);
        this.removeCTabItemForSession(session, item);
        if (MEMORY_TRACE) {
            this.trace();
        }
    }

    public void removeMemorySpace(MemorySpace space, CTabItem item) {
        this.removeMemorySpaceForSession(space);
        this.removeCTabItemForSession(item);
        if (MEMORY_TRACE) {
            this.trace();
        }
    }

    public void removeMemorySpaceForSession(DsfSession session, MemorySpace space) {
        this.memory2Tab.remove(space);
        Collection<MemorySpace> memSpaces = this.session2memory.get(session);
        if (memSpaces != null) {
            memSpaces.remove(space);
        }
    }

    public void removeCTabItemForSession(CTabItem tab) {
        for (Map.Entry<DsfSession, Collection<CTabItem>> entry : this.session2Tab.entrySet()) {
            Collection<CTabItem> collection = entry.getValue();
            if (!collection.contains(tab)) continue;
            collection.remove(tab);
        }
    }

    public void removeCTabItemForSession(DsfSession session, CTabItem tab) {
        Collection<CTabItem> tabs = this.session2Tab.get(session);
        if (tabs != null) {
            tabs.remove(tab);
        }
    }

    public void clearAll() {
        this.session2Tab.clear();
        this.memory2Tab.clear();
        this.session2memory.clear();
        this.renderContainers.clear();
    }

    public IMemoryRenderingContainer[] getMemoryRenderingContainers() {
        return this.renderContainers.toArray(new IMemoryRenderingContainer[0]);
    }

    public void addMemoryRenderingContainer(IMemoryRenderingContainer container) {
        this.renderContainers.add(container);
    }

    public void removeMemoryRenderingContainer(IMemoryRenderingContainer container) {
        if (this.renderContainers.contains(container)) {
            this.renderContainers.remove(container);
        }
    }

    public void addMemorySpace(MemorySpace memorySpace, CTabItem tab) {
        this.addMemorySpace(memorySpace, tab, this.getDsfSession());
    }

    public void addMemorySpace(MemorySpace memorySpace, CTabItem tab, DsfSession session) {
        if (session == null) {
            return;
        }
        this.addMemorySpace2Session(session, memorySpace);
        this.addCTab2Session(session, tab);
        this.addMemorySpace2Tab(memorySpace, tab);
        if (MEMORY_TRACE) {
            this.trace();
        }
    }

    private void addMemorySpace2Session(DsfSession session, MemorySpace memorySpace) {
        this.session2memory.computeIfAbsent(session, k -> new LinkedHashSet()).add(memorySpace);
    }

    private void addCTab2Session(DsfSession session, CTabItem tab) {
        Collection tabs = this.session2Tab.getOrDefault(session, new HashSet());
        tabs.add(tab);
        this.session2Tab.put(session, tabs);
    }

    public boolean removeTabForMemorySpace(MemorySpace memorySpace, CTabItem tabItem) {
        Collection tabs = this.memory2Tab.getOrDefault(memorySpace, Collections.emptyList());
        tabs.remove(tabItem);
        return tabs.isEmpty();
    }

    private void addMemorySpace2Tab(MemorySpace memorySpace, CTabItem tabItem) {
        List tabs = this.memory2Tab.getOrDefault(memorySpace, new ArrayList());
        tabs.add(tabItem);
        this.memory2Tab.put(memorySpace, tabs);
    }

    private DsfSession getDsfSession() {
        if (this.memoryAccessor.getLaunch() == null) {
            return null;
        }
        return this.memoryAccessor.getLaunch().getSession();
    }

    public Collection<MemorySpace> getMemorySpacesBySession() {
        if (this.memoryAccessor.getLaunch() == null) {
            return Collections.emptyList();
        }
        DsfSession session = this.memoryAccessor.getLaunch().getSession();
        return this.session2memory.get(session);
    }

    public void setEnabledMemorySpacesBySession(boolean enable) {
        DsfSession session = this.getDsfSession();
        this.session2memory.computeIfAbsent(session, k -> new LinkedHashSet()).stream().forEach(p -> p.setEnabled(enable));
    }

    public Collection<MemorySpace> getMemorySpaces() {
        return this.session2memory.values().stream().flatMap(collection -> collection.stream()).collect(Collectors.toList());
    }

    public void clear() {
        this.session2memory.clear();
        this.session2Tab.clear();
        this.memory2Tab.clear();
    }

    public void trace() {
        System.out.println("");
        System.out.println(">>> session-2-tabs");
        for (Map.Entry<DsfSession, Collection<CTabItem>> entry : this.session2Tab.entrySet()) {
            if (entry.getKey() == null) continue;
            System.out.println(">>> session : " + entry.getKey().toString() + " : " + entry.getKey().getId());
            entry.getValue().stream().forEach(c -> System.out.println("--- >>> CTabItem : " + c.toString() + " " + c.getToolTipText()));
        }
        System.out.println("");
        System.out.println(">>> session-2-memory");
        for (Map.Entry<DsfSession, Collection<CTabItem>> entry : this.session2memory.entrySet()) {
            if (entry.getKey() == null) continue;
            System.out.println(">>> session : " + entry.getKey().toString() + " : " + entry.getKey().getId());
            entry.getValue().stream().forEach(c -> System.out.println("--- >>> MemorySpace : " + c.getName()));
        }
        System.out.println(">>> end of log  >>>");
        System.out.println("");
    }
}

