/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.resource;

import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.ext.rcp.registry.ElementDescriptor;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResourceSdkDescriptorImplementation
extends ElementDescriptor
implements ResourceSdkDescriptor {
    private ResourceSdkKind kind;
    private String sdkId;
    private String toolChainId;

    public ResourceSdkDescriptorImplementation(Element element, String sdkId) {
        super(element);
        this.addSubstitution("sourceId", "path");
        this.kind = ResourceSdkKind.of((String)element.getNodeName());
        this.sdkId = sdkId;
        this.toolChainId = "";
    }

    public ResourceSdkDescriptorImplementation(Element element, String sdkId, String toolChainId) {
        this(element, sdkId);
        if (toolChainId != null && !toolChainId.isEmpty()) {
            this.toolChainId = toolChainId;
        }
    }

    public String getPath() {
        return this.getSourceId();
    }

    public String getSdkId() {
        return this.getTargetId();
    }

    public String getTargetId() {
        return this.sdkId;
    }

    public String getToolChainId() {
        return this.toolChainId;
    }

    public ResourceSdkKind getKind() {
        return this.kind;
    }

    public boolean isCopy() {
        return Boolean.parseBoolean(this.getAttribute("copy"));
    }

    public String getRenameTo() {
        return this.getAttribute("renameTo");
    }

    public String getCopyToProjectPath() {
        return this.getAttribute("copyToProjectPath");
    }

    public boolean isToOpen() {
        return this.kind.isFileKind() && Boolean.parseBoolean(this.getAttribute("toOpen"));
    }

    public String getLangId() {
        return this.getAttribute("langId");
    }

    public Set<String> getConfigurations() {
        return this.getAttributesSet("configurations");
    }

    public String getConditionRef() {
        return this.getAttribute("conditionRef");
    }

    public String toString() {
        String conditionRef;
        StringBuilder sb = new StringBuilder();
        sb.append("Resource: type=").append(this.getKind()).append(" path=").append(this.getPath());
        String langId = this.getLangId();
        if (!langId.isEmpty()) {
            sb.append(" langId=").append(langId);
        }
        if (this.isCopy()) {
            String renameTo;
            sb.append(" isCopy=yes");
            String copyToProjectPath = this.getCopyToProjectPath();
            if (!copyToProjectPath.isEmpty()) {
                sb.append(" copyPath=").append(copyToProjectPath);
            }
            if (!(renameTo = this.getRenameTo()).isEmpty()) {
                sb.append(" renameTo=").append(renameTo);
            }
        }
        if (!(conditionRef = this.getConditionRef()).isEmpty()) {
            sb.append(" conditionRef=").append(conditionRef);
        } else {
            Set<String> configurations = this.getConfigurations();
            if (!configurations.isEmpty()) {
                sb.append(" configurations=").append(String.join((CharSequence)",", configurations));
            }
        }
        sb.append(" toolChainId=").append(this.getToolChainId()).append(" sdkId=").append(this.getSdkId());
        return sb.toString();
    }

    public Element convertToXml(Document document, Element holderElement) {
        String conditionRef;
        Set<String> configurations;
        String langId;
        Element element = document.createElement(this.getKind().getXmlElementName());
        element.setAttribute("path", this.getPath());
        if (this.isCopy()) {
            String renameTo;
            element.setAttribute("copy", Boolean.TRUE.toString());
            String copyToProjectPath = this.getCopyToProjectPath();
            if (!copyToProjectPath.isEmpty()) {
                element.setAttribute("copyToProjectPath", copyToProjectPath);
            }
            if (!(renameTo = this.getRenameTo()).isEmpty()) {
                element.setAttribute("renameTo", renameTo);
            }
        }
        if (!(langId = this.getLangId()).isEmpty()) {
            element.setAttribute("langId", langId);
        }
        if (this.isToOpen()) {
            element.setAttribute("toOpen", Boolean.TRUE.toString());
        }
        if (!(configurations = this.getConfigurations()).isEmpty()) {
            element.setAttribute("configurations", String.join((CharSequence)",", configurations));
        }
        if (!(conditionRef = this.getConditionRef()).isEmpty()) {
            element.setAttribute("conditionRef", conditionRef);
        }
        holderElement.appendChild(element);
        return element;
    }
}

