/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.core;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkRegistry;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryLogger;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.buildstep.BuildStepSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.symbol.SymbolSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkDescriptors {
    private static final String BASE_PATH_PREFIX = "${";
    private static final String BASE_PATH_SUFFIX = "}";

    private SdkDescriptors() {
    }

    public static SdkRegistry getSdkRegistry() {
        return SdkRegistryCoreActivator.getInstance().getSdkRegistry();
    }

    public static List<SdkDescriptor> getSdkDescriptors() {
        return SdkDescriptors.getSdkRegistry().getSdkDescriptors();
    }

    public static List<SdkDescriptor> getSdkDescriptorsByType(SdkType type) {
        return SdkDescriptors.getSdkRegistry().getSdkDescriptors().stream().filter(descriptor -> type == descriptor.getType()).collect(Collectors.toList());
    }

    public static SdkDescriptor getSdkDescriptor(String sdkId) {
        return SdkDescriptors.getSdkRegistry().getSdkDescriptor(sdkId);
    }

    public static void addSdkDescriptor(SdkDescriptor descriptor) {
        SdkDescriptors.getSdkRegistry().addSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.SdkDescriptors_register_descriptor_message, (Object)descriptor.getId()));
    }

    public static void removeSdkDescriptor(SdkDescriptor descriptor) {
        SdkDescriptors.getSdkRegistry().removeSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.SdkDescriptors_unregister_descriptor_message, (Object)descriptor.getId()));
    }

    public static void removeSdkDescriptor(String sdkId) {
        SdkDescriptors.getSdkRegistry().removeSdkDescriptorBySdkId(sdkId);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.SdkDescriptors_unregister_descriptor_message, (Object)sdkId));
    }

    public static Element convertToXml(SdkType type, Document document) {
        Element sdksElement = document.createElement("sdks");
        document.appendChild(sdksElement);
        List<SdkDescriptor> sdkDescriptors = SdkDescriptors.sortSdkListByDependency(SdkDescriptors.getSdkDescriptorsByType(type));
        for (SdkDescriptor descriptor : sdkDescriptors) {
            Element sdkElement = descriptor.convertToXml(document, sdksElement);
            String sdkId = descriptor.getId();
            EnvironmentSdkDescriptors.convertToXml(sdkId, document, sdkElement);
            PlatformSdkDescriptors.convertToXml(sdkId, document, sdkElement);
            ToolChainSdkDescriptor rootToolChain = ToolChainSdkDescriptors.getRootToolChainSdkDescriptor(sdkId);
            String rootToolChainId = rootToolChain != null ? rootToolChain.getToolChainId() : "";
            SymbolSdkDescriptors.convertToXml(sdkId, rootToolChainId, document, sdkElement);
            ResourceSdkDescriptors.convertToXml(sdkId, rootToolChainId, document, sdkElement);
            ToolChainSdkDescriptors.convertToXml(sdkId, document, sdkElement);
            ModuleSdkDescriptors.convertToXml(sdkId, document, sdkElement);
            BuildStepSdkDescriptors.convertToXml(sdkId, document, sdkElement);
        }
        return sdksElement;
    }

    public static List<SdkDescriptor> sortSdkListByDependency(List<SdkDescriptor> sdkDescriptors) {
        ArrayList<SdkDescriptor> sortedList = new ArrayList<SdkDescriptor>();
        ArrayList<SdkDescriptor> visited = new ArrayList<SdkDescriptor>();
        for (SdkDescriptor sdkDescriptor : sdkDescriptors) {
            if (visited.contains(sdkDescriptor)) continue;
            SdkDescriptors.topologicalSortRecursion(sdkDescriptor, visited, sortedList, sdkDescriptors);
        }
        return sortedList;
    }

    private static void topologicalSortRecursion(SdkDescriptor sdkDescriptor, List<SdkDescriptor> visited, List<SdkDescriptor> sortedList, List<SdkDescriptor> sdkDescriptors) {
        visited.add(sdkDescriptor);
        if (sdkDescriptor.getBasePath().startsWith(BASE_PATH_PREFIX) && sdkDescriptor.getBasePath().endsWith(BASE_PATH_SUFFIX)) {
            String dependId = sdkDescriptor.getBasePath().substring(BASE_PATH_PREFIX.length(), sdkDescriptor.getBasePath().length() - BASE_PATH_SUFFIX.length());
            Optional<SdkDescriptor> depend = sdkDescriptors.stream().filter(sdk -> sdk.getId().toUpperCase().equals(dependId)).findFirst();
            if (depend.isPresent() && !visited.contains(depend.get())) {
                SdkDescriptors.topologicalSortRecursion(depend.get(), visited, sortedList, sdkDescriptors);
            }
        }
        sortedList.add(sdkDescriptor);
    }

    public static String getSdksXmlString(SdkType sdkType) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            SdkDescriptors.convertToXml(sdkType, document);
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(document), new StreamResult(baos));
                return baos.toString(StandardCharsets.UTF_8.name());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            SdkRegistryCoreActivator.getInstance().logError("Unable to convert SDKs xml to string due to error", e);
            return "";
        }
    }
}

