/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.epc.model;

import com.nxp.swtools.asr.convertor.AsrImporterHelper;
import com.nxp.swtools.asr.epc.model.Entry;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="peripherals_clocks_mappings")
public class PeripheralsClocksMappings {
    private static final Logger LOGGER = LogManager.getLogger(PeripheralsClocksMappings.class);
    private static final String PERIPHERAL_CLOCKS_MAPPING_FILE_NAME = "peripheralsClocksMapping.xml";
    @ElementList(type=Entry.class, required=true, inline=true)
    private List<Entry> entries;

    protected PeripheralsClocksMappings() {
        this(new ArrayList<Entry>());
    }

    public PeripheralsClocksMappings(List<Entry> entries) {
        this.entries = entries;
    }

    public static void loadClocksPeripheralsMappingFile() {
        ICommonConfig commonConfig = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig();
        String mcu = commonConfig.getMcu();
        String sdkVersion = commonConfig.getSdkVersion();
        IProcessorMasterToolInfo processorMasterToolInfo = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getProcessorMasterToolInfo(mcu, sdkVersion);
        if (processorMasterToolInfo != null) {
            String mcuDataDir = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getDataDir();
            String subDir = processorMasterToolInfo.getSubDir();
            String selectedMcuPackage = commonConfig.getPackage();
            String clocksMappingFilePath = String.valueOf(mcuDataDir) + File.separator + subDir + File.separator + selectedMcuPackage + File.separator + PERIPHERAL_CLOCKS_MAPPING_FILE_NAME;
            File clocksMappingFile = new File(clocksMappingFilePath);
            if (clocksMappingFile.exists() && clocksMappingFile.isFile()) {
                try {
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (InputStream configClassesInStr = UtilsDecryption.getFileInputStream((File)clocksMappingFile);){
                        Persister serializer = new Persister();
                        PeripheralsClocksMappings result = (PeripheralsClocksMappings)serializer.read(PeripheralsClocksMappings.class, configClassesInStr);
                        Map<String, String> peripheralsClocksMapping = AsrImporterHelper.getInstance().getPeripheralClocksMapping();
                        if (peripheralsClocksMapping.isEmpty()) {
                            for (Entry entry : result.getEntries()) {
                                peripheralsClocksMapping.put(entry.getKey(), entry.getValue());
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOGGER.warning(MessageFormat.format("[DATA] The following exception occured when trying to read the content of {0} file {1}.", PERIPHERAL_CLOCKS_MAPPING_FILE_NAME, e.getLocalizedMessage()));
                }
            }
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeripheralsClocksMappings other = (PeripheralsClocksMappings)obj;
        return Objects.equals(this.entries, other.entries);
    }
}

