/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.asr.epc.model;

import com.nxp.swtools.asr.epc.model.PinMode;
import com.nxp.swtools.asr.epc.model.SreOption;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="pin_mapping")
public class PinMapping {
    @Attribute(name="mscr", required=true)
    private int mscr;
    @Attribute(name="name", required=true)
    private String name;
    @Attribute(name="coords", required=true)
    private String coords;
    @ElementList(name="sre_options", entry="sre_option", empty=false, required=false)
    private List<SreOption> sreOptions;
    @ElementList(name="pin_modes", entry="pin_mode", empty=false, required=false)
    private List<PinMode> pinModes;

    protected PinMapping() {
        this(0, "", "", new ArrayList<SreOption>(), new ArrayList<PinMode>());
    }

    public PinMapping(int mscr, String name, String coords, List<SreOption> sreOptions, List<PinMode> pinModes) {
        this.mscr = mscr;
        this.name = name;
        this.coords = coords;
        this.sreOptions = sreOptions;
        this.pinModes = pinModes;
    }

    public int getMSCR() {
        return this.mscr;
    }

    public String getName() {
        return this.name;
    }

    public String getCoords() {
        return this.coords;
    }

    public List<SreOption> getSreOptions() {
        return this.sreOptions;
    }

    public List<PinMode> getPinModes() {
        return this.pinModes;
    }

    public @Nullable PinMode findPinModeByForeignValue(String value) {
        for (PinMode pinMode : this.pinModes) {
            if (!value.equalsIgnoreCase(pinMode.getForeignValue())) continue;
            return pinMode;
        }
        return null;
    }

    public @Nullable SreOption findSreOptionByForeignId(String foreignId) {
        for (SreOption sreOption : this.sreOptions) {
            if (!foreignId.equals(sreOption.getForeignId())) continue;
            return sreOption;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.mscr, this.name, this.coords, this.pinModes, this.sreOptions);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PinMapping other = (PinMapping)obj;
        return Objects.equals(this.mscr, other.mscr) && Objects.equals(this.name, other.name) && Objects.equals(this.coords, other.coords) && Objects.equals(this.pinModes, other.pinModes) && Objects.equals(this.sreOptions, other.sreOptions);
    }
}

