/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.SetTimingScale;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

public class LargeSetScale
extends TimingScale {
    @NonNull
    private @NonNull TreeSet<@NonNull BigRational> validVals;

    public LargeSetScale(@NonNull List<@NonNull BigRational> scales) {
        BigRational tmpVal;
        @NonNull BigInteger tmpN = ZERO;
        this.nxt = null;
        this.type = EScaleType.SetLarge;
        this.validVals = new TreeSet();
        assert (scales.size() > 0) : "Empty list";
        for (BigRational scale : scales) {
            tmpN = LargeSetScale.addNN(tmpN, ONE);
            this.validVals.add(scale);
        }
        this.numOfScales = tmpN;
        this.from = tmpVal = Objects.requireNonNull(this.validVals.first());
        this.to = tmpVal = Objects.requireNonNull(this.validVals.last());
    }

    public LargeSetScale(BigRational ... scales) {
        BigRational tmpVal;
        @NonNull BigInteger tmpN = ZERO;
        this.nxt = null;
        this.type = EScaleType.SetLarge;
        this.validVals = new TreeSet();
        BigRational[] bigRationalArray = scales;
        int n = scales.length;
        int n2 = 0;
        while (n2 < n) {
            BigRational scale = bigRationalArray[n2];
            tmpN = LargeSetScale.addNN(tmpN, ONE);
            this.validVals.add(scale);
            ++n2;
        }
        this.numOfScales = tmpN;
        this.from = tmpVal = Objects.requireNonNull(this.validVals.first());
        this.to = tmpVal = Objects.requireNonNull(this.validVals.last());
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null) {
            return false;
        }
        if (arg.getClass() != this.getClass()) {
            return false;
        }
        LargeSetScale as = (LargeSetScale)arg;
        if (this.type != as.type) {
            return false;
        }
        if (!this.from.equals((Object)as.from)) {
            return false;
        }
        if (!this.to.equals((Object)as.to)) {
            return false;
        }
        if (!this.numOfScales.equals(as.numOfScales)) {
            return false;
        }
        return this.validVals.equals(as.validVals);
    }

    @Override
    public int hashCode() {
        int res = this.type.hashCode();
        res ^= this.from.getNumerator().intValue();
        res ^= this.to.getDenominator().intValue();
        return res ^= this.numOfScales.intValue();
    }

    @Override
    public void printVals() {
        for (BigRational i : this.validVals) {
            System.out.println(i);
        }
    }

    @Override
    public boolean inRange(@Nullable BigRational value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(this.from) >= 0 && value.compareTo(this.to) <= 0;
    }

    @Override
    public boolean elem(@Nullable BigRational value) {
        return this.validVals.contains(value);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public @NonNull BigRational closest(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        values = this.validVals.iterator();
        if (!LargeSetScale.$assertionsDisabled && values == null) {
            throw new AssertionError((Object)"Iterator fails to create");
        }
        actual = last = values.next();
        if (LargeSetScale.$assertionsDisabled || actual != null && last != null) ** GOTO lbl15
        throw new AssertionError((Object)"Iterator is emtpy");
lbl-1000:
        // 1 sources

        {
            last = actual;
            actual = values.next();
            if (!LargeSetScale.$assertionsDisabled && actual == null) {
                throw new AssertionError((Object)"Iterator fails to provide next member");
            }
lbl15:
            // 3 sources

            ** while (value.compareTo((BigRational)actual) > 0)
        }
lbl16:
        // 1 sources

        if (!LargeSetScale.$assertionsDisabled && last == null) {
            throw new AssertionError((Object)"Assignment in Java failed");
        }
        if (value.compareTo(last) == 0) {
            return last;
        }
        if (value.subtract(last).compareTo(value.subtract(actual).negate()) < 0) {
            return last;
        }
        return actual;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public @Nullable BigRational closestUp(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return null;
        }
        values = this.validVals.iterator();
        if (!LargeSetScale.$assertionsDisabled && values == null) {
            throw new AssertionError((Object)"Iterator fails to create");
        }
        actual = values.next();
        if (LargeSetScale.$assertionsDisabled || actual != null) ** GOTO lbl14
        throw new AssertionError((Object)"Iterator is emtpy");
lbl-1000:
        // 1 sources

        {
            actual = values.next();
            if (!LargeSetScale.$assertionsDisabled && actual == null) {
                throw new AssertionError((Object)"Iterator fails to provide next member");
            }
lbl14:
            // 3 sources

            ** while (value.compareTo((BigRational)actual) > 0)
        }
lbl15:
        // 1 sources

        return actual;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public @Nullable BigRational closestDown(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return null;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        values = this.validVals.iterator();
        if (!LargeSetScale.$assertionsDisabled && values == null) {
            throw new AssertionError((Object)"Iterator fails to create");
        }
        actual = last = values.next();
        if (LargeSetScale.$assertionsDisabled || actual != null && last != null) ** GOTO lbl15
        throw new AssertionError((Object)"Iterator is emtpy");
lbl-1000:
        // 1 sources

        {
            last = actual;
            actual = values.next();
            if (!LargeSetScale.$assertionsDisabled && actual == null) {
                throw new AssertionError((Object)"Iterator fails to provide next member");
            }
lbl15:
            // 3 sources

            ** while (value.compareTo((BigRational)actual) > 0)
        }
lbl16:
        // 1 sources

        if (!LargeSetScale.$assertionsDisabled && last == null) {
            throw new AssertionError((Object)"Assignment in Java failed");
        }
        if (value.compareTo(actual) == 0) {
            return actual;
        }
        return last;
    }

    @Override
    public Iterator<BigRational> iterator() {
        return this.validVals.iterator();
    }

    @Override
    public @NonNull TimingScale.IntervalNarrowingContext getInitialMiddle() {
        throw new UnsupportedOperationException("Method getInitialMiddle() is not applicable for thei class.");
    }

    @Override
    @NonNull TimingScale.IntervalNarrowingContext getValInMiddleR(@NonNull TimingScale.IntervalNarrowingContext interval) {
        throw new UnsupportedOperationException("Method getValInMiddleR() is not applicable for thei class.");
    }

    @Override
    public @NonNull TimingScale shrinkScale(@Nullable BigInteger maxNumberOfScales) {
        if (maxNumberOfScales == null || maxNumberOfScales.compareTo(this.numOfScales) >= 0) {
            return this;
        }
        BigInteger numOfValuesToRemove = this.numOfScales.subtract(maxNumberOfScales);
        BigInteger removeEach = this.numOfScales.divide(numOfValuesToRemove);
        LinkedList<@NonNull BigRational> newSet = new LinkedList<BigRational>();
        if (removeEach.compareTo(BigInteger.ONE) == 0) {
            BigInteger takeEach = this.numOfScales.divide(maxNumberOfScales);
            BigInteger counter = BigInteger.ONE;
            for (BigRational value : this.validVals) {
                if (counter.compareTo(takeEach) >= 0) {
                    newSet.add(value);
                    counter = BigInteger.ONE;
                    continue;
                }
                counter = counter.add(BigInteger.ONE);
            }
            return new SetTimingScale(newSet);
        }
        BigInteger counter = BigInteger.ONE;
        for (BigRational value : this.validVals) {
            if (counter.compareTo(removeEach) >= 0) {
                counter = BigInteger.ONE;
                continue;
            }
            newSet.add(value);
            counter = counter.add(BigInteger.ONE);
        }
        return new SetTimingScale(newSet);
    }
}

