/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinearTimingScale
extends TimingScale {
    private static final Logger LOGGER = LogManager.getLogger(LinearTimingScale.class);
    @NonNull
    protected BigRational step;
    @NonNull
    protected TimingScale.INextVal prev;

    public LinearTimingScale(@NonNull BigInteger fromScale, @NonNull BigInteger toScale, @NonNull BigInteger step) {
        this(new BigRational(fromScale), new BigRational(toScale), new BigRational(step));
        this.nxt = p -> p.add(step);
        this.prev = q -> q.subtract(step);
    }

    public LinearTimingScale(@NonNull BigRational fromScale, @NonNull BigRational toScale, @NonNull BigRational step) {
        this.from = fromScale;
        BigRational tmpN = toScale.subtract(fromScale).divide(step).add(BigRational.ONE);
        assert (tmpN.getDenominator().equals(TimingScale.ONE));
        this.numOfScales = tmpN.getNumerator();
        this.nxt = p -> p.add(step);
        this.prev = q -> q.subtract(step);
        this.to = toScale;
        this.step = step;
        this.type = EScaleType.LinearSmall;
    }

    public LinearTimingScale(int fromScale, int toScale, int step) {
        this(new BigRational(fromScale), new BigRational(toScale), new BigRational(step));
        this.nxt = p -> p.add(step);
        this.prev = q -> q.subtract(step);
    }

    @Override
    public int hashCode() {
        return this.from.getNumerator().intValue() ^ this.to.getNumerator().intValue() ^ this.numOfScales.intValue() ^ this.step.getNumerator().intValue() ^ this.type.ordinal();
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null) {
            return false;
        }
        if (arg.getClass() != this.getClass()) {
            return false;
        }
        LinearTimingScale as = (LinearTimingScale)arg;
        if (!this.type.equals((Object)as.type)) {
            return false;
        }
        if (!this.from.equals((Object)as.from)) {
            return false;
        }
        if (!this.to.equals((Object)as.to)) {
            return false;
        }
        if (!this.numOfScales.equals(as.numOfScales)) {
            return false;
        }
        return this.step.equals((Object)as.step);
    }

    @Override
    public boolean inRange(@Nullable BigRational value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(this.from) >= 0 && value.compareTo(this.to) <= 0;
    }

    @Override
    public Iterator<BigRational> iterator() {
        Iterator<BigRational> it = new Iterator<BigRational>(){
            @NonNull
            private BigRational p;
            {
                this.p = LinearTimingScale.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.p.compareTo(LinearTimingScale.this.to) <= 0;
            }

            @Override
            public BigRational next() {
                if (this.p.compareTo(LinearTimingScale.this.to) > 0) {
                    throw new NoSuchElementException();
                }
                @NonNull BigRational ret = this.p;
                this.p = this.p.add(LinearTimingScale.this.step);
                return ret;
            }
        };
        return it;
    }

    @Override
    public @NonNull TimingScale.IntervalNarrowingContext getInitialMiddle() {
        if (this.numOfScales.compareTo(LASTINT) <= 0) {
            int numOfValues = this.numOfScales.intValue();
            int ncount = numOfValues / 2;
            int numsMid = ncount + 1;
            @NonNull BigRational midVal = this.from.add(this.step.multiply(ncount));
            return new TimingScale.IntIntervalNarrowingContext(this.from, midVal, this.to, numOfValues, numsMid, this.step, false);
        }
        if (this.numOfScales.compareTo(LASTLONG) <= 0) {
            long numOfValues = this.numOfScales.longValue();
            long ncount = numOfValues / 2L;
            long numsMid = ncount + 1L;
            @NonNull BigRational midVal = this.from.add(this.step.multiply(ncount));
            return new TimingScale.LongIntervalNarrowingContext(this.from, midVal, this.to, numOfValues, numsMid, this.step);
        }
        @NonNull BigInteger ncount = LinearTimingScale.divNN(this.numOfScales, TWO);
        @NonNull BigInteger numsMid = LinearTimingScale.subNN(ncount, ONE);
        @NonNull BigRational midVal = this.from.add(this.step.multiply(ncount));
        return new TimingScale.BigIntIntervalNarrowingContext(this.from, midVal, this.to, this.numOfScales, numsMid, this.step);
    }

    @Override
    public @NonNull TimingScale shrinkScale(@Nullable BigInteger maxNumberOfScales) {
        if (maxNumberOfScales == null || maxNumberOfScales.compareTo(this.numOfScales) >= 0) {
            return this;
        }
        BigRational minNewStep = this.to.subtract(this.from).divide(maxNumberOfScales);
        BigInteger wholeMinNewStep = minNewStep.toBigIntegerRounded(RoundingMode.UP);
        BigInteger newStep = BigInteger.valueOf(2L).pow(wholeMinNewStep.bitLength() - 1);
        if (minNewStep.compareTo(newStep) > 0) {
            newStep = newStep.multiply(BigInteger.valueOf(2L));
        }
        BigInteger newFrom = this.from.compareTo(newStep = Objects.requireNonNull(new BigRational(newStep).divide(this.step).toBigIntegerRounded(RoundingMode.UP).multiply(this.step.toBigInteger()))) < 0 && this.elem(new BigRational(newStep)) ? newStep : this.from.toBigInteger();
        BigInteger newRangeSize = this.to.subtract(newFrom).toBigIntegerRounded(RoundingMode.DOWN);
        BigInteger newTo = Objects.requireNonNull(newFrom.add(newStep.multiply(newRangeSize)));
        if (newRangeSize.divide(newStep).compareTo(maxNumberOfScales) > 0) {
            LOGGER.log(Level.SEVERE, "Timing scale shrink not successfull !");
        }
        return new LinearTimingScale(newFrom, newTo, newStep);
    }

    @Override
    @NonNull TimingScale.IntervalNarrowingContext getValInMiddleR(@NonNull TimingScale.IntervalNarrowingContext interval) {
        interval.halfMidVal();
        interval.newMidVal();
        return interval;
    }

    @Override
    public @NonNull TimingScale.INextVal getPrevValFun() {
        return this.prev;
    }
}

