/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeHidden;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.ArrayList;
import java.util.List;

public class NodeSplitter
extends NodeHidden {
    private ArrayList<@NonNull NodeHidden> children = null;
    private ArrayList<@NonNull NodeHidden> predecessors = null;
    @Nullable
    private BigRational inputClock = null;

    public NodeSplitter(@NonNull String id) {
        super(id, ENodeType.Splitter);
    }

    @Override
    public void addChild(@NonNull Node child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add((NodeHidden)child);
    }

    @Override
    public void addPred(@NonNull Node pred) {
        if (this.predecessors == null) {
            this.predecessors = new ArrayList();
        }
        this.predecessors.add((NodeHidden)pred);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        void var5_10;
        String ps = null;
        if (this.predecessors == null) {
            ps = "";
        } else {
            for (Node node : this.predecessors) {
                ps = ps == null ? node.id : String.valueOf(ps) + "/" + node.id;
            }
        }
        Object var5_7 = null;
        if (this.inputClock == null) {
            String string = "";
        } else {
            String string = "@" + this.inputClock;
        }
        System.out.println(String.valueOf(pref) + "*" + this.id + "(" + ps + ")" + (String)var5_10);
        if (this.children != null) {
            NodeHidden last = null;
            for (NodeHidden node : this.children) {
                if (last == null) {
                    last = node;
                    continue;
                }
                last.printT(this, pref, "");
                last = node;
            }
            if (last != null) {
                last.printT(this, prefLast, prefLast);
            }
        }
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer ps = null;
        if (this.predecessors == null) {
            ps = new StringBuffer();
        } else {
            for (NodeHidden pred : this.predecessors) {
                if (ps == null) {
                    ps = new StringBuffer(pred.id);
                    continue;
                }
                ps.append('/');
                ps.append(pred.id);
            }
        }
        StringBuffer cs = new StringBuffer();
        if (this.inputClock != null) {
            cs.append('@');
            cs.append(this.inputClock);
        }
        StringBuffer res = new StringBuffer(pref);
        res.append('*');
        res.append(this.id);
        res.append('(');
        res.append(ps);
        res.append(')');
        res.append(cs);
        res.append('\n');
        if (this.children != null) {
            NodeHidden last = null;
            for (NodeHidden node : this.children) {
                if (last == null) {
                    last = node;
                    continue;
                }
                res.append(last.stringT(this, pref, ""));
                last = node;
            }
            if (last != null) {
                res.append(last.stringT(this, prefLast, prefLast));
            }
        }
        return res;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        return true;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        return true;
    }

    @Override
    public void setTreeScaleComputed(@NonNull Node callee) {
        if (!this.enabled) {
            return;
        }
        for (NodeHidden node : this.children) {
            node.setTreeScaleComputed(this);
        }
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return true;
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        if (!this.checkInputFreq(this.inputClock)) {
            res = false;
        }
        if (!this.checkOutputFreq(clock)) {
            res = false;
        }
        for (NodeHidden node : this.children) {
            if (node.compute(this, clock)) continue;
            res = false;
        }
        return res;
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        if (!this.enabled || !sendFreq) {
            for (NodeHidden node : this.children) {
                node.prepareAuto(this, false);
            }
            return null;
        }
        BigRational[] res = null;
        boolean check = true;
        for (NodeHidden node : this.children) {
            if (!check) {
                node.prepareAuto(this, false);
                continue;
            }
            BigRational[] tmpBRarr = node.prepareAuto(this, true);
            if (tmpBRarr == null) continue;
            if (res == null) {
                res = tmpBRarr;
                continue;
            }
            if (tmpBRarr[0].equals((Object)res[0])) {
                if (tmpBRarr[1].compareTo(res[1]) >= 0) continue;
                res[1] = tmpBRarr[1];
                continue;
            }
            res = null;
            check = false;
        }
        return res;
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        assert (this.children != null) : "Null children in node splitter node " + this.id;
        assert (this.children.size() > 0) : "Empty children in node splitter node " + this.id;
        EErrorType res = this.testInputFreq(clock);
        if (res != EErrorType.None) {
            return res;
        }
        this.inputClock = clock;
        res = this.testOutputFreq(clock);
        if (res != EErrorType.None) {
            return res;
        }
        this.lastComp = ECompState.OnceSatisfied;
        for (NodeHidden node : this.children) {
            EErrorType tmpRes = node.computeAutoWR(this, clock);
            if (tmpRes == EErrorType.None || tmpRes == EErrorType.NotEnabled) continue;
            if (res == EErrorType.TooFast || res == EErrorType.TooSlow) {
                if (tmpRes == EErrorType.TooFast && res == EErrorType.TooSlow) {
                    res = EErrorType.BothFastSlow;
                    continue;
                }
                if (tmpRes == EErrorType.TooSlow && res == EErrorType.TooFast) {
                    res = EErrorType.BothFastSlow;
                    continue;
                }
                if (tmpRes != EErrorType.BothFastSlow) continue;
                res = tmpRes;
                continue;
            }
            if (tmpRes != EErrorType.CannotSetup && res == EErrorType.CannotSetup) {
                res = tmpRes;
                continue;
            }
            if (res != EErrorType.None) continue;
            res = tmpRes;
        }
        if (res == EErrorType.None) {
            this.lastComp = ECompState.OnceSubtreeOK;
        }
        return res;
    }

    @Override
    public @Nullable BigRational getOutputClock() {
        return this.inputClock;
    }

    @Override
    public @Nullable BigRational getInputClock() {
        return this.inputClock;
    }

    @Override
    public void trackAutoWR(@NonNull Node callee) {
        if (!this.enabled) {
            return;
        }
        assert (this.children != null) : "Null children in node splitter node " + this.id;
        assert (this.children.size() > 0) : "Empty children in node splitter node " + this.id;
        for (Node node : this.children) {
            node.trackAutoWR(this);
        }
    }

    @Override
    public boolean getReversePath(@NonNull Node callee, @NonNull List<@NonNull Node> path) {
        assert (this.predecessors != null) : "Predecessors of " + this.id + " must be initilazed";
        assert (this.predecessors.size() == 1) : "More predecessors of " + this.id + " - cannot select path";
        path.add(this);
        return this.predecessors.get(0).getReversePath(this, path);
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node callee, @NonNull Node node) {
        assert (this.children != null) : "Null children in node splitter node " + this.id;
        assert (this.children.size() > 0) : "Empty children in node splitter node " + this.id;
        @NonNull ArrayList<@NonNull Node> res = new ArrayList<Node>();
        for (NodeHidden nd : this.children) {
            res.addAll(nd.getDirectlyConnectedTo(this, node));
        }
        if (this == node) {
            res.add(this);
        }
        return res;
    }

    @Override
    public void resetInputOutputClock() {
        this.inputClock = null;
    }
}

