/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.freertos.model;

import com.freescale.s32ds.debug.ka.KAPluginActivator;
import com.freescale.s32ds.debug.ka.controller.IStoreManager;
import com.freescale.s32ds.debug.ka.freertos.controller.FreeRTOSIStoreManager;
import com.freescale.s32ds.debug.ka.model.OSAbstractData;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class OSData
extends OSAbstractData {
    protected FreeRTOSIStoreManager storeManager;

    public OSData(IRunControl.IExecutionDMContext context, String name, FreeRTOSIStoreManager storeManager) {
        super(context, name, (IStoreManager)storeManager);
        this.storeManager = storeManager;
    }

    public static String sReadStringFromBufferBigEndian(String sValueList) {
        byte[] cChars = new byte[sValueList.length()];
        int i = 0;
        int iWordIndex = 0;
        boolean done = false;
        do {
            String sWord = sValueList.substring(iWordIndex, iWordIndex + 10);
            int iIndex = 2;
            while (iIndex < 10) {
                String sTemp = sWord.substring(iIndex, iIndex + 2);
                try {
                    cChars[i] = (byte)Integer.parseInt(sTemp, 16);
                    ++i;
                }
                catch (NumberFormatException e) {
                    KAPluginActivator.log((IStatus)new Status(4, "com.freescale.s32ds.viewer.freertos", "sReadStringFromBufferBigEndian: " + e.getMessage()));
                    sTemp = "00";
                }
                if (sTemp.equals("00")) {
                    done = true;
                    break;
                }
                iIndex += 2;
            }
            iWordIndex += 11;
        } while (!done);
        String sReturn = new String(cChars);
        return sReturn.substring(0, i - 1);
    }

    public boolean setValue(String sValueList) {
        this.saveValue();
        int iValueLocation = this.iOffsetIntoStruct / 4;
        this.sValue = sValueList.substring(iValueLocation *= 11, iValueLocation + 10);
        if (!this.storeManager.isBigEndian(this.context)) {
            this.sValue = OSData.sSwapHexWord((String)this.sValue);
        }
        return !this.sOriginal.equals(this.sValue);
    }
}

