/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.internal.registry.hardware;

import com.nxp.s32ds.cle.runtime.sdk.registry.hardware.CoreSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.hardware.CoreSdkRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class CoreSdkRegistryImplementation
extends BaseRegistry
implements CoreSdkRegistry {
    private final Map<String, Collection<CoreSdkDescriptor>> core2coreSdkDescriptors = new HashMap<String, Collection<CoreSdkDescriptor>>();
    private final Map<String, Collection<CoreSdkDescriptor>> sdk2coreSdkDescriptors = new HashMap<String, Collection<CoreSdkDescriptor>>();

    @Override
    public List<CoreSdkDescriptor> getCoreSdkDescriptorsByCoreId(String coreId) {
        return this.getReferenceDescriptorsBySourceId(coreId, this.core2coreSdkDescriptors, CoreSdkDescriptor.class);
    }

    @Override
    public List<CoreSdkDescriptor> getCoreSdkDescriptorsBySdkId(String sdkId) {
        return this.getReferenceDescriptorsByTargetId(sdkId, this.sdk2coreSdkDescriptors, CoreSdkDescriptor.class);
    }

    @Override
    public void addCoreSdkDescriptor(CoreSdkDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.core2coreSdkDescriptors, this.sdk2coreSdkDescriptors, CoreSdkDescriptor.class);
    }

    @Override
    public void removeCoreSdkDescriptor(CoreSdkDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.core2coreSdkDescriptors, this.sdk2coreSdkDescriptors, CoreSdkDescriptor.class);
    }

    @Override
    public void removeCoreSdkDescriptorsBySdkId(String sdkId) {
        Collection<CoreSdkDescriptor> collection = this.sdk2coreSdkDescriptors.get(sdkId);
        if (collection != null) {
            ArrayList<CoreSdkDescriptor> descriptors = new ArrayList<CoreSdkDescriptor>(collection);
            descriptors.forEach(this::removeCoreSdkDescriptor);
            descriptors.clear();
        }
    }

    @Override
    public List<CoreSdkDescriptor> getCoreSdkDescriptors() {
        ArrayList<CoreSdkDescriptor> result = new ArrayList<CoreSdkDescriptor>();
        this.core2coreSdkDescriptors.values().stream().flatMap(v -> v.stream()).forEach(result::add);
        return result;
    }
}

