/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.documentation;

import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.documentation.MigrationPropertyDocumentation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public class MigrationPropertyDocumentationImpl
implements MigrationPropertyDocumentation {
    private final Field field;
    private final MigrationPropertyAnnotation annotation;
    private final Class<?> type;
    private final Class<?> collectionType;

    public MigrationPropertyDocumentationImpl(Field field, MigrationPropertyAnnotation annotation) {
        this.field = field;
        this.annotation = annotation;
        this.type = field.getType();
        this.collectionType = this.isCollection() ? MigrationPropertyDocumentationImpl.fetchCollectionType(field.getGenericType()) : null;
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.type);
    }

    private static Class<?> fetchCollectionType(Type genericType) {
        ParameterizedType parameterizedType;
        Type actualType;
        if (genericType instanceof ParameterizedType && (actualType = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)actualType;
        }
        return null;
    }

    public String getName() {
        return "##default".equals(this.annotation.name()) ? this.field.getName() : this.annotation.name();
    }

    public String getDescription() {
        return this.annotation.description();
    }

    public int getMinOccurs() {
        return this.annotation.minOccurs();
    }

    public int getMaxOccurs() {
        if (this.annotation.maxOccurs() == Integer.MIN_VALUE) {
            if (this.isCollection()) {
                return -1;
            }
            return 1;
        }
        return this.annotation.maxOccurs();
    }

    public Field getPropertyField() {
        return this.field;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }
}

