/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.migration.internal.core.sequence;

import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.internal.core.EvaluationDiagnosticFactory;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.MigrationSequenceDescriptorElement;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.RegularAction;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.Sequence;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.SequenceAction;
import com.nxp.s32ds.cle.runtime.migration.internal.core.sequence.model.SubsequenceAction;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequence;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationStep;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MigrationSequenceImpl
implements MigrationSequence {
    private final Sequence sequence;
    private final MigrationSequenceDescriptorElement descriptor;

    public MigrationSequenceImpl(MigrationSequenceDescriptorElement descriptor, Sequence sequence) {
        this.descriptor = descriptor;
        this.sequence = sequence;
    }

    public MigrationSequenceDescriptorElement getDescriptor() {
        return this.descriptor;
    }

    public boolean match(IProject project, MigrationDiagnostic diagnostic) {
        return EvaluationDiagnosticFactory.evaluate(EvaluationDiagnosticFactory.createSequenceDiagnostic(diagnostic, this), d -> this.sequence.getAssertExpression().evaluate(project, (MigrationDiagnostic)d));
    }

    public List<MigrationStep> getMigrationSteps(IProject project, MigrationDiagnostic diagnostic) {
        return EvaluationDiagnosticFactory.evaluate(EvaluationDiagnosticFactory.createSequenceDiagnostic(diagnostic, this), d -> {
            ArrayList<MigrationStep> result = new ArrayList<MigrationStep>();
            List<SequenceAction> actions = this.sequence.getActions();
            int i = 0;
            while (i < actions.size()) {
                SequenceAction action = actions.get(i);
                if (action.match(project, (MigrationDiagnostic)d)) {
                    if (action instanceof SubsequenceAction) {
                        result.addAll(((SubsequenceAction)action).getMigrationSteps(project, (MigrationDiagnostic)d));
                    } else if (action instanceof RegularAction) {
                        result.add(new ActionStep(project, (RegularAction)action));
                    } else {
                        throw new IllegalStateException("Unknown action class " + action.getClass().getName());
                    }
                }
                ++i;
            }
            return result;
        });
    }

    private static class ActionStep
    implements MigrationStep {
        private final IProject project;
        private final RegularAction action;

        public ActionStep(IProject project, RegularAction action) {
            this.project = project;
            this.action = action;
        }

        public String getName() {
            return this.action.getDescriptor().getDocumentation().getName();
        }

        public void perform(IProgressMonitor monitor) throws CoreException {
            this.action.perform(this.project, monitor);
        }
    }
}

