/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.server.core;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.rcp.collateral.generator.html.HtmlGeneratorActivator;
import com.nxp.s32ds.rcp.collateral.server.core.Messages;
import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.Preferences;

public class CollateralServerSettings {
    public static final String SERVER_HOST = "localhost";
    public static final String SERVER_JOB_MESSAGE = "Starting Jetty Server";
    public static final String SERVER_RESOURCE_CONTEXT_PATH = "/res";
    public static final String SERVER_CONTENT_PATH = "content";
    public static final int PORT_NOT_DEF = -1;
    public static int port = -1;

    public static String getContentPath() {
        try {
            Path contentPath = CollateralServerSettings.createContentPath();
            CollateralServerSettings.validateContentPath(contentPath);
            return contentPath.toAbsolutePath().toString();
        }
        catch (CoreException e) {
            Log.log((IStatus)e.getStatus());
        }
        catch (IOException e) {
            Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", e.getMessage(), (Throwable)e);
            Log.log((IStatus)status);
        }
        return "";
    }

    public static int getPort() {
        if (port == -1) {
            port = CollateralServerSettings.findFreePort();
        }
        return port;
    }

    private static Path createContentPath() throws IOException {
        File bundleFolder = HtmlGeneratorActivator.getBundleFolder();
        Path contentPath = Paths.get(bundleFolder.getAbsolutePath(), String.valueOf(File.separator) + SERVER_CONTENT_PATH);
        return contentPath;
    }

    private static void validateContentPath(Path path) throws CoreException {
        if (!Files.isDirectory(path, new LinkOption[0]) || !Files.isReadable(path)) {
            Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", NLS.bind((String)Messages.NoAccessRightsToTheResource, null));
            throw new CoreException((IStatus)status);
        }
    }

    public static int findFreePort() {
        Preferences pref = Platform.getPreferencesService().getRootNode().node("instance").node("com.nxp.s32ds.rcp.collateral.server");
        int defPort = pref.getInt("port-def", 8087);
        int minPort = pref.getInt("port-min", 1027);
        int maxPort = pref.getInt("port-max", 49157);
        if (CollateralServerSettings.portIsFree(defPort)) {
            return defPort;
        }
        int i = minPort;
        while (i <= maxPort) {
            if (CollateralServerSettings.portIsFree(i)) {
                return i;
            }
            ++i;
        }
        Status status = new Status(2, "com.nxp.s32ds.rcp.collateral.server", NLS.bind((String)Messages.CouldntFindAnyFreePortBetween, (Object)minPort, (Object)maxPort));
        Log.log((IStatus)status);
        return -1;
    }

    /*
     * Loose catch block
     */
    private static boolean portIsFree(int port) {
        DatagramSocket datagramSocket;
        ServerSocket serverSocket;
        block14: {
            serverSocket = null;
            datagramSocket = null;
            serverSocket = new ServerSocket(port);
            serverSocket.setReuseAddress(true);
            datagramSocket = new DatagramSocket(port);
            datagramSocket.setReuseAddress(true);
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket == null) break block14;
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", NLS.bind((String)Messages.CanNotCloseSocketConnection, null));
                Log.log((IStatus)status);
            }
        }
        return true;
        catch (IOException iOException) {
            block15: {
                try {
                    Status status = new Status(1, "com.nxp.s32ds.rcp.collateral.server", NLS.bind((String)Messages.PortIsBusy, (Object)port));
                    Log.log((IStatus)status);
                    if (datagramSocket != null) {
                        datagramSocket.close();
                    }
                    if (serverSocket == null) break block15;
                }
                catch (Throwable throwable) {
                    if (datagramSocket != null) {
                        datagramSocket.close();
                    }
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException iOException2) {
                            Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", NLS.bind((String)Messages.CanNotCloseSocketConnection, null));
                            Log.log((IStatus)status);
                        }
                    }
                    throw throwable;
                }
                try {
                    serverSocket.close();
                }
                catch (IOException iOException3) {
                    Status status = new Status(4, "com.nxp.s32ds.rcp.collateral.server", NLS.bind((String)Messages.CanNotCloseSocketConnection, null));
                    Log.log((IStatus)status);
                }
            }
            return false;
        }
    }
}

