/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.resource.processors;

import com.nxp.s32ds.cle.ide.internal.sdk.core.IdeSdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.SdkResourceProcessor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

abstract class AbstractSdkResourceProcessor
implements SdkResourceProcessor {
    private static final String PRJ_FILES_BAK_EXTENSION = ".prjbak";
    private static final String SDK_FILES_BAK_EXTENSION = ".sdkbak";
    protected boolean isBackupFiles;
    protected SdkDescriptor sdk;

    AbstractSdkResourceProcessor() {
    }

    @Override
    public void folder(IFolder folder) {
        try {
            this.touchFolder(folder);
        }
        catch (CoreException ce) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to process folder {0}.", (Object)folder), ce);
        }
    }

    @Override
    public void file(IFile file, IPath path) {
        try {
            this.touchFile(file, path);
        }
        catch (IOException | CoreException e) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to process file {0}, {1}.", (Object)file, (Object)path), e);
        }
    }

    @Override
    public void file(IFile file, IPath path, boolean isOverride) {
        try {
            this.touchFile(file, path, isOverride);
        }
        catch (IOException | CoreException e) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to process file {0}, {1}.", (Object)file, (Object)path), e);
        }
    }

    public abstract void touchFolder(IFolder var1) throws CoreException;

    public abstract void touchFile(IFile var1, IPath var2) throws CoreException, IOException;

    public abstract void touchFile(IFile var1, IPath var2, boolean var3) throws CoreException, IOException;

    protected void createPRJBackupFile(IFile file) throws CoreException {
        String fileName = String.valueOf(file.getProjectRelativePath().lastSegment()) + PRJ_FILES_BAK_EXTENSION;
        file.move(AbstractSdkResourceProcessor.getBackupFile(file, fileName).getFullPath(), true, null);
    }

    protected void createSDKBackupFile(IFile file, IPath path) throws CoreException, IOException {
        String fileName = String.valueOf(file.getProjectRelativePath().lastSegment()) + SDK_FILES_BAK_EXTENSION;
        this.createFile(AbstractSdkResourceProcessor.getBackupFile(file, fileName), path);
    }

    protected void createFile(IFile file, IPath p) throws CoreException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream content = new BufferedInputStream(new FileInputStream(p.toOSString()));){
            file.create((InputStream)content, true, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static IFile getBackupFile(IFile file, String backupFilenamePrefix) {
        IFile backupFile = null;
        IContainer parent = file.getParent();
        int counter = 0;
        while ((backupFile = parent.getFile((IPath)new Path(String.valueOf(backupFilenamePrefix) + counter++))).exists()) {
        }
        return backupFile;
    }
}

