/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.actions;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.S32GlobalVariablesMessages;
import com.nxp.s32ds.debug.ide.global.variables.actions.ActionsUtil;
import com.nxp.s32ds.debug.ide.global.variables.gdb.control.GlobalVariablesService;
import com.nxp.s32ds.debug.ide.global.variables.gdb.control.S32DSGlobalVariablesManager;
import java.util.Collections;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RemoveAllGlobalVariablesAction
extends Action {
    public static final String ACTION_ID = String.valueOf(Activator.getInstance().getBundleId()) + ".remove.all.global.variables.action";
    private IDebugView fDebugView;

    public RemoveAllGlobalVariablesAction(AbstractDebugView view) {
        super(S32GlobalVariablesMessages.RemoveAllGlobalVariablesAction_Name, 1);
        this.fDebugView = view;
        this.setToolTipText(S32GlobalVariablesMessages.RemoveAllGlobalVariablesAction_Name);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVEALL"));
        this.setId(ACTION_ID);
    }

    public void run() {
        Shell activeShell = Display.getDefault().getActiveShell();
        if (!MessageDialog.openQuestion((Shell)activeShell, (String)S32GlobalVariablesMessages.RemoveAllGlobalVariables_title, (String)S32GlobalVariablesMessages.RemoveAllGlobalVariables_message)) {
            return;
        }
        String sessionId = ActionsUtil.getCurrentSessionId(this.fDebugView);
        if (sessionId.isEmpty()) {
            return;
        }
        S32DSGlobalVariablesManager.getInstance().getGlobalVariablesService(sessionId).addGlobalVariableInToShowList(Collections.emptyList());
        this.setEnabled(false);
        this.fDebugView.getViewer().refresh();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            String sessionId = ActionsUtil.getCurrentSessionId(this.fDebugView);
            if (sessionId.isEmpty()) {
                super.setEnabled(false);
                return;
            }
            GlobalVariablesService globalVariablesService = S32DSGlobalVariablesManager.getInstance().getGlobalVariablesService(sessionId);
            if (globalVariablesService == null || globalVariablesService.getGlobalVariables().isEmpty() || globalVariablesService.getGlobalVariablesToShow().isEmpty()) {
                super.setEnabled(false);
                return;
            }
        }
        super.setEnabled(enabled);
    }
}

