/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.gdb.control;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.AlphabeticalOrderComparator;
import com.nxp.s32ds.debug.ide.global.variables.S32GlobalVariablesMessages;
import com.nxp.s32ds.debug.ide.global.variables.gdb.control.IGlobalVariablesService;
import com.nxp.s32ds.debug.ide.global.variables.gdb.control.S32DSGlobalVariablesManager;
import com.nxp.s32ds.debug.ide.global.variables.memento.GlobalVariablesToShowMemento;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableModel;
import com.nxp.s32ds.debug.ide.global.variables.model.IGlobalVariablesResult;
import com.nxp.s32ds.debug.ide.global.variables.model.LegacyInfoVariablesCommand;
import com.nxp.s32ds.debug.ide.global.variables.model.MiInfoVariableCommand;
import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class GlobalVariablesService
extends AbstractDsfService
implements IGlobalVariablesService {
    private List<GlobalVariableModel> globalVariables;
    private Set<GlobalVariableModel> globalVariablesToShow = new TreeSet<GlobalVariableModel>(new AlphabeticalOrderComparator());
    private Map<String, SortedSet<GlobalVariableModel>> path2globalVariable;
    private boolean refreshNeed = false;
    private IMICommandControl commandControl;
    private boolean isInitialized = false;
    private String gdbVersion = "";

    public GlobalVariablesService(DsfSession session) {
        this(session, true);
    }

    public GlobalVariablesService(DsfSession session, boolean addDsfListener) {
        super(session);
        S32DSGlobalVariablesManager.getInstance().addGlobalVaraiblesForThisSession(this, session.getId());
        if (addDsfListener) {
            session.addServiceEventListener((Object)this, null);
        }
        try {
            this.gdbVersion = ((GdbLaunch)this.getSession().getModelAdapter(ILaunch.class)).getGDBVersion();
        }
        catch (CoreException e) {
            Activator.getInstance().log(e.getStatus());
        }
    }

    protected BundleContext getBundleContext() {
        return Activator.getBundleContext();
    }

    public void initialize(final RequestMonitor rm) {
        if (this.isInitialized) {
            return;
        }
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GlobalVariablesService.this.register(new String[]{GlobalVariablesService.class.getName()}, new Hashtable());
                GlobalVariablesService.this.commandControl = (IMICommandControl)GlobalVariablesService.this.getServicesTracker().getService(IMICommandControl.class);
                GlobalVariablesService.this.isInitialized = true;
                rm.done();
            }
        });
    }

    public void shutdown(RequestMonitor rm) {
        this.saveToMemento();
        this.commandControl = null;
        this.unregister();
        super.shutdown(rm);
    }

    @Override
    public List<GlobalVariableModel> getGlobalVariables() {
        return this.globalVariables == null ? Collections.emptyList() : this.globalVariables;
    }

    @Override
    public void requestGlobalVariables(DataRequestMonitor<IGlobalVariablesResult> rm) {
        if (this.getExecutor().isInExecutorThread()) {
            this.getProgramsGlobalVariables(rm);
        } else {
            this.getExecutor().execute(() -> this.getProgramsGlobalVariables(rm));
        }
    }

    @ConfinedToDsfExecutor(value="getExecutor()")
    private void getProgramsGlobalVariables(DataRequestMonitor<IGlobalVariablesResult> rm) {
        if (this.commandControl == null) {
            return;
        }
        String elfPath = "";
        try {
            elfPath = ((GdbLaunch)this.getSession().getModelAdapter(ILaunch.class)).getProgramPath();
            elfPath = Path.fromOSString((String)elfPath).toFile().getParent();
        }
        catch (CoreException e) {
            Activator.getInstance().log(e.getStatus());
        }
        MICommand infoVariableCommand = ModuleDescriptor.Version.parse(this.gdbVersion).compareTo(ModuleDescriptor.Version.parse("9.1")) >= 0 ? new MiInfoVariableCommand((IDMContext)this.commandControl.getContext()) : new LegacyInfoVariablesCommand((IDMContext)this.commandControl.getContext(), elfPath);
        ImmediateDataRequestMonitor<IGlobalVariablesResult> requestMonitor = new ImmediateDataRequestMonitor<IGlobalVariablesResult>(rm){

            protected void handleSuccess() {
                if (this.getData() != null && GlobalVariablesService.this.getGlobalVariables().isEmpty()) {
                    GlobalVariablesService.this.globalVariables = ((IGlobalVariablesResult)((Object)this.getData())).getGlobalVariables();
                    GlobalVariablesService.this.path2globalVariable = ((IGlobalVariablesResult)((Object)this.getData())).getPath2GlobalVariables();
                    if (!GlobalVariablesService.this.globalVariables.isEmpty()) {
                        GlobalVariablesService.this.globalVariablesToShow.addAll(GlobalVariablesService.this.restoreFromMemento(GlobalVariablesService.this.globalVariables));
                    }
                }
                super.handleSuccess();
            }
        };
        this.commandControl.queueCommand((ICommand)infoVariableCommand, (DataRequestMonitor)requestMonitor);
    }

    @Override
    public Map<String, SortedSet<GlobalVariableModel>> getPath2GlobalVariables() {
        return this.path2globalVariable == null ? Collections.emptyMap() : this.path2globalVariable;
    }

    @Override
    public boolean needRefresh() {
        boolean refresh = this.refreshNeed;
        this.refreshNeed = false;
        return refresh;
    }

    @Override
    public List<GlobalVariableModel> getGlobalVariablesToShow() {
        return this.globalVariablesToShow == null ? Collections.emptyList() : new ArrayList<GlobalVariableModel>(this.globalVariablesToShow);
    }

    @Override
    public void addGlobalVariableInToShowList(List<GlobalVariableModel> globalVariable) {
        if (globalVariable == null) {
            return;
        }
        this.refreshNeed = this.globalVariablesToShow.size() != globalVariable.size() || !this.globalVariablesToShow.containsAll(globalVariable);
        this.globalVariablesToShow.clear();
        this.globalVariablesToShow.addAll(globalVariable);
    }

    @Override
    public void setNeedRefresh() {
        this.refreshNeed = true;
    }

    private void saveToMemento() {
        String launchConfigurationName = this.getLaunchConfigurationName();
        if (launchConfigurationName.isEmpty()) {
            Activator.getInstance().logError(S32GlobalVariablesMessages.GlobalVariableServices_There_no_mapped_launch_for_dsf_session);
            return;
        }
        if (this.globalVariablesToShow.isEmpty()) {
            new GlobalVariablesToShowMemento(launchConfigurationName).removeMemento();
        } else {
            new GlobalVariablesToShowMemento(launchConfigurationName).saveToMemento(this.globalVariablesToShow);
        }
    }

    private Collection<GlobalVariableModel> restoreFromMemento(Collection<GlobalVariableModel> allVariables) {
        String launchConfigurationName = this.getLaunchConfigurationName();
        if (launchConfigurationName.isEmpty()) {
            Activator.getInstance().logError("There no launch config asociated with this DSFSession");
            return Collections.emptyList();
        }
        return (Collection)new GlobalVariablesToShowMemento(launchConfigurationName).restoreFromMemento(allVariables);
    }

    private String getLaunchConfigurationName() {
        Object launch = this.getSession().getModelAdapter(ILaunch.class);
        if (launch instanceof ILaunch) {
            ILaunchConfiguration launchConfiguration = ((ILaunch)launch).getLaunchConfiguration();
            return launchConfiguration.getName();
        }
        return "";
    }

    @DsfServiceEventHandler
    public void handleSuspendEvent(IRunControl.ISuspendedDMEvent event) {
        if (this.getGlobalVariables().isEmpty()) {
            this.requestGlobalVariables((DataRequestMonitor<IGlobalVariablesResult>)new DataRequestMonitor((Executor)this.getExecutor(), null));
        }
    }

    public void removeFromToShowByName(String expression) {
        this.globalVariablesToShow = this.globalVariablesToShow.stream().filter(expression.matches("^'.*'::.*$") ? this.filterByNameAndPath(expression) : this.filterByName(expression)).collect(Collectors.toCollection(() -> new TreeSet<GlobalVariableModel>(new AlphabeticalOrderComparator())));
        this.refreshNeed = true;
    }

    private Predicate<? super GlobalVariableModel> filterByName(String expression) {
        return model -> !model.getName().equals(expression);
    }

    private Predicate<? super GlobalVariableModel> filterByNameAndPath(String expression) {
        String[] splitExpression = expression.split("::", 2);
        return model -> !model.getName().equals(splitExpression[1]) && !model.getFilePath().toOSString().equals(splitExpression[0]);
    }
}

