/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.model;

import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableModel;
import org.eclipse.core.runtime.IPath;

public class GlobalVariableImpl
implements GlobalVariableModel,
Comparable<GlobalVariableImpl> {
    private final String gVarName;
    private final String gVarType;
    private final IPath gVarPath;
    private final int gVarLineNumber;
    private final String gVarDescription;

    public GlobalVariableImpl(String name, IPath filePath, String type, int lineNumer, String description) {
        this.gVarName = name;
        this.gVarPath = filePath;
        this.gVarType = type;
        this.gVarLineNumber = lineNumer;
        this.gVarDescription = description;
    }

    @Override
    public String getName() {
        return this.gVarName;
    }

    @Override
    public IPath getFilePath() {
        return this.gVarPath;
    }

    @Override
    public int getLineNumber() {
        return this.gVarLineNumber;
    }

    @Override
    public String getType() {
        return this.gVarType;
    }

    @Override
    public String getDescription() {
        return this.gVarDescription;
    }

    @Override
    public int compareTo(GlobalVariableImpl globalVariable) {
        int pathCompare = this.gVarPath.toOSString().compareToIgnoreCase(globalVariable.getFilePath().toOSString());
        return pathCompare == 0 ? this.gVarName.compareTo(globalVariable.gVarName) : pathCompare;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GlobalVariableImpl)) {
            return false;
        }
        GlobalVariableImpl globalVariable = (GlobalVariableImpl)object;
        boolean isSamePath = this.gVarPath.toOSString().equals(globalVariable.getFilePath().toOSString());
        return isSamePath ? this.gVarName.equals(globalVariable.getName()) : isSamePath;
    }

    public int hashCode() {
        return this.gVarPath.toOSString().hashCode() + this.gVarLineNumber + this.gVarName.hashCode();
    }

    public String toString() {
        return "GlobalVariableImpl [gVarName=" + this.gVarName + ", gVarType=" + this.gVarType + ", gVarPath=" + this.gVarPath + ", gVarLineNumber=" + this.gVarLineNumber + ", gVarDescription=" + this.gVarDescription + "]";
    }
}

