/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.model;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.S32GlobalVariablesMessages;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableImpl;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableModel;
import com.nxp.s32ds.debug.ide.global.variables.model.IGlobalVariablesResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MiGlobalVariablesResult
extends IGlobalVariablesResult {
    private static final String SYMBOLS = "symbols";
    private static final String DEBUG = "debug";
    private static final String FULLNAME = "fullname";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private static final String LINE = "line";
    private List<GlobalVariableModel> globalVariables;
    private HashMap<String, SortedSet<GlobalVariableModel>> path2globalVariable;

    public MiGlobalVariablesResult(MIOutput record) {
        super(record);
        this.parseOutput();
    }

    private void parseOutput() {
        MIResult[] miResults;
        this.globalVariables = new ArrayList<GlobalVariableModel>();
        this.path2globalVariable = new HashMap();
        MIResultRecord miResultRecord = this.getMIOutput().getMIResultRecord();
        MIResult[] mIResultArray = miResults = miResultRecord.getMIResults();
        int n = miResults.length;
        int n2 = 0;
        while (n2 < n) {
            MIResult result = mIResultArray[n2];
            if (result.getVariable().equalsIgnoreCase(SYMBOLS)) {
                this.addVariablesInGlobalVariables(result);
            }
            ++n2;
        }
    }

    private void addVariablesInGlobalVariables(MIResult result) {
        MIValue resultValue = result.getMIValue();
        if (!(resultValue instanceof MITuple)) {
            return;
        }
        MITuple resultTuple = (MITuple)resultValue;
        MIValue debugMIValue = resultTuple.getField(DEBUG);
        if (!(debugMIValue instanceof MIList)) {
            return;
        }
        MIList varsList = (MIList)debugMIValue;
        MIValue[] mIValueArray = varsList.getMIValues();
        int n = mIValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIValue var = mIValueArray[n2];
            if (var instanceof MITuple) {
                this.addGlobalVariableFromFile((MITuple)var);
            }
            ++n2;
        }
    }

    private void addGlobalVariableFromFile(MITuple varTuple) {
        MIValue fullname = varTuple.getField(FULLNAME);
        MIValue symbols = varTuple.getField(SYMBOLS);
        String filenameString = "";
        if (fullname instanceof MIConst) {
            filenameString = new Path(((MIConst)fullname).getCString()).toOSString();
        }
        if (!(symbols instanceof MIList)) {
            return;
        }
        MIValue[] mIValueArray = ((MIList)symbols).getMIValues();
        int n = mIValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIValue miValueVars = mIValueArray[n2];
            if (miValueVars instanceof MITuple) {
                try {
                    if (!((MITuple)miValueVars).getField(TYPE).toString().equals(S32GlobalVariablesMessages.GlobalVar_Exception)) {
                        GlobalVariableModel globalVariableModel = this.createGlobalVariable((MITuple)miValueVars, filenameString);
                        this.globalVariables.add(globalVariableModel);
                        if (!this.path2globalVariable.containsKey(filenameString)) {
                            this.path2globalVariable.put(filenameString, new TreeSet());
                        }
                        this.path2globalVariable.get(filenameString).add(globalVariableModel);
                    }
                }
                catch (Exception e) {
                    Activator.getInstance().logError(e.getMessage(), e);
                }
            }
            ++n2;
        }
    }

    private GlobalVariableModel createGlobalVariable(MITuple varTuple, String filePath) {
        String varName = ((MIConst)varTuple.getField(NAME)).getCString();
        String varDescription = ((MIConst)varTuple.getField(DESCRIPTION)).getCString();
        String varType = ((MIConst)varTuple.getField(TYPE)).getCString();
        String line = "-1";
        if ((MIConst)varTuple.getField(LINE) != null) {
            line = ((MIConst)varTuple.getField(LINE)).getCString();
        }
        return new GlobalVariableImpl(varName, (IPath)new Path(filePath), varType, Integer.parseInt(line), varDescription);
    }

    @Override
    public List<GlobalVariableModel> getGlobalVariables() {
        return this.globalVariables;
    }

    @Override
    public Map<String, SortedSet<GlobalVariableModel>> getPath2GlobalVariables() {
        return this.path2globalVariable;
    }
}

