/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.commanderview;

import com.freescale.s32ds.cdt.core.internal.commanderview.Activator;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.CommandManager;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.ContextManager;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.Messages;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;

public class KeyBindingHandler
extends AbstractHandler {
    private String id;

    public KeyBindingHandler() {
    }

    public KeyBindingHandler(String id) {
        this.id = id;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Map<String, ?> ctx;
            Object var;
            Object context = event.getApplicationContext();
            if (!(context instanceof IEvaluationContext)) {
                KeyBindingHandler.throwInternalError();
            }
            if (!((var = ((IEvaluationContext)context).getVariable("activeWorkbenchWindow")) instanceof IWorkbenchWindow)) {
                KeyBindingHandler.throwInternalError();
            }
            IWorkbenchWindow window = (IWorkbenchWindow)var;
            CommandManager.Command cmd = KeyBindingHandler.getCommand(event);
            if (cmd == null || cmd.handler == null) {
                KeyBindingHandler.throwInternalError();
            }
            if (!cmd.handler.isEnabled(ctx = this.getContext(window, cmd))) {
                throw new CoreException((IStatus)new Status(2, "com.freescale.s32ds.cdt.core.commanderview", Messages.KeyBindingHandler_commandDisabled));
            }
            cmd.handler.execute(ctx);
        }
        catch (CoreException e) {
            throw new ExecutionException(null, (Throwable)e);
        }
        return null;
    }

    protected Map<String, ?> getContext(IWorkbenchWindow window, CommandManager.Command cmd) {
        Map<String, ?> ctx = ContextManager.getManager(window).createContext(cmd);
        return ctx;
    }

    protected String getId() {
        return this.id;
    }

    public void setEnabled(Object evaluationContext) {
        IEvaluationContext context;
        Object object;
        if (this.id == null) {
            return;
        }
        boolean enabled = false;
        if (evaluationContext instanceof IEvaluationContext && (object = (context = (IEvaluationContext)evaluationContext).getVariable("activeWorkbenchWindow")) instanceof IWorkbenchWindow) {
            CommandManager.Command cmd = CommandManager.getInstance().getCommandWithKeyBindingCmdId(this.id);
            Map<String, ?> ctx = this.getContext((IWorkbenchWindow)object, cmd);
            enabled = cmd.handler.isEnabled(ctx);
        }
        this.setBaseEnabled(enabled);
    }

    private static CommandManager.Command getCommand(ExecutionEvent event) {
        String id;
        CommandManager cmdManager = CommandManager.getInstance();
        CommandManager.Command cmd = cmdManager.getCommandWithKeyBindingCmdId(id = event.getCommand().getId());
        if (cmd == null) {
            Activator.log(4, MessageFormat.format(Messages.KeyBindingHandler_failedCommandLookup, id), null);
            Object trigger = event.getTrigger();
            if (trigger instanceof Event) {
                cmd = cmdManager.getCommandWithKeyBinding(((Event)trigger).character);
            }
        }
        return cmd;
    }

    private static void throwInternalError() throws CoreException {
        throw new CoreException((IStatus)new Status(4, "com.freescale.s32ds.cdt.core.commanderview", Messages.KeyBindingHandler_internalError));
    }
}

