/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.consts;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.ComponentType;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.osgi.framework.Version;

@NonNullByDefault
public class SdkConsts {
    public static final String ROOT_TAG = "manifest";
    public static final String ROOT_TAG_WITH_NAMESPACE = "ksdk:manifest";
    public static final String KSDK_FORMAT_VERSION_ATTR = "format_version";
    public static final String SDK_CONFIGURATION_HASH_ATTR = "configuration";
    public static final String KSDK_TAG = "ksdk";
    public static final String VERSION_ATTR = "version";
    public static final String ID_ATTR = "id";
    public static final String ID_REF_ATTR = "id_ref";
    public static final String ID_REFS_ATTR = "id_refs";
    public static final String TYPE_ATTR = "type";
    public static final String USER_NAME_ATTR = "user_name";
    public static final String FULL_NAME_ATTR = "full_name";
    public static final String FOR_ATTR = "for";
    public static final String API_TAG = "api";
    public static final String API_VERSION_ATTR = "api_version";
    public static final String NAME_TAG = "name";
    public static final String VALUE_ATTR = "value";
    public static final String DESCRIPTION_ATTR = "description";
    public static final String BRIEF_ATTR = "brief";
    public static final String DEVICE_CORE_ATTR = "device_core";
    public static final String DEVICE_CORES_ATTR = "device_cores";
    public static final String LINKED_PROJECT_ATTR = "linked_projects";
    public static final String SECTION_TOOLS_TAG = "tools";
    public static final String TOOL_TAG = "tool";
    public static final String SECTION_COMPILERS_TAG = "compilers";
    public static final String COMPILER_TAG = "compiler";
    public static final String COMPILER_ATTR = "compiler";
    public static final String SECTION_TOOLCHAINS_TAG = "toolchains";
    public static final String SECTION_TOOLCHAIN_SETTINGS_TAG = "toolchainSettings";
    public static final String TOOLCHAIN_TAG = "toolchain";
    public static final String TOOLCHAIN_ATTR = "toolchain";
    public static final String TOOLCHAIN_SETTING_TAG = "toolchainSetting";
    public static final String SECTION_DEVICES_TAG = "devices";
    public static final String DEVICE_TAG = "device";
    public static final String DEVICE_ATTR = "device";
    public static final String DEVICES_ATTR = "devices";
    public static final String DEVICE_FULL_NAME_ATTR = "full_name";
    public static final String SECTION_COMPONENTS_TAG = "components";
    public static final String COMPONENT_TAG = "component";
    public static final String COMP_CATEGORY_ATTR = "category";
    public static final String SECTION_BOARDS_TAG = "boards";
    public static final String BOARD_TAG = "board";
    public static final String SECTION_BRD_EXAMPLES_TAG = "examples";
    public static final String BOARDS_SUBDIR = "boards";
    public static final String EXAMPLE_TAG = "example";
    public static final String EXMPL_CATEGORY_ATTR = "category";
    public static final String EXMPL_BOARD_ATTR = "board";
    public static final String EXMPL_DEVICE_ATTR = "device";
    public static final String EXMPL_DEFINITION_TAG = "definition";
    public static final String EXMPL_DEF_EXTID_ATTR = "extID";
    public static final String PATH_ATTR = "path";
    public static final String PACKAGE_BASE_PATH_ATTR = "package_base_path";
    public static final String PROJECT_BASE_PATH_ATTR = "project_base_path";
    public static final String RELATIVE_PATH_ATTR = "relative_path";
    public static final String PROJECT_RELATIVE_PATH_ATTR = "project_relative_path";
    public static final String SOURCE_TAG = "source";
    public static final String SOURCE_TGT_PATH_ATTR = "target_path";
    public static final String SOURCE_TYPE_ATTR = "type";
    public static final String SRC_FILES_TAG = "files";
    public static final String SRC_FILES_MASK_ATTR = "mask";
    public static final String SRC_FILES_GENERATED_ATTR = "generated_during_build";
    public static final String SRC_FILES_CONFIG_ATTR = "config";
    public static final String SRC_FILES_TEMPLATE_ATTR = "template";
    public static final String TAG_CONTENT_VERSION_ATTR = "version";
    public static final String TAG_CONTENT_REVISION_ATTR = "revision";
    public static final String DEPENDENCY_ATTR = "dependency";
    public static final String DEFINES_TAG = "defines";
    public static final String DEFINE_TAG = "define";
    public static final String PRIMARY_CORE_DEFINE = "SDK_PRIMARY_CORE";
    public static final String SECONDARY_CORE_DEFINE = "SDK_SECONDARY_CORE";
    public static final String TOOLCHAIN_ID_KDS = "kds";
    public static final String DEPRECATED_TOOLCHAIN_ID_ATOLLIC = "atl";
    public static final String TOOLCHAIN_ID_IAR_EW = "iar";
    public static final String TOOLCHAIN_ID_MDK_uVISION = "mdk";
    public static final String TOOLCHAIN_ID_DSMDK = "dsmdk";
    public static final String TOOLCHAIN_ID_ARMGCC = "armgcc";
    public static final String TOOLCHAIN_ID_CW_MCU = "cwmcu";
    public static final String TOOLCHAIN_ID_MCUXPRESSO = "mcuxpresso";
    public static final String TOOLCHAIN_ID_XTENSA = "xtensa";
    public static final String TOOLCHAIN_ID_XCC = "xcc";
    public static final String TOOLCHAIN_ID_CSOLUTION = "cbuild.csolution";
    public static final String TOOLCHAIN_FOLDER_CW_MCU = "codewarrior";
    public static final List<@NonNull String> TOOLCHAIN_IDS_ORDERED = Arrays.asList("iar", "mdk", "dsmdk", "armgcc", "cwmcu", "cbuild.csolution", "mcuxpresso", "kds", "xtensa", "xcc");
    public static final String HEADER_FILE_EXTENSION = ".h";
    public static final String C_FILE_EXTENSION = ".c";
    public static final String CPP_FILE_EXTENSION = ".cpp";
    public static final String ASM_FILE_EXTENSION = ".s";
    public static final String ELF_FILE_EXTENSION = ".elf";
    public static final String TXT_FILE_EXTENSION = ".txt";
    public static final String PDF_FILE_EXTENSION = ".pdf";
    public static final String HTM_FILE_EXTENSION = ".htm";
    public static final String HTML_FILE_EXTENSION = ".html";
    public static final String GCC_LIB_FILE_EXTENSION = ".a";
    public static final String MDK_LIB_FILE_EXTENSION = ".lib";
    public static final String OBJECT_FILE_EXTENSION = ".o";
    public static final String GCC_CMAKE_FILE_EXTENSION = ".cmake";
    public static final String GCC_CMAKE_FILE_COMMENTOUT_LINE = "#";
    public static final String SDK_DRIVER_COMPNT_TYPE = ComponentType.DRIVER.getSdkCompType();
    public static final String SDK_CMSISDRV_COMPNT_TYPE = ComponentType.CMSIS_DRIVER.getSdkCompType();
    public static final String SDK_UTILITIES_COMPNT_TYPE = ComponentType.UTILITY.getSdkCompType();
    public static final String SDK_MIDDLEWARE_COMPNT_TYPE = ComponentType.MIDDLEWARE.getSdkCompType();
    public static final String SDK_PRJTEMPL_COMPNT_TYPE = "project_template";
    public static final Function<? super SdkDeviceDescriptor, ? extends String> SDK_DEVICE_PRJTEMPL_COMPNT_ID_FORMATER = dev -> MessageFormat.format("project_template.{0}.{0}", dev.getName());
    public static final String SDK_RTOS_COMPNT_TYPE = "OS";
    public static final String SDK_RTOS_BAREMETAL_COMPNAME = "baremetal";
    public static final String SDK_RTOS_FREERTOS_COMPNAME = "freertos";
    public static final String SDK_CMSIS_COMPNT_TYPE = "CMSIS";
    public static final String SDK_CMSIS_INCL_COMPNT_TYPE = "CMSIS_Include";
    public static final String SDK_STARTUP_COMPNT_TYPE = "startup";
    public static final String SDK_LINKER_COMPNT_TYPE = "linker";
    public static final String SDK_LINKER_COMPNT_VARIANT = "flash";
    public static final String SDK_OTHER_COMPNT_TYPE = "other";
    public static final String SDK_BOARD_COMPNT_TYPE = ComponentType.BOARD_COMPONENT.getId();
    public static final String SDK_SOFTWARE_COMPNT_TYPE = ComponentType.SOFTWARE_COMPONENT.getId();
    public static final String SDK_ABSTRACT_LAYER_COMPNT_TYPE = ComponentType.ABSTRACTION_LAYER.getId();
    public static final String C_INCLUDE_SRC_TYPE = "c_include";
    public static final String C_PREINCLUDE_SRC_TYPE = "c_preinclude";
    public static final String C_CPP_SRC_TYPE = "src";
    public static final String C_SRC_TYPE = "src_c";
    public static final String CPP_SRC_TYPE = "src_cpp";
    public static final String ASM_INCLUDE_SRC_TYPE = "asm_include";
    public static final String LIBRARY_SRC_TYPE = "lib";
    public static final String DOC_SRC_TYPE = "doc";
    public static final String CFG_SRC_TYPE = "configuration";
    public static final String WORKSPACE_TYPE = "workspace";
    public static final List<@NonNull String> EXAMPLE_SRC_TYPES_IN_PROJECT = Arrays.asList("src_c", "src_cpp", "src", "c_include", "asm_include", "c_preinclude");
    public static final List<@NonNull String> COMPONENT_SRC_TYPES_IN_PROJECT = Arrays.asList("src_c", "src_cpp", "src", "asm_include");
    public static final String[] ALL_SRC_TYPES = new String[]{"src", "c_include", "asm_include", "doc", "configuration", "lib"};
    public static final String LINKER_SRC_TYPE = "linker";
    public static final String MACRO_LEADINGCHAR_STR = "$";
    public static final String MACRO_PREFIX_VRNT_PIPE = "$|";
    public static final String MACRO_SUFFIX_VRNT_PIPE = "|";
    public static final String MACRO_PREFIX_VRNT_BRCKT = "$[";
    public static final String MACRO_SUFFIX_VRNT_BRCKT = "]";
    public static final String MACRO_PG_LONG_NAME = "pg_long_name";
    public static final String MACRO_PG_VERSION = "pg_version";
    public static final String MACRO_GENER_DATE = "generated_date";
    public static final String MACRO_GENER_TIME = "generated_time";
    public static final String MACRO_DEVICE = "device";
    public static final String MACRO_PRJ_NAME = "project_name";
    public static final String MACRO_PRJ_NAME_BRCKTD = "$[project_name]";
    public static final String MACRO_PRJ_NAME_PIPE = "$|project_name|";
    public static final String MACRO_CMSIS_PCK_NAME = "CMSIS_pack_name";
    public static final String MACRO_CMSIS_LANG_NAME = "CMSIS_language_name";
    public static final String MACRO_CMSIS_LANG_VERSION = "CMSIS_language_version";
    public static final String MACRO_CONFIGURATION = "configuration";
    public static final String DEBUG_CONFIGURATION_NAME = "Debug";
    public static final String RELEASE_CONFIGURATION_NAME = "Release";
    public static final String DEBUG_SUBDIR = "debug";
    public static final String RELEASE_SUBDIR = "release";
    public static final Version MANIFEST_FORMAT_VERSION_3_0 = new Version(3, 0, 0);
    public static final Version MANIFEST_FORMAT_VERSION_3_4 = new Version(3, 4, 0);
    public static final Version MANIFEST_FORMAT_VERSION_3_6 = new Version(3, 6, 0);
    public static final Version MANIFEST_FORMAT_VERSION_3_8 = new Version(3, 8, 0);
    public static final Version MANIFEST_FORMAT_VERSION_3_10 = new Version(3, 10, 0);
    public static final Version MANIFEST_FORMAT_VERSION_3_13 = new Version(3, 13, 0);

    public static boolean isDocFileExtension(String ext) {
        return TXT_FILE_EXTENSION.equalsIgnoreCase(ext) || PDF_FILE_EXTENSION.equalsIgnoreCase(ext) || HTM_FILE_EXTENSION.equalsIgnoreCase(ext) || HTML_FILE_EXTENSION.equalsIgnoreCase(ext);
    }
}

