/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.descriptors.ASdkProjectExample;
import com.nxp.swtools.sdkmanifest.descriptors.SdkComponentDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDevicesDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkSourceFile;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

@NonNullByDefault
public class SdkDeviceProjectTemplate
extends ASdkProjectExample {
    static final String SDK_PROJECT_FOLDER = "project_template";
    private SdkDeviceDescriptor parentProcessor;

    private static SdkDeviceDescriptor getComponentProcessor(SdkComponentDescriptor prjTemp) {
        SdkDevicesDescriptor desc = prjTemp.devicesDescr;
        assert (desc != null);
        Collection<@NonNull String> devIds = prjTemp.getDevices();
        assert (devIds != null);
        assert (devIds.size() == 1);
        String devId = (String)CollectionsUtils.first(devIds);
        SdkDeviceDescriptor dev = desc.getSdkDeviceDescriptorById(devId);
        assert (dev != null);
        return dev;
    }

    private static @Nullable String getComponentDeviceCore(SdkComponentDescriptor prjTemp) {
        Set<@NonNull String> cores = prjTemp.getDeviceCores();
        if (cores != null) {
            if (cores.size() > 1) {
                LOGGER.severe(MessageFormat.format("[SDK] Project template component '{0}' specifies more that one core: {1}", prjTemp.getId(), cores));
            }
            return (String)CollectionsUtils.firstOrNull(cores);
        }
        return null;
    }

    private static String getComponentPath(SdkComponentDescriptor prjTemp) {
        return "devices" + File.separator + SdkDeviceProjectTemplate.getComponentProcessor(prjTemp).getName() + File.separator + SDK_PROJECT_FOLDER;
    }

    public SdkDeviceProjectTemplate(SdkComponentDescriptor prjTemp) {
        super(prjTemp.getId(), prjTemp.getName(), UtilsText.safeString((String)prjTemp.getCategory()), SdkDeviceProjectTemplate.getComponentPath(prjTemp), prjTemp.getBrief(), new ArrayList<SdkSourceFile>(prjTemp.getSources()), prjTemp.getIncludePaths().isEmpty() ? null : prjTemp.getIncludePaths(), prjTemp.getDependencySet(), prjTemp.getDevices(), prjTemp.getToolchains(), prjTemp.getCompilers(), SdkDeviceProjectTemplate.getComponentDeviceCore(prjTemp), ASdkProjectExample.ProjectExampleType.DEVICE_PROJECT_TEMPLATE);
        this.parentProcessor = SdkDeviceProjectTemplate.getComponentProcessor(prjTemp);
        assert (SDK_PROJECT_FOLDER.equals(prjTemp.getType()));
    }

    @Override
    public @NonNull SdkDeviceDescriptor getParentProcessor() {
        return this.parentProcessor;
    }

    @Override
    public @NonNull String getFullName4CmdLineTest() {
        String result = this.getId();
        return UtilsText.isIdentifier((CharSequence)result) ? result : UtilsText.toCIdentifier((String)result);
    }

    @Override
    public String getFullName4UI() {
        return String.valueOf(this.category) + '/' + this.name;
    }

    @Override
    public @Nullable ASdkProjectExample getLinkedMasterProject() {
        return null;
    }

    @Override
    public @Nullable ASdkProjectExample getLinkedSlaveProject() {
        return null;
    }

    @Override
    public Collection<String> getLinkedProjectIds() {
        return Collections.emptyList();
    }

    @Override
    public @Nullable String getMcuXpressoExamplePrjRelPath() {
        return null;
    }

    @Override
    public boolean isBoardSpecific() {
        return false;
    }

    @Override
    public  @Nullable SdkBoardsDescriptor.SdkBoardDescriptor getParentBoard() {
        return null;
    }
}

