/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.loader;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.files.XmlDomProvider;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsXmlDom;
import com.nxp.swtools.common.utils.xml.W3cElementListIterator;
import com.nxp.swtools.sdkmanifest.consts.SdkConsts;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class ManifestLoaderUtils {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(ManifestLoaderUtils.class);
    @NonNull
    static final String MANIFEST_FILE_EXT = ".xml";
    @NonNull
    static final String MANIFEST_V30_FILENAME_SUFFIX = "manifest.xml";
    @NonNull
    static final String MANIFEST_V3X_FILENAME_PART = "manifest_v";

    private ManifestLoaderUtils() {
    }

    public static boolean isKnownToolchain(@NonNull String toolchainId) {
        return SdkConsts.TOOLCHAIN_IDS_ORDERED.contains(toolchainId) || "atl".equals(toolchainId);
    }

    public static @NonNull List<@NonNull Element> getChildrenElements(@NonNull Element elem, @Nullable String name) {
        ArrayList<@NonNull Element> result = new ArrayList<Element>();
        W3cElementListIterator childrenIterator = new W3cElementListIterator(elem.getChildNodes());
        while (childrenIterator.hasNext()) {
            Element childElem = childrenIterator.next();
            if (name != null && !childElem.getNodeName().equals(name)) continue;
            result.add(childElem);
        }
        return result;
    }

    public static List<Element> getChildrenElements(@NonNull Element elem) {
        return ManifestLoaderUtils.getChildrenElements(elem, null);
    }

    public static @Nullable Element getChildElementByName(@NonNull Element elem, @NonNull String name) {
        List<Element> elems = ManifestLoaderUtils.getChildrenElements(elem, name);
        if (!elems.isEmpty()) {
            return elems.get(0);
        }
        return null;
    }

    public static @NonNull Map<String, Node> getAttributes(@NonNull Element elem) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        NamedNodeMap map = Objects.requireNonNull(elem.getAttributes());
        int i = map.getLength() - 1;
        while (i >= 0) {
            Node node = map.item(i);
            result.put(node.getNodeName(), node);
            --i;
        }
        return result;
    }

    private static @Nullable Document _loadManifestDocument(@NonNull Object manifestRef) {
        try {
            Document document;
            DocumentBuilderFactory factory = XmlDomProvider.createSafeDocumentBuilderFactory();
            DocumentBuilder loader = factory.newDocumentBuilder();
            if (manifestRef instanceof File) {
                document = loader.parse((File)manifestRef);
                UtilsXmlDom.setFileNameToUserData((Node)document, (String)((File)manifestRef).getAbsolutePath());
            } else if (manifestRef instanceof InputStream) {
                document = loader.parse((InputStream)manifestRef);
            } else {
                throw new IllegalArgumentException("Unsupported manifest reference type");
            }
            return document;
        }
        catch (IOException | FactoryConfigurationError | ParserConfigurationException | SAXException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public static @Nullable Document loadManifestDocument(@NonNull File manifestFile) {
        assert (!Rap.isActive());
        return ManifestLoaderUtils._loadManifestDocument(manifestFile);
    }

    public static @Nullable Document loadManifestDocument(@NonNull InputStream manifestStrm) {
        return ManifestLoaderUtils._loadManifestDocument(manifestStrm);
    }

    public static boolean is3xManifestFileName(@NonNull String fileName, @Nullable AtomicInteger major, @Nullable AtomicInteger minor) {
        String verStr;
        int separPos;
        int pos;
        if (fileName.endsWith(MANIFEST_FILE_EXT) && (pos = fileName.indexOf(MANIFEST_V3X_FILENAME_PART)) >= 0 && (separPos = (verStr = fileName.substring(pos + MANIFEST_V3X_FILENAME_PART.length(), fileName.length() - MANIFEST_FILE_EXT.length())).indexOf(95)) > 0) {
            try {
                int verMajor = Integer.parseInt(verStr.substring(0, separPos));
                int verMinor = Integer.parseInt(verStr.substring(separPos + 1));
                if (major != null && minor != null) {
                    major.set(verMajor);
                    minor.set(verMinor);
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    public static boolean is3xManifestVersionSupported(int verMajor, int verMinor) {
        return verMajor == 3 && verMinor >= 1 && verMinor <= 14;
    }

    public static boolean is3xManifestVersionSupported(@NonNull String version) {
        int minor;
        int major;
        int pos = version.indexOf(46);
        if (pos <= 0) {
            return false;
        }
        try {
            major = Integer.parseInt(version.substring(0, pos));
            minor = Integer.parseInt(version.substring(pos + 1));
        }
        catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
            return false;
        }
        return ManifestLoaderUtils.is3xManifestVersionSupported(major, minor);
    }

    public static @NonNull Collection<@NonNull String> findManifestsInDir(@Nullable String sdkSourceFilesAbsolutePath) {
        if (sdkSourceFilesAbsolutePath == null) {
            return Collections.emptyList();
        }
        File rootDir = new File(sdkSourceFilesAbsolutePath);
        if (!rootDir.isDirectory()) {
            return Collections.emptyList();
        }
        @NonNull String[] manifests = rootDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!$assertionsDisabled && name == null) {
                    throw new AssertionError();
                }
                if (!new File(String.valueOf(dir.getAbsolutePath()) + File.separator + name).isFile()) {
                    return false;
                }
                return name.endsWith(ManifestLoaderUtils.MANIFEST_V30_FILENAME_SUFFIX) || ManifestLoaderUtils.is3xManifestFileName(name, null, null);
            }
        });
        if (manifests == null || manifests.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<@NonNull String> result = new ArrayList<String>();
        String[] stringArray = manifests;
        int n = manifests.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            result.add(UtilsFile.convertToOSPathFormat((String)(String.valueOf(sdkSourceFilesAbsolutePath) + File.separator + fileName)));
            ++n2;
        }
        int index = result.size() - 1;
        while (index >= 0) {
            String manifestPath = (String)result.get(index);
            int pos = manifestPath.indexOf(MANIFEST_V3X_FILENAME_PART);
            if (pos >= 0 && ManifestLoaderUtils.is3xManifestFileName(manifestPath, null, null)) {
                result.remove(String.valueOf(manifestPath.substring(0, pos)) + MANIFEST_V30_FILENAME_SUFFIX);
            }
            --index;
        }
        return Collections.unmodifiableList(result);
    }

    public static boolean isXmlTrue(@Nullable String value) {
        return "true".equalsIgnoreCase(value = UtilsText.safeString((String)value)) || "1".equals(value);
    }
}

