/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.loader;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.descriptors.SdkTagContentVersion;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoader;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class MultipleManifestLoader {
    @Nullable
    private static List<String> problemsLog = null;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(MultipleManifestLoader.class);
    private static double minFormatVersion = 3.0;

    private static void logMergeProblem(@NonNull String problemMessage, @NonNull File manifestFile) {
        StringBuilder msg = new StringBuilder(problemMessage);
        if (problemMessage.endsWith(" ")) {
            msg.append(manifestFile.getAbsolutePath());
        } else {
            if (!problemMessage.endsWith(".")) {
                msg.append(".");
            }
            msg.append(" Found during merging ");
            msg.append(manifestFile.getAbsolutePath());
        }
        msg.insert(0, "#Manifest merge> ");
        if (problemsLog != null) {
            problemsLog.add(msg.toString());
        } else {
            LOGGER.log(Level.SEVERE, msg.toString());
        }
    }

    static @Nullable Document getMergedManifestDocument(@Nullable String sdkSourceFilesAbsolutePath, final @NonNull String processor, final @NonNull String boardIdNameFullName) {
        Collection<@NonNull String> manifestsPaths = ManifestLoaderUtils.findManifestsInDir(sdkSourceFilesAbsolutePath);
        if (manifestsPaths.isEmpty()) {
            return null;
        }
        assert (sdkSourceFilesAbsolutePath != null);
        ArrayList<ManifestDocWithFile> manifestDocuments = new ArrayList<ManifestDocWithFile>();
        for (String path : manifestsPaths) {
            File file = new File(path);
            Object ldrResult = MultipleManifestLoader.getMinFormatVersion() <= 1.1 ? ManifestLoader.loadManifestDocIfValidForJUnitTest(file) : ManifestLoader.loadManifestDocIfValid(file);
            if (ldrResult instanceof Document) {
                manifestDocuments.add(new ManifestDocWithFile((Document)ldrResult, file));
                continue;
            }
            if (ldrResult instanceof String) {
                MultipleManifestLoader.logMergeProblem((String)ldrResult, file);
                continue;
            }
            assert (false);
        }
        Collections.sort(manifestDocuments, new Comparator<ManifestDocWithFile>(){

            @Override
            public int compare(ManifestDocWithFile mnfst0, ManifestDocWithFile mnfst1) {
                SdkTagContentVersion contentVersion1;
                if (!$assertionsDisabled && mnfst0 == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && mnfst1 == null) {
                    throw new AssertionError();
                }
                Document doc0 = mnfst0.manifestDoc;
                Document doc1 = mnfst1.manifestDoc;
                if (!boardIdNameFullName.isEmpty()) {
                    if (mnfst0.isBoardSupported(boardIdNameFullName) && !mnfst1.isBoardSupported(boardIdNameFullName)) {
                        return -1;
                    }
                    if (!mnfst0.isBoardSupported(boardIdNameFullName) && mnfst1.isBoardSupported(boardIdNameFullName)) {
                        return 1;
                    }
                }
                if (!processor.isEmpty()) {
                    if (mnfst0.isProcessorSupported(processor) && !mnfst1.isProcessorSupported(processor)) {
                        return -1;
                    }
                    if (!mnfst0.isProcessorSupported(processor) && mnfst1.isProcessorSupported(processor)) {
                        return 1;
                    }
                }
                double formatVersion0 = MultipleManifestLoader.getManifestFormatVersion(doc0);
                double formatVersion1 = MultipleManifestLoader.getManifestFormatVersion(doc1);
                int cmpFV = Double.compare(formatVersion1, formatVersion0);
                if (cmpFV != 0) {
                    return cmpFV;
                }
                SdkTagContentVersion contentVersion0 = MultipleManifestLoader.getManifestContentVersion(doc0);
                int contCmpResult = contentVersion0.compareTo(contentVersion1 = MultipleManifestLoader.getManifestContentVersion(doc1));
                if (contCmpResult != 0) {
                    return contCmpResult;
                }
                if (mnfst0.hasDefaultName() && !mnfst1.hasDefaultName()) {
                    return -1;
                }
                if (!mnfst0.hasDefaultName() && mnfst1.hasDefaultName()) {
                    return 1;
                }
                return 0;
            }
        });
        Document result = null;
        double resultFormatVersion = 0.0;
        SdkTagContentVersion resultContentVersion = null;
        for (ManifestDocWithFile manifest : manifestDocuments) {
            if (result == null) {
                result = manifest.manifestDoc;
                resultFormatVersion = MultipleManifestLoader.getManifestFormatVersion(result);
                resultContentVersion = MultipleManifestLoader.getManifestContentVersion(result);
                if (!(resultFormatVersion < minFormatVersion) || manifestDocuments.size() <= 1) continue;
                MultipleManifestLoader.logMergeProblem("Manifest format_version insufficient for loading additional manifests: ", manifest.file);
                break;
            }
            assert (resultContentVersion != null);
            resultContentVersion = MultipleManifestLoader.mergeManifest(result, manifest.file, resultFormatVersion, resultContentVersion);
        }
        return result;
    }

    public static @Nullable Document getMergedManifestDocument4JUnitTest(@Nullable String sdkSourceFilesAbsolutePath) {
        return MultipleManifestLoader.getMergedManifestDocument(sdkSourceFilesAbsolutePath, "", "");
    }

    public static void setProblemsLogForJUnitTest(@Nullable List<String> log) {
        if (problemsLog != null ? !$assertionsDisabled && log != null : !$assertionsDisabled && log == null) {
            throw new AssertionError();
        }
        problemsLog = log;
    }

    public static final void saveDocToDisk(@NonNull Document doc, @NonNull String fileName) {
        File resultFile = new File(fileName);
        if (resultFile.exists() && !resultFile.delete()) {
            LOGGER.log(Level.SEVERE, "Failed to delete file: " + fileName);
        }
        try {
            if (resultFile.createNewFile()) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(resultFile);
                transformer.transform(source, result);
            }
        }
        catch (IOException | TransformerException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static double getMinFormatVersion() {
        return minFormatVersion;
    }

    public static void setMinFormatVersionForJUnitTest(double version) {
        minFormatVersion = version;
    }

    static double getManifestFormatVersion(@NonNull Document doc) {
        Element rootElem;
        block4: {
            try {
                rootElem = doc.getDocumentElement();
                if (rootElem != null && ("manifest".equals(rootElem.getNodeName()) || "ksdk:manifest".equals(rootElem.getNodeName()))) break block4;
                return -1.0;
            }
            catch (NumberFormatException numberFormatException) {
                return -1.0;
            }
        }
        String formatVersionStr = rootElem.getAttribute("format_version");
        if (!formatVersionStr.isEmpty()) {
            return Double.valueOf(formatVersionStr);
        }
        return 0.0;
    }

    public static @NonNull String getSdkConfigurationHash(@NonNull Document doc) {
        Element rootElem = doc.getDocumentElement();
        assert (rootElem != null);
        return UtilsText.safeString((String)rootElem.getAttribute("configuration"));
    }

    static void addSdkConfigurationHash(@NonNull Document doc, @NonNull String hash) {
        Element rootElem = doc.getDocumentElement();
        assert (rootElem != null);
        rootElem.setAttribute("configuration", String.valueOf(MultipleManifestLoader.getSdkConfigurationHash(doc)) + "_" + hash);
    }

    static @NonNull SdkTagContentVersion getManifestContentVersion(@NonNull Document doc) {
        Element rootElem = doc.getDocumentElement();
        if (rootElem == null || !"manifest".equals(rootElem.getNodeName()) && !"ksdk:manifest".equals(rootElem.getNodeName())) {
            return SdkTagContentVersion.valueOf("1.0", "");
        }
        return SdkTagContentVersion.valueOf(rootElem);
    }

    private static @Nullable String diffTagsContent(@Nullable Element cur_element, @Nullable Element add_element, @Nullable String mergeSubTag) {
        String addText;
        if (cur_element == add_element) {
            return null;
        }
        if (cur_element == null || add_element == null) {
            return "Tag not found";
        }
        if (!cur_element.getNodeName().equals(add_element.getNodeName())) {
            return "Tag name does not match";
        }
        NamedNodeMap curAttrs = Objects.requireNonNull(cur_element.getAttributes());
        Map<String, Node> addAttrs = ManifestLoaderUtils.getAttributes(add_element);
        if (curAttrs.getLength() != addAttrs.size()) {
            return "Number of attributes does not match in tag `" + cur_element.getNodeName() + '`';
        }
        int curAttrIndex = 0;
        while (curAttrIndex < curAttrs.getLength()) {
            Node curAttr = curAttrs.item(curAttrIndex);
            assert (curAttr != null);
            String curAttrName = curAttr.getNodeName();
            assert (curAttrName != null);
            Node addAttr = addAttrs.get(curAttrName);
            if (addAttr == null) {
                return "Attribute not found: " + cur_element.getNodeName() + '/' + curAttrName;
            }
            if (!Objects.equals(curAttr.getTextContent(), addAttr.getTextContent())) {
                return "Attribute value does not match: " + cur_element.getNodeName() + '/' + curAttrName + ':' + curAttr.getTextContent() + '<' + '>' + addAttr.getTextContent();
            }
            addAttrs.remove(curAttr.getNodeName());
            ++curAttrIndex;
        }
        List<Element> curChildren = ManifestLoaderUtils.getChildrenElements(cur_element);
        List<Element> addChildren = ManifestLoaderUtils.getChildrenElements(add_element);
        if (curChildren.size() != addChildren.size()) {
            return "Number of child attributes does not match in tag: " + cur_element.getNodeName();
        }
        for (Element curChild : curChildren) {
            boolean tagFound = false;
            ListIterator<Element> addChildIterator = addChildren.listIterator();
            while (addChildIterator.hasNext()) {
                Element addChild = addChildIterator.next();
                if (mergeSubTag != null && mergeSubTag.equals(addChild.getNodeName())) {
                    tagFound = true;
                    continue;
                }
                if (MultipleManifestLoader.diffTagsContent(curChild, addChild, null) != null) continue;
                tagFound = true;
                addChildIterator.remove();
                break;
            }
            if (tagFound) continue;
            return "Child tag not found: " + cur_element.getNodeName() + '/' + curChild.getNodeName();
        }
        String curText = UtilsText.safeString((String)cur_element.getTextContent()).trim();
        if (!curText.equals(addText = UtilsText.safeString((String)add_element.getTextContent()).trim())) {
            return "Tag text value does not match in tag: " + cur_element.getNodeName();
        }
        return null;
    }

    private static @Nullable String checkComponentsAttributes(@NonNull Element tag) {
        assert (tag.getNodeName().equals("components"));
        NamedNodeMap attrs = Objects.requireNonNull(tag.getAttributes());
        if (attrs.getLength() == 0) {
            return null;
        }
        if (attrs.getLength() != 2) {
            return "Either two ('for' and 'id') or no attributes are supported for 'components' tag.";
        }
        if (attrs.getNamedItem("for") == null || attrs.getNamedItem("id") == null) {
            return "'for' or 'id' attribute not found in 'components' tag.";
        }
        return null;
    }

    private static @NonNull Set<String> getFullDeviceNames(@NonNull Element root) {
        HashSet<String> result = new HashSet<String>();
        Element devicesElem = ManifestLoaderUtils.getChildElementByName(root, "devices");
        if (devicesElem != null) {
            List<Element> devicesNodeList = ManifestLoaderUtils.getChildrenElements(devicesElem, "device");
            for (Element device : devicesNodeList) {
                assert (device != null);
                if (!device.hasAttribute("full_name")) continue;
                result.add(device.getAttribute("full_name"));
            }
        }
        return result;
    }

    private static @Nullable String getComponentsTagAttribute(@NonNull Element tag, @NonNull String attrName) {
        assert (tag.getNodeName().equals("components"));
        assert (attrName.equals("id") || attrName.equals("for"));
        if (tag.hasAttribute(attrName)) {
            return tag.getAttribute(attrName);
        }
        Element root = tag;
        while (Objects.requireNonNull(root).getParentNode() != null && root.getParentNode() instanceof Element) {
            root = (Element)root.getParentNode();
        }
        Element ksdkElem = ManifestLoaderUtils.getChildElementByName(root, "ksdk");
        if (ksdkElem == null) {
            return "'ksdk' tag not found in manifest";
        }
        if (!ksdkElem.hasAttribute("version")) {
            return "Attribute ksdk/version not found";
        }
        String version = ksdkElem.getAttribute("version");
        assert (version != null);
        if (!ksdkElem.hasAttribute("name")) {
            return "Attribute ksdk/name not found";
        }
        String name = ksdkElem.getAttribute("name");
        assert (name != null);
        if (!ksdkElem.hasAttribute("id")) {
            return "Attribute ksdk/id not found";
        }
        String id = ksdkElem.getAttribute("id");
        assert (id != null);
        String result = ManifestLoader.getSdk13RepositoryFromDeviceName(version, name, id, MultipleManifestLoader.getFullDeviceNames(root), attrName.equals("for"));
        if (result != null) {
            tag.setAttribute(attrName, result);
        } else {
            result = attrName.equals("for") ? name : id;
        }
        return result;
    }

    private static @Nullable String findSubTagsForMerge(@NonNull Element curRoot, @NonNull Element addRoot, @NonNull String tagName, boolean allowAttrs, @NonNull String subTagName, @NonNull String keyAttrName, @Nullable String key2AttrName, @Nullable String key3AttrName, int contentVerCmp, @NonNull Map<Element, Element> forMerge, @NonNull Map<Element, Element> toReplace) {
        Element cur_list_elem = ManifestLoaderUtils.getChildElementByName(curRoot, tagName);
        Element add_list_elem = ManifestLoaderUtils.getChildElementByName(addRoot, tagName);
        if (cur_list_elem == null) {
            if (add_list_elem == null) {
                assert (false);
                return null;
            }
            cur_list_elem = Objects.requireNonNull(curRoot.getOwnerDocument()).createElement(tagName);
            curRoot.appendChild(cur_list_elem);
        }
        if (add_list_elem == null) {
            return null;
        }
        if (Objects.requireNonNull(cur_list_elem.getAttributes()).getLength() > 0 || Objects.requireNonNull(add_list_elem.getAttributes()).getLength() > 0) {
            if (!allowAttrs) {
                return "No attributes supported for tag " + tagName;
            }
            assert (tagName.equals("components"));
            String err = MultipleManifestLoader.checkComponentsAttributes(cur_list_elem);
            if (err != null) {
                return err;
            }
            err = MultipleManifestLoader.checkComponentsAttributes(add_list_elem);
            if (err != null) {
                return err;
            }
            String curFor = MultipleManifestLoader.getComponentsTagAttribute(cur_list_elem, "for");
            String addFor = MultipleManifestLoader.getComponentsTagAttribute(add_list_elem, "for");
            if (curFor == null || !curFor.equals(addFor)) {
                return "Attribute 'for' does not match in tag: " + tagName;
            }
            String curId = MultipleManifestLoader.getComponentsTagAttribute(cur_list_elem, "id");
            String addId = MultipleManifestLoader.getComponentsTagAttribute(add_list_elem, "id");
            if (curId == null || !curId.equals(addId)) {
                return UtilsText.format((String)"Attribute `{0}` does not match in tag", (Object[])new Object[]{"id"});
            }
        }
        HashSet<String> subTagIds = new HashSet<String>();
        List<Element> addChildrenList = ManifestLoaderUtils.getChildrenElements(add_list_elem, subTagName);
        if (!addChildrenList.isEmpty()) {
            List<Element> curChildrenNodeList = ManifestLoaderUtils.getChildrenElements(cur_list_elem, subTagName);
            ArrayList<Element> curChildren = new ArrayList<Element>();
            Iterator<Element> curChildrenIterator = curChildrenNodeList.iterator();
            while (curChildrenIterator.hasNext()) {
                curChildren.add(curChildrenIterator.next());
            }
            for (Element addElem : addChildrenList) {
                String addKey2AttrVal;
                if (!addElem.hasAttribute(keyAttrName)) {
                    return String.valueOf(UtilsText.format((String)"Attribute ''{0}'' not found in tag: ", (Object[])new Object[]{keyAttrName})) + tagName + '/' + subTagName;
                }
                String addKeyAttrVal = addElem.getAttribute(keyAttrName);
                if (key2AttrName != null) {
                    if (!addElem.hasAttribute(key2AttrName)) {
                        return String.valueOf(UtilsText.format((String)"Attribute ''{0}'' not found in tag: ", (Object[])new Object[]{key2AttrName})) + tagName + '/' + subTagName;
                    }
                    addKey2AttrVal = addElem.getAttribute(key2AttrName);
                } else {
                    addKey2AttrVal = null;
                }
                String addKey3AttrVal = key3AttrName != null ? (!addElem.hasAttribute(key3AttrName) ? null : addElem.getAttribute(key3AttrName)) : null;
                SdkTagContentVersion addVersion = SdkTagContentVersion.valueOf(addElem);
                String subTagValueId = String.valueOf(addKeyAttrVal) + (addKey2AttrVal == null ? "" : String.valueOf('/') + addKey2AttrVal) + (addKey3AttrVal == null ? "" : String.valueOf('/') + addKey3AttrVal) + '/' + addVersion;
                if (!subTagIds.add(subTagValueId)) {
                    return UtilsText.format((String)"Tag ''{0}'' identified by ''{1}'' is not unique", (Object[])new Object[]{String.valueOf(tagName) + '/' + subTagName, String.valueOf(keyAttrName) + '=' + subTagValueId});
                }
                boolean foundSameOrOlderElem = false;
                ListIterator curElemIterator = curChildren.listIterator();
                while (curElemIterator.hasNext()) {
                    boolean matchesKey3;
                    boolean matchesKey2;
                    Element curElem = (Element)curElemIterator.next();
                    if (!curElem.hasAttribute(keyAttrName)) {
                        return String.valueOf(UtilsText.format((String)"Attribute ''{0}'' not found in tag: ", (Object[])new Object[]{keyAttrName})) + tagName + '/' + subTagName;
                    }
                    String curKeyAttr = curElem.getAttribute(keyAttrName);
                    if (key2AttrName != null) {
                        if (!curElem.hasAttribute(key2AttrName)) {
                            return String.valueOf(UtilsText.format((String)"Attribute ''{0}'' not found in tag: ", (Object[])new Object[]{key2AttrName})) + tagName + '/' + subTagName;
                        }
                        String curKey2Attr = curElem.getAttribute(key2AttrName);
                        assert (addKey2AttrVal != null);
                        matchesKey2 = addKey2AttrVal.equals(curKey2Attr);
                    } else {
                        matchesKey2 = true;
                    }
                    if (key3AttrName != null) {
                        String curKey3AttrVal = !curElem.hasAttribute(key3AttrName) ? null : curElem.getAttribute(key3AttrName);
                        matchesKey3 = UtilsText.safeString((String)addKey3AttrVal).equals(UtilsText.safeString((String)curKey3AttrVal));
                    } else {
                        matchesKey3 = true;
                    }
                    SdkTagContentVersion curVersion = SdkTagContentVersion.valueOf(curElem);
                    if (!curKeyAttr.equals(addKeyAttrVal) || !matchesKey2 || !matchesKey3 || !curVersion.equals(addVersion)) continue;
                    if (curVersion.equals(addVersion)) {
                        if (contentVerCmp == 0) {
                            String mergeSubTagName = "boards".equals(tagName) ? "examples" : null;
                            String err = MultipleManifestLoader.diffTagsContent(curElem, addElem, mergeSubTagName);
                            if (err != null) {
                                return "Failed due to different content of tag '" + subTagName + "' with attribute " + keyAttrName + '=' + addKeyAttrVal + ':' + " " + err;
                            }
                            if (mergeSubTagName != null) {
                                Element curSubElem = ManifestLoaderUtils.getChildElementByName(curElem, mergeSubTagName);
                                Element addSubElem = ManifestLoaderUtils.getChildElementByName(addElem, mergeSubTagName);
                                if (curSubElem != null && addSubElem != null) {
                                    assert (mergeSubTagName.charAt(mergeSubTagName.length() - 1) == 's');
                                    String mergeTag = UtilsText.safeString((String)mergeSubTagName.substring(0, mergeSubTagName.length() - 1));
                                    String failMsg = MultipleManifestLoader.findSubTagsForMerge(curElem, addElem, mergeSubTagName, true, mergeTag, "name", "category", null, contentVerCmp, forMerge, toReplace);
                                    if (failMsg != null) {
                                        return failMsg;
                                    }
                                }
                            }
                            curElemIterator.remove();
                            foundSameOrOlderElem = true;
                            break;
                        }
                        if (contentVerCmp < 0) {
                            toReplace.put(curElem, cur_list_elem);
                            break;
                        }
                        foundSameOrOlderElem = true;
                        break;
                    }
                    if (curVersion.compareTo(addVersion) < 0) {
                        toReplace.put(curElem, cur_list_elem);
                        break;
                    }
                    foundSameOrOlderElem = true;
                    break;
                }
                if (foundSameOrOlderElem) continue;
                forMerge.put(addElem, cur_list_elem);
            }
        }
        return null;
    }

    private static @NonNull SdkTagContentVersion mergeManifest(@NonNull Document manifestDoc, @NonNull File manifestFile, double formatVersion, @NonNull SdkTagContentVersion contentVersion) {
        String err;
        HashMap<Element, Element> toReplace;
        HashMap<Element, Element> forMerge;
        Element add_ksdk_elem;
        Element cur_api_elem;
        Element add_ksdkElem;
        assert (formatVersion >= minFormatVersion);
        Document doc = ManifestLoaderUtils.loadManifestDocument(manifestFile);
        if (doc == null) {
            MultipleManifestLoader.logMergeProblem("Failed to parse manifest XML file: ", manifestFile);
            return contentVersion;
        }
        double addFormatVersion = MultipleManifestLoader.getManifestFormatVersion(doc);
        if (addFormatVersion != formatVersion) {
            LOGGER.info("Ignored XML manifest file, because attributes format_version do not match in " + manifestFile.toString());
            return contentVersion;
        }
        SdkTagContentVersion addContentVersion = MultipleManifestLoader.getManifestContentVersion(doc);
        int contCompare = contentVersion.compareTo(addContentVersion);
        Element curRoot = manifestDoc.getDocumentElement();
        Element addRoot = doc.getDocumentElement();
        if (curRoot == null || addRoot == null || !curRoot.getNodeName().equals(addRoot.getNodeName())) {
            MultipleManifestLoader.logMergeProblem("Merge failed, root elements do not match with ", manifestFile);
            return contentVersion;
        }
        Element cur_ksdkElem = ManifestLoaderUtils.getChildElementByName(curRoot, "ksdk");
        String diffMsg = MultipleManifestLoader.diffTagsContent(cur_ksdkElem, add_ksdkElem = ManifestLoaderUtils.getChildElementByName(addRoot, "ksdk"), null);
        if (diffMsg != null) {
            MultipleManifestLoader.logMergeProblem(UtilsText.format((String)"Merge failed, {0} tags are not same - {1}", (Object[])new Object[]{"ksdk", diffMsg}), manifestFile);
            return contentVersion;
        }
        if (addFormatVersion < 3.0 && (diffMsg = MultipleManifestLoader.diffTagsContent(cur_api_elem = ManifestLoaderUtils.getChildElementByName(curRoot, "api"), add_ksdk_elem = ManifestLoaderUtils.getChildElementByName(addRoot, "api"), null)) != null) {
            MultipleManifestLoader.logMergeProblem(UtilsText.format((String)"Merge failed, {0} tags are not same - {1}", (Object[])new Object[]{"api", diffMsg}), manifestFile);
            return contentVersion;
        }
        String idAttr = addFormatVersion < 3.0 ? "name" : "id";
        String err2 = MultipleManifestLoader.findSubTagsForMerge(curRoot, addRoot, "compilers", false, "compiler", idAttr, null, null, contCompare, forMerge = new HashMap<Element, Element>(), toReplace = new HashMap<Element, Element>());
        if (err2 != null) {
            MultipleManifestLoader.logMergeProblem(err2, manifestFile);
            return contentVersion;
        }
        if ((formatVersion < 3.0 || addFormatVersion < 3.0) && (err = MultipleManifestLoader.findSubTagsForMerge(curRoot, addRoot, "toolchains", false, "toolchain", "name", null, null, contCompare, forMerge, toReplace)) != null) {
            MultipleManifestLoader.logMergeProblem(err, manifestFile);
            return contentVersion;
        }
        if ((formatVersion >= 3.0 || addFormatVersion >= 3.0) && (err2 = MultipleManifestLoader.findSubTagsForMerge(curRoot, addRoot, "toolchainSettings", false, "toolchainSetting", idAttr = addFormatVersion < 3.0 ? "name" : "id", null, null, contCompare, forMerge, toReplace)) != null) {
            MultipleManifestLoader.logMergeProblem(err2, manifestFile);
            return contentVersion;
        }
        err = MultipleManifestLoader.findSubTagsForMerge(curRoot, addRoot, "boards", false, "board", "id", null, null, contCompare, forMerge, toReplace);
        if (err != null) {
            MultipleManifestLoader.logMergeProblem(err, manifestFile);
            return contentVersion;
        }
        idAttr = addFormatVersion < 3.0 ? "full_name" : "id";
        err2 = MultipleManifestLoader.findSubTagsForMerge(curRoot, addRoot, "devices", false, "device", idAttr, null, null, contCompare, forMerge, toReplace);
        if (err2 != null) {
            MultipleManifestLoader.logMergeProblem(err2, manifestFile);
            return contentVersion;
        }
        String devicesAttr = addFormatVersion < 3.0 ? "device" : "devices";
        err2 = MultipleManifestLoader.findSubTagsForMerge(curRoot, addRoot, "components", true, "component", "name", "type", devicesAttr, contCompare, forMerge, toReplace);
        if (err2 != null) {
            MultipleManifestLoader.logMergeProblem(err2, manifestFile);
            return contentVersion;
        }
        if (ManifestLoaderUtils.getChildElementByName(addRoot, "defines") != null) {
            Element cur_list_elem = ManifestLoaderUtils.getChildElementByName(curRoot, "defines");
            Element add_list_elem = ManifestLoaderUtils.getChildElementByName(addRoot, "defines");
            if (cur_list_elem != null || add_list_elem != null) {
                if (cur_list_elem == null) {
                    forMerge.put(add_list_elem, curRoot);
                } else if (add_list_elem != null) {
                    SdkTagContentVersion curVersion = SdkTagContentVersion.valueOf(cur_list_elem);
                    SdkTagContentVersion addVersion = SdkTagContentVersion.valueOf(add_list_elem);
                    if (addVersion.compareTo(curVersion) > 0 || addVersion.compareTo(curVersion) == 0 && contCompare < 0) {
                        forMerge.put(add_list_elem, curRoot);
                    }
                }
            }
        }
        for (Map.Entry entry : toReplace.entrySet()) {
            ((Element)entry.getValue()).removeChild((Node)entry.getKey());
        }
        for (Map.Entry entry : forMerge.entrySet()) {
            ((Element)entry.getValue()).appendChild(Objects.requireNonNull(((Element)entry.getValue()).getOwnerDocument()).importNode((Node)entry.getKey(), true));
        }
        MultipleManifestLoader.addSdkConfigurationHash(manifestDoc, MultipleManifestLoader.getSdkConfigurationHash(doc));
        return contentVersion.compareTo(addContentVersion) > 0 ? contentVersion : addContentVersion;
    }

    private static class ManifestDocWithFile {
        @NonNull
        final Document manifestDoc;
        @NonNull
        final File file;
        @Nullable
        Boolean isSelProcessorSupported = null;
        @Nullable
        Boolean isSelBoardSupported = null;

        ManifestDocWithFile(@NonNull Document manifestDoc, @NonNull File file) {
            this.manifestDoc = manifestDoc;
            this.file = file;
        }

        boolean hasDefaultName() {
            return "ksdk_manifest.xml".equals(this.file.getName());
        }

        boolean isProcessorSupported(@NonNull String processorFullName) {
            if (this.isSelProcessorSupported != null) {
                return this.isSelProcessorSupported;
            }
            boolean result = false;
            Element root = this.manifestDoc.getDocumentElement();
            assert (root != null);
            Element devicesElem = ManifestLoaderUtils.getChildElementByName(root, "devices");
            if (devicesElem != null) {
                List<Element> deviceElems = ManifestLoaderUtils.getChildrenElements(devicesElem, "device");
                for (Element deviceElem : deviceElems) {
                    if (!processorFullName.equals(deviceElem.getAttribute("full_name"))) continue;
                    result = true;
                    break;
                }
            }
            this.isSelProcessorSupported = result;
            return result;
        }

        boolean isBoardSupported(@NonNull String boardIdNameFullName) {
            if (this.isSelBoardSupported != null) {
                return this.isSelBoardSupported;
            }
            boolean result = false;
            Element root = this.manifestDoc.getDocumentElement();
            assert (root != null);
            Element boardsElem = ManifestLoaderUtils.getChildElementByName(root, "boards");
            if (boardsElem != null) {
                List<Element> boardElems = ManifestLoaderUtils.getChildrenElements(boardsElem, "board");
                for (Element boardElem : boardElems) {
                    if (!(boardElem.hasAttribute("id") && boardIdNameFullName.equals(boardElem.getAttribute("id")) || boardElem.hasAttribute("full_name") && boardIdNameFullName.equals(boardElem.getAttribute("full_name"))) && (!boardElem.hasAttribute("name") || !boardIdNameFullName.equals(boardElem.getAttribute("name")))) continue;
                    result = true;
                    break;
                }
            }
            this.isSelBoardSupported = result;
            return result;
        }

        public String toString() {
            return this.file.getName();
        }
    }
}

